/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger.sdp;

import com.sun.squawk.DebuggerSupport;
import com.sun.squawk.Field;
import com.sun.squawk.Klass;
import com.sun.squawk.ScopedLocalVariable;
import com.sun.squawk.debugger.CommandPacket;
import com.sun.squawk.debugger.DataType;
import com.sun.squawk.debugger.JDWP;
import com.sun.squawk.debugger.JDWPListener;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.PacketInputStream;
import com.sun.squawk.debugger.PacketOutputStream;
import com.sun.squawk.debugger.ReplyPacket;
import com.sun.squawk.debugger.SDWPException;
import com.sun.squawk.debugger.sdp.ProxyField;
import com.sun.squawk.debugger.sdp.ProxyMethod;
import com.sun.squawk.debugger.sdp.ProxyThread;
import com.sun.squawk.debugger.sdp.ProxyType;
import com.sun.squawk.debugger.sdp.ProxyTypeManager;
import com.sun.squawk.debugger.sdp.SDAListener;
import com.sun.squawk.debugger.sdp.SDP;
import com.sun.squawk.debugger.sdp.SDPCommandSet;
import com.sun.squawk.debugger.sdp.UndefinedProxyType;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.IntHashtable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

class JDBListener
extends JDWPListener {
    private final SDP sdp;
    private final IntHashtable commandSets = new IntHashtable();
    boolean debuggerAskedSizes = false;
    boolean debuggerKnowsSizes = false;

    public JDBListener(SDP sdp) {
        this.sdp = sdp;
        this.commandSets.put(1, (Object)new VirtualMachine());
        this.commandSets.put(2, (Object)new ReferenceType());
        this.commandSets.put(6, (Object)new Method());
        this.commandSets.put(3, (Object)new ClassType());
        this.commandSets.put(11, (Object)new ThreadReference());
        this.commandSets.put(12, (Object)new ThreadGroupReference());
        this.commandSets.put(15, (Object)new EventRequest());
        this.commandSets.put(9, (Object)new ObjectReference());
    }

    public synchronized void processCommand(CommandPacket command) throws IOException {
        SDPCommandSet handler = (SDPCommandSet)((Object)this.commandSets.get(command.set()));
        if (handler == null || !handler.handle(this.sdp, this, this.otherHost, command)) {
            try {
                this.otherHost.sendCommand(command);
            }
            catch (SDWPException e) {
                // empty catch block
            }
            ReplyPacket sdaReply = command.getReply();
            this.sendReply(sdaReply);
            if (this.debuggerAskedSizes && !this.debuggerKnowsSizes) {
                if (Log.info()) {
                    Log.log((String)"Start forwarding events from SDA to debugger");
                }
                ((SDAListener)this.otherHost).enableForwardedEvents();
                this.debuggerKnowsSizes = true;
            }
        }
    }

    public String sourceName() {
        return "Debugger";
    }

    static final class EventRequest
    extends SDPCommandSet {
        EventRequest() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            switch (this.command.command()) {
                case 1: {
                    return this.Set();
                }
                case 2: {
                    return this.Clear();
                }
            }
            return false;
        }

        private boolean Set() throws SDWPException, IOException {
            int id = this.sdp.eventManager.registerEventRequest(this.in);
            if (id == -1) {
                return false;
            }
            this.out.writeInt(id, "requestID");
            return true;
        }

        private boolean Clear() throws SDWPException, IOException {
            byte eventKind = this.in.readByte("eventKind");
            int requestID = this.in.readInt("requestID");
            if (requestID == 0) {
                if (Log.info()) {
                    Log.log((String)"Requests with ID of zero are reserved for automatic events, and can't be cleared. Fail without error.");
                }
                return true;
            }
            return this.sdp.eventManager.clear(eventKind, requestID);
        }

        protected void sentReply(ReplyPacket reply) throws IOException {
        }
    }

    static final class ThreadGroupReference
    extends SDPCommandSet {
        ThreadGroupReference() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            DataType.ObjectID threadGroupID = this.in.readObjectID("group");
            if (!threadGroupID.equals((Object)DataType.ObjectID.THREAD_GROUP)) {
                throw new SDWPException(11, "invalid thread group ID: " + threadGroupID);
            }
            switch (this.command.command()) {
                case 1: {
                    this.Name();
                    break;
                }
                case 2: {
                    this.Parent();
                    break;
                }
                case 3: {
                    this.Children();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void Children() throws IOException, SDWPException {
            Collection<ProxyThread> threads = this.sdp.getTPM().getThreads();
            Assert.that((!threads.isEmpty() ? 1 : 0) != 0);
            this.out.writeInt(threads.size(), "childThreads");
            for (ProxyThread thread : threads) {
                this.out.writeObjectID(thread.id, "childThread");
            }
            this.out.writeInt(0, "childGroups");
        }

        private void Parent() throws IOException {
            this.out.writeObjectID(DataType.ObjectID.NULL, "parentGroup");
        }

        private void Name() throws IOException {
            String name = ((SDAListener)this.otherHost).getIsolateName();
            if (name == null) {
                name = "???";
            }
            this.out.writeString("Isolate: " + name, "groupName");
        }
    }

    final class ObjectReference
    extends SDPCommandSet {
        ObjectReference() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            switch (this.command.command()) {
                case 3: {
                    this.SetValues();
                    return true;
                }
            }
            return false;
        }

        private void SetValues() throws SDWPException, IOException {
            CommandPacket sdaCommand = new CommandPacket(9, 3, true);
            PacketOutputStream sdaOut = sdaCommand.getOutputStream();
            sdaOut.writeObjectID(this.in.readObjectID("obj"), "obj");
            int count = this.in.readInt("fields");
            sdaOut.writeInt(count, "count");
            for (int i = 0; i < count; ++i) {
                DataType.FieldID fieldID = this.in.readFieldID("fieldID");
                ProxyType type = this.sdp.getPTM().lookup(fieldID.definingClass, true);
                Field f = type.getField(fieldID).getField();
                Klass fieldType = f.getType();
                sdaOut.writeFieldID(fieldID, "field");
                sdaOut.writeReferenceTypeID(this.sdp.getPTM().lookup(fieldType, true).getID(), "field type");
                sdaOut.copyValue((int)fieldID.getTag(), this.in);
            }
            ReplyPacket sdaReply = this.otherHost.sendCommand(sdaCommand);
            JDBListener.this.sendReply(sdaReply);
        }
    }

    static final class Method
    extends SDPCommandSet {
        Method() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            DataType.ReferenceTypeID typeID = this.in.readReferenceTypeID("refType");
            DataType.MethodID methodID = this.in.readMethodID("methodID");
            ProxyType type = this.sdp.getPTM().lookup(typeID, true);
            ProxyMethod method = type.getMethod(methodID);
            if (method == null) {
                throw new SDWPException(23, "Couldn't find method for ID " + methodID);
            }
            switch (this.command.command()) {
                case 1: {
                    this.LineTable(type, method);
                    break;
                }
                case 2: {
                    this.VariableTable(type, method);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void LineTable(ProxyType type, ProxyMethod method) throws SDWPException, IOException {
            ProxyMethod.LineNumberTable lnt = method.getLineNumberTable();
            Assert.that((lnt != null ? 1 : 0) != 0);
            ProxyMethod.LineNumberTable.Entry[] entries = lnt.entries;
            this.out.writeLong(lnt.start, "start");
            this.out.writeLong(lnt.end, "end");
            this.out.writeInt(entries.length, "lines");
            for (int i = 0; i != entries.length; ++i) {
                this.out.writeLong(entries[i].lineCodeIndex, "lineCodeIndex");
                this.out.writeInt(entries[i].lineNumber, "lineNumber");
            }
        }

        private void VariableTable(ProxyType type, ProxyMethod method) throws SDWPException, IOException {
            ScopedLocalVariable[] vt = method.getVariableTable();
            Assert.that((vt != null ? 1 : 0) != 0);
            this.out.writeInt(method.getArgCount(), "argCnt");
            this.out.writeInt(vt.length, "slots");
            for (int i = 0; i != vt.length; ++i) {
                this.out.writeLong((long)vt[i].start, "codeIndex");
                this.out.writeString(vt[i].name, "name");
                this.out.writeString(DebuggerSupport.getJNISignature((Klass)vt[i].type), "signature");
                this.out.writeInt(vt[i].length, "length");
                this.out.writeInt(vt[i].slot, "slot");
            }
        }
    }

    final class ClassType
    extends SDPCommandSet {
        ClassType() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            switch (this.command.command()) {
                case 1: {
                    this.Superclass();
                    return true;
                }
                case 2: {
                    this.SetValues();
                    return true;
                }
            }
            return false;
        }

        private void Superclass() throws SDWPException, IOException {
            DataType.ReferenceTypeID typeID = this.in.readReferenceTypeID("clazz");
            ProxyType type = this.sdp.getPTM().lookup(typeID, true);
            ProxyType superType = type.getSuperclass();
            if (superType == null) {
                this.out.writeReferenceTypeID(DataType.ReferenceTypeID.NULL, "superclass");
            } else {
                this.out.writeReferenceTypeID(superType.getID(), "superclass");
            }
        }

        private void SetValues() throws SDWPException, IOException {
            CommandPacket sdaCommand = new CommandPacket(3, 2, true);
            PacketOutputStream sdaOut = sdaCommand.getOutputStream();
            DataType.ReferenceTypeID typeID = this.in.readReferenceTypeID("clazz");
            ProxyType type = this.sdp.getPTM().lookup(typeID, true);
            sdaOut.writeReferenceTypeID(typeID, "clazz");
            int count = this.in.readInt("values");
            sdaOut.writeInt(count, "values");
            for (int i = 0; i < count; ++i) {
                DataType.FieldID fieldID = this.in.readFieldID("fieldID");
                ProxyType ftype = this.sdp.getPTM().lookup(fieldID.definingClass, true);
                Field f = ftype.getField(fieldID).getField();
                Klass fieldType = f.getType();
                if (!f.isStatic()) {
                    throw new SDWPException(25, "Field is not static " + fieldID);
                }
                if (f.isFinal()) {
                    throw new SDWPException(25, "Field is static final " + fieldID);
                }
                sdaOut.writeFieldID(fieldID, "fieldID");
                sdaOut.writeReferenceTypeID(this.sdp.getPTM().lookup(fieldType, true).getID(), "field type");
                sdaOut.copyValue((int)fieldID.getTag(), this.in);
            }
            ReplyPacket sdaReply = this.otherHost.sendCommand(sdaCommand);
            JDBListener.this.sendReply(sdaReply);
        }
    }

    static final class ThreadReference
    extends SDPCommandSet {
        ThreadReference() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            switch (this.command.command()) {
                case 5: {
                    this.ThreadGroup();
                    break;
                }
                case 1: {
                    this.Name();
                    break;
                }
                case 4: {
                    this.Status();
                    break;
                }
                case 6: {
                    this.Frames();
                    break;
                }
                case 8: 
                case 9: {
                    this.unimplemented();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void ThreadGroup() throws IOException {
            this.out.writeObjectID(DataType.ObjectID.THREAD_GROUP, "group");
        }

        private void Frames() throws SDWPException, IOException {
            DataType.ObjectID threadID = this.in.readObjectID("thread");
            ProxyThread thread = this.sdp.getTPM().getThread(threadID);
            if (!thread.isSuspended()) {
                this.out.writeInt(0, "frames");
                return;
            }
            ReplyPacket sdaReply = this.otherHost.sendCommand(this.command);
            PacketInputStream sdaIn = sdaReply.getInputStream();
            int frameCount = sdaIn.readInt("frames");
            this.out.writeInt(frameCount, "frames");
            for (int i = 0; i != frameCount; ++i) {
                DataType.FrameID frameID = sdaIn.readFrameID("frameID");
                DataType.Location loc = sdaIn.readLocation("location");
                this.out.writeFrameID(frameID, "frameID");
                ProxyType type = this.sdp.getPTM().lookup(loc.definingClass, true);
                if (type instanceof UndefinedProxyType) {
                    this.out.writeLocation(new DataType.Location(1, loc.definingClass, DataType.MethodID.UNKNOWN, 0L), "location");
                    continue;
                }
                this.out.writeLocation(loc, "location");
            }
        }

        private void Name() throws SDWPException, IOException {
            DataType.ObjectID threadID = this.in.readObjectID("thread");
            ProxyThread thread = this.sdp.getTPM().getThread(threadID);
            this.out.writeString(thread.getName(), "threadname");
        }

        private void Status() throws SDWPException, IOException {
            DataType.ObjectID threadID = this.in.readObjectID("thread");
            ProxyThread thread = this.sdp.getTPM().getThread(threadID);
            this.out.writeInt(thread.getStatus(), "threadStatus");
            this.out.writeInt(thread.isSuspended() ? 1 : 0, "suspendStatus");
        }
    }

    static final class ReferenceType
    extends SDPCommandSet {
        ReferenceType() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            DataType.ReferenceTypeID typeID = this.in.readReferenceTypeID("refType");
            ProxyType type = this.sdp.getPTM().lookup(typeID, true);
            switch (this.command.command()) {
                case 1: {
                    this.Signature(type);
                    break;
                }
                case 2: {
                    this.ClassLoader();
                    break;
                }
                case 3: {
                    this.Modifiers(type);
                    break;
                }
                case 4: {
                    this.Fields(type);
                    break;
                }
                case 5: {
                    this.Methods(type);
                    break;
                }
                case 7: {
                    this.SourceFile(type);
                    break;
                }
                case 10: {
                    this.Interfaces(type);
                    break;
                }
                case 6: {
                    this.GetValues(type);
                    break;
                }
                case 9: {
                    this.Status(type);
                    break;
                }
                case 8: {
                    this.unimplemented();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void Interfaces(ProxyType type) throws IOException, SDWPException {
            List interfaces = type.getInterfaces();
            this.out.writeInt(interfaces.size(), "interfaces");
            for (int i = 0; i < interfaces.size(); ++i) {
                ProxyType intf = (ProxyType)interfaces.get(i);
                this.out.writeReferenceTypeID(intf.getID(), "interfaceType");
            }
        }

        private void Status(ProxyType type) throws IOException {
            this.out.writeInt(7, "status");
        }

        private void SourceFile(ProxyType type) throws IOException {
            String sourceName = type.getSourceName();
            if (sourceName != null) {
                this.out.writeString(sourceName, "sourceFile");
            } else {
                sourceName = type.getName();
                int lastDot = sourceName.lastIndexOf(46);
                if (lastDot != -1) {
                    sourceName = sourceName.substring(lastDot);
                }
                sourceName = sourceName + ".java";
                this.out.writeString(sourceName, "sourceFile");
            }
        }

        private void Methods(ProxyType type) throws IOException {
            List methods = type.getMethods();
            this.out.writeInt(methods.size(), "declared");
            for (int i = 0; i < methods.size(); ++i) {
                ProxyMethod method = (ProxyMethod)methods.get(i);
                this.out.writeMethodID(method.getID(), "methodID");
                this.out.writeString(method.getName(), "name");
                this.out.writeString(method.getSignature(), "signature");
                this.out.writeInt(method.getModifiers(), "modBits");
            }
        }

        private void Fields(ProxyType type) throws IOException, SDWPException {
            List fields = type.getFields();
            this.out.writeInt(fields.size(), "declared");
            for (int i = 0; i < fields.size(); ++i) {
                ProxyField fi = (ProxyField)fields.get(i);
                this.out.writeFieldID(fi.getID(), "fieldID");
                this.out.writeString(fi.getName(), "name");
                this.out.writeString(fi.getSignature(), "signature");
                this.out.writeInt(fi.getModifiers(), "modBits");
            }
        }

        private void Modifiers(ProxyType type) throws IOException {
            this.out.writeInt(type.getModifiers(), "signature");
        }

        private void ClassLoader() throws IOException {
            this.out.writeReferenceTypeID(DataType.ReferenceTypeID.NULL, "classLoader");
        }

        private void Signature(ProxyType type) throws IOException {
            this.out.writeString(type.getSignature(), "signature");
        }

        private static boolean isPrimitiveConstantField(Field f) {
            return f.isFinal() && f.hasConstant() && f.getType().isPrimitive();
        }

        private void GetValues(ProxyType requestKlass) throws SDWPException, IOException {
            Field f;
            int count = this.in.readInt("fields");
            DataType.FieldID[] fieldIDs = new DataType.FieldID[count];
            ProxyField[] fields = new ProxyField[count];
            int constantFields = 0;
            PacketInputStream sdaIn = null;
            for (int i = 0; i < count; ++i) {
                DataType.FieldID fieldID;
                fieldIDs[i] = fieldID = this.in.readFieldID("fieldID");
                fields[i] = requestKlass.getField(fieldID);
                f = fields[i].getField();
                if (!ReferenceType.isPrimitiveConstantField(f)) continue;
                ++constantFields;
            }
            int nonConstFields = count - constantFields;
            if (nonConstFields > 0) {
                CommandPacket sdaCommand = new CommandPacket(2, 6, true);
                PacketOutputStream sdaOut = sdaCommand.getOutputStream();
                sdaOut.writeReferenceTypeID(requestKlass.getID(), "refType");
                sdaOut.writeInt(nonConstFields, "fields");
                for (int i = 0; i < count; ++i) {
                    Field f2 = fields[i].getField();
                    if (ReferenceType.isPrimitiveConstantField(f2)) continue;
                    sdaOut.writeFieldID(fieldIDs[i], "fieldID");
                }
                ReplyPacket sdaReply = this.otherHost.sendCommand(sdaCommand);
                sdaIn = sdaReply.getInputStream();
                int countFromVM = sdaIn.readInt("values");
                Assert.that((countFromVM == nonConstFields ? 1 : 0) != 0);
            }
            this.out.writeInt(count, "values");
            for (int i = 0; i < count; ++i) {
                f = fields[i].getField();
                if (ReferenceType.isPrimitiveConstantField(f)) {
                    long value = f.getPrimitiveConstantValue();
                    byte tag = JDWP.getTag((Klass)f.getType());
                    this.out.writePrimitive(tag, value, "value");
                    continue;
                }
                this.out.copyTaggedValue(sdaIn);
            }
        }
    }

    static final class VirtualMachine
    extends SDPCommandSet {
        private boolean dispose;

        VirtualMachine() {
        }

        protected boolean dispatch() throws IOException, SDWPException {
            this.dispose = false;
            switch (this.command.command()) {
                case 2: {
                    this.ClassesBySignature();
                    break;
                }
                case 4: {
                    this.AllThreads();
                    break;
                }
                case 3: {
                    this.AllClasses();
                    break;
                }
                case 1: {
                    this.Version();
                    break;
                }
                case 5: {
                    this.TopLevelThreadGroups();
                    break;
                }
                case 6: {
                    this.Dispose();
                    break;
                }
                case 7: {
                    this.IDSizes();
                    break;
                }
                case 12: {
                    this.Capabilities();
                    break;
                }
                case 17: {
                    this.CapabilitiesNew();
                    break;
                }
                case 13: {
                    this.ClassPaths();
                    break;
                }
                case 14: {
                    this.DisposeObjects();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        protected void postDispatch() {
            if (this.dispose) {
                this.host.quit();
            }
        }

        private void AllThreads() throws IOException {
            Collection<ProxyThread> threads = this.sdp.getTPM().getThreads();
            Assert.that((!threads.isEmpty() ? 1 : 0) != 0);
            this.out.writeInt(threads.size(), "threads");
            for (ProxyThread thread : threads) {
                this.out.writeObjectID(thread.id, "thread");
            }
        }

        private void AllClasses() throws IOException {
            Collection types = this.sdp.getPTM().getTypes();
            HashSet<ProxyType> classfileTypes = new HashSet<ProxyType>();
            for (ProxyType type : types) {
                Klass klass = type.getKlass();
                if (!ProxyTypeManager.isDebuggableKlass(klass)) continue;
                classfileTypes.add(type);
            }
            this.out.writeInt(classfileTypes.size(), "classes");
            for (ProxyType type : classfileTypes) {
                this.out.writeByte((int)JDWP.getTypeTag((Klass)type.getKlass()), "refTypeTag");
                this.out.writeReferenceTypeID(type.getID(), "typeID");
                String sig = type.getSignature();
                this.out.writeString(sig, "signature");
                this.out.writeInt(7, "status");
                type.setHasBeenSent();
            }
        }

        private void ClassesBySignature() throws IOException {
            String sig = this.in.readString("signature");
            Collection types = this.sdp.getPTM().getTypes();
            for (ProxyType type : types) {
                Klass klass = type.getKlass();
                if (!ProxyTypeManager.isDebuggableKlass(klass) || !type.getSignature().equals(sig)) continue;
                byte tag = JDWP.getTypeTag((Klass)klass);
                this.out.writeInt(1, "classes");
                this.out.writeByte((int)tag, "refTypeTag");
                this.out.writeReferenceTypeID(type.getID(), "typeID");
                this.out.writeInt(7, "status");
                type.setHasBeenSent();
                return;
            }
            this.out.writeInt(0, "classes");
        }

        private void Version() throws IOException {
            boolean MAJOR = true;
            int MINOR = 2;
            String VM_VERSION = "1.0.0";
            String VM_NAME = "Squawk VM";
            String DESCRIPTION = "Java Debug Wire Protocol version 1.2\nJVM Debug Interface version 1.0\nJVM version 1.0.0 (Squawk VM)";
            this.out.writeString("Java Debug Wire Protocol version 1.2\nJVM Debug Interface version 1.0\nJVM version 1.0.0 (Squawk VM)", "description");
            this.out.writeInt(1, "jdwpMajor");
            this.out.writeInt(2, "jdwpMinor");
            this.out.writeString("1.0.0", "vmVersion");
            this.out.writeString("Squawk VM", "vmName");
            ((JDBListener)this.host).debuggerAskedSizes = true;
        }

        private void TopLevelThreadGroups() throws IOException {
            this.out.writeInt(1, "groups");
            this.out.writeObjectID(DataType.ObjectID.THREAD_GROUP, "group");
        }

        private void Dispose() throws IOException, SDWPException {
            this.otherHost.sendCommand(this.command);
            this.dispose = true;
        }

        private void IDSizes() throws IOException {
            this.out.writeInt(8, "fieldIDSize");
            this.out.writeInt(4, "methodIDSize");
            this.out.writeInt(4, "objectIDSize");
            this.out.writeInt(4, "referenceTypeIDSize");
            this.out.writeInt(8, "frameIDSize");
        }

        private void Capabilities() throws IOException {
            this.out.writeBoolean(false, "canWatchFieldModification");
            this.out.writeBoolean(false, "canWatchFieldAccess");
            this.out.writeBoolean(false, "canGetBytecodes");
            this.out.writeBoolean(false, "canGetSyntheticAttribute");
            this.out.writeBoolean(false, "canGetOwnedMonitorInfo");
            this.out.writeBoolean(false, "canGetCurrentContendedMonitor");
            this.out.writeBoolean(false, "canGetMonitorInfo");
        }

        private void CapabilitiesNew() throws IOException {
            this.out.writeBoolean(false, "canWatchFieldModification");
            this.out.writeBoolean(false, "canWatchFieldAccess");
            this.out.writeBoolean(false, "canGetBytecodes");
            this.out.writeBoolean(false, "canGetSyntheticAttribute");
            this.out.writeBoolean(false, "canGetOwnedMonitorInfo");
            this.out.writeBoolean(false, "canGetCurrentContendedMonitor");
            this.out.writeBoolean(false, "canGetMonitorInfo");
            this.out.writeBoolean(false, "canRedefineClasses");
            this.out.writeBoolean(false, "canAddMethod");
            this.out.writeBoolean(false, "canUnrestrictedlyRedefineClasses");
            this.out.writeBoolean(false, "canPopFrames");
            this.out.writeBoolean(false, "canUseInstanceFilters");
            this.out.writeBoolean(false, "canGetSourceDebugExtension");
            this.out.writeBoolean(true, "canRequestVMDeathEvent");
            this.out.writeBoolean(false, "canSetDefaultStratum");
            this.out.writeBoolean(false, "canGetInstanceInfo");
            this.out.writeBoolean(false, "canRequestMonitorEvents");
            this.out.writeBoolean(false, "canGetMonitorFrameInfo");
            this.out.writeBoolean(false, "canUseSourceNameFilters");
            this.out.writeBoolean(false, "canGetConstantPool");
            this.out.writeBoolean(false, "canForceEarlyReturn");
            this.out.writeBoolean(false, "reserved22");
            this.out.writeBoolean(false, "reserved23");
            this.out.writeBoolean(false, "reserved24");
            this.out.writeBoolean(false, "reserved25");
            this.out.writeBoolean(false, "reserved26");
            this.out.writeBoolean(false, "reserved27");
            this.out.writeBoolean(false, "reserved28");
            this.out.writeBoolean(false, "reserved29");
            this.out.writeBoolean(false, "reserved30");
            this.out.writeBoolean(false, "reserved31");
            this.out.writeBoolean(false, "reserved32");
        }

        private void ClassPaths() throws IOException {
            this.out.writeString(".", "baseDir");
            this.out.writeInt(0, "classpaths");
            this.out.writeInt(0, "bootclasspaths");
        }

        private void DisposeObjects() throws IOException {
        }
    }
}

