/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger.sdp;

import com.sun.squawk.Debugger;
import com.sun.squawk.debugger.CommandPacket;
import com.sun.squawk.debugger.DataType;
import com.sun.squawk.debugger.EventRequest;
import com.sun.squawk.debugger.JDWPListener;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.PacketInputStream;
import com.sun.squawk.debugger.PacketOutputStream;
import com.sun.squawk.debugger.ReplyPacket;
import com.sun.squawk.debugger.SDWPException;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.IntHashtable;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class JDWPSniffer
extends JDWPListener {
    protected final IntHashtable commandSets = new IntHashtable();
    public static int fieldIDSize = -1;
    public static int methodIDSize = -1;
    public static int objectIDSize = -1;
    public static int referenceTypeIDSize = -1;
    public static int frameIDSize = -1;

    public PacketInputStream getInputStreamFor(CommandPacket command) {
        PacketInputStream raw = command.getInputStream();
        return new SnifferPacketInputStream(raw);
    }

    protected void processCommand(CommandPacket command) throws IOException {
        ReplyPacket sdaReply;
        SnifferCommandSet handler = (SnifferCommandSet)((Object)this.commandSets.get(command.set()));
        if (handler != null) {
            handler.handle(this.otherHost, command);
        }
        try {
            this.otherHost.sendCommand(command);
        }
        catch (SDWPException e) {
            // empty catch block
        }
        if (command.needsReply() && (sdaReply = command.getReply()) != null) {
            if (handler != null) {
                handler.logReply(command, sdaReply, sdaReply.getInputStream());
            }
            this.sendReply(sdaReply);
        }
    }

    static String readID(PacketInputStream in, int size) throws IOException {
        Assert.always((size > 0 ? 1 : 0) != 0);
        long value = 0L;
        DataInputStream dis = in.getInputStream();
        while (size-- != 0) {
            int b = dis.readByte() & 0xFF;
            value = value << 8 | (long)b;
        }
        return Long.toHexString(value);
    }

    public static void readObjectID(PacketInputStream in, String s) throws IOException {
        String value = JDWPSniffer.readID(in, objectIDSize);
        if (s != null && Log.verbose()) {
            Log.log((String)("in[object]    " + s + "=0x" + value));
        }
    }

    public static void readTaggedObjectID(PacketInputStream in, String s) throws IOException {
        in.readByte("tag");
        String value = JDWPSniffer.readID(in, objectIDSize);
        if (s != null && Log.verbose()) {
            Log.log((String)("in[t-object]  " + s + "=0x" + value));
        }
    }

    public static void readReferenceTypeID(PacketInputStream in, String s) throws IOException {
        String value = JDWPSniffer.readID(in, referenceTypeIDSize);
        if (s != null && Log.verbose()) {
            Log.log((String)("in[type]      " + s + "=0x" + value));
        }
    }

    public static void readMethodID(PacketInputStream in, String s) throws IOException {
        String value = JDWPSniffer.readID(in, methodIDSize);
        if (s != null && Log.verbose()) {
            Log.log((String)("in[method]    " + s + "=0x" + value));
        }
    }

    public static void readFrameID(PacketInputStream in, String s) throws IOException {
        String value = JDWPSniffer.readID(in, frameIDSize);
        if (s != null && Log.verbose()) {
            Log.log((String)("in[frame]     " + s + "=0x" + value));
        }
    }

    public static void readFieldID(PacketInputStream in, String s) throws IOException {
        String value = JDWPSniffer.readID(in, fieldIDSize);
        if (s != null && Log.verbose()) {
            Log.log((String)("in[field]     " + s + "=0x" + value));
        }
    }

    public static void readLocation(PacketInputStream in, String s) throws IOException {
        in.readByte("location type tag");
        JDWPSniffer.readReferenceTypeID(in, "location");
        JDWPSniffer.readMethodID(in, "location");
        in.readLong("location index");
    }

    public static class JDBSniffer
    extends JDWPSniffer {
        public JDBSniffer() {
            this.commandSets.put(15, (Object)new EventRequestCommand());
            this.commandSets.put(1, (Object)new VirtualMachine());
            this.commandSets.put(6, (Object)new MethodCommand());
        }

        public String sourceName() {
            return "Debugger";
        }

        static final class VirtualMachine
        extends SnifferCommandSet {
            VirtualMachine() {
            }

            protected boolean dispatch() throws IOException, SDWPException {
                switch (this.command.command()) {
                    case 2: {
                        this.ClassesBySignature();
                    }
                }
                return false;
            }

            @Override
            public void logReply(CommandPacket command, ReplyPacket reply, PacketInputStream in) throws IOException {
                switch (command.command()) {
                    case 1: {
                        this.Version(in);
                        break;
                    }
                    case 7: {
                        this.IDSizes(in);
                        break;
                    }
                    case 12: {
                        this.Capabilities(in);
                        break;
                    }
                    case 17: {
                        this.CapabilitiesNew(in);
                        break;
                    }
                    case 13: {
                        this.ClassPaths(in);
                        break;
                    }
                    case 2: {
                        this.ClassesBySignatureReply(in);
                        break;
                    }
                    case 3: {
                        this.AllClassesReply(in, false);
                        break;
                    }
                    case 20: {
                        this.AllClassesReply(in, true);
                    }
                }
            }

            private void ClassesBySignature() throws IOException {
                this.in.readString("signature");
            }

            private void ClassesBySignatureReply(PacketInputStream in) throws IOException {
                int count = in.readInt("classes");
                for (int i = 0; i < count; ++i) {
                    in.readByte("refTypeTag");
                    JDWPSniffer.readReferenceTypeID(in, "typeID");
                    in.readInt("status");
                }
            }

            private void AllClassesReply(PacketInputStream in, boolean withGeneric) throws IOException {
                int count = in.readInt("classes");
                for (int i = 0; i < count; ++i) {
                    in.readByte("refTypeTag");
                    JDWPSniffer.readReferenceTypeID(in, "typeID");
                    in.readString("signature");
                    if (withGeneric) {
                        in.readString("generic signature");
                    }
                    in.readInt("status");
                }
            }

            private void Version(PacketInputStream in) throws IOException {
                in.readString("description");
                in.readInt("jdwpMajor");
                in.readInt("jdwpMinor");
                in.readString("vmVersion");
                in.readString("vmName");
            }

            private void IDSizes(PacketInputStream in) throws IOException {
                fieldIDSize = in.readInt("fieldIDSize");
                methodIDSize = in.readInt("methodIDSize");
                objectIDSize = in.readInt("objectIDSize");
                referenceTypeIDSize = in.readInt("referenceTypeIDSize");
                frameIDSize = in.readInt("frameIDSize");
            }

            private void Capabilities(PacketInputStream in) throws IOException {
                in.readBoolean("canWatchFieldModification");
                in.readBoolean("canWatchFieldAccess");
                in.readBoolean("canGetBytecodes");
                in.readBoolean("canGetSyntheticAttribute");
                in.readBoolean("canGetOwnedMonitorInfo");
                in.readBoolean("canGetCurrentContendedMonitor");
                in.readBoolean("canGetMonitorInfo");
            }

            private void CapabilitiesNew(PacketInputStream in) throws IOException {
                in.readBoolean("canWatchFieldModification");
                in.readBoolean("canWatchFieldAccess");
                in.readBoolean("canGetBytecodes");
                in.readBoolean("canGetSyntheticAttribute");
                in.readBoolean("canGetOwnedMonitorInfo");
                in.readBoolean("canGetCurrentContendedMonitor");
                in.readBoolean("canGetMonitorInfo");
                in.readBoolean("canRedefineClasses");
                in.readBoolean("canAddMethod");
                in.readBoolean("canUnrestrictedlyRedefineClasses");
                in.readBoolean("canPopFrames");
                in.readBoolean("canUseInstanceFilters");
                in.readBoolean("canGetSourceDebugExtension");
                in.readBoolean("canRequestVMDeathEvent");
                in.readBoolean("canSetDefaultStratum");
                in.readBoolean("canGetInstanceInfo");
                in.readBoolean("canRequestMonitorEvents");
                in.readBoolean("canGetMonitorFrameInfo");
                in.readBoolean("canUseSourceNameFilters");
                in.readBoolean("canGetConstantPool");
                in.readBoolean("canForceEarlyReturn");
                in.readBoolean("reserved22");
                in.readBoolean("reserved23");
                in.readBoolean("reserved24");
                in.readBoolean("reserved25");
                in.readBoolean("reserved26");
                in.readBoolean("reserved27");
                in.readBoolean("reserved28");
                in.readBoolean("reserved29");
                in.readBoolean("reserved30");
                in.readBoolean("reserved31");
                in.readBoolean("reserved32");
            }

            private void ClassPaths(PacketInputStream in) throws IOException {
                in.readString("baseDir");
                in.readInt("classpaths");
                in.readInt("bootclasspaths");
            }
        }

        static final class MethodCommand
        extends SnifferCommandSet {
            MethodCommand() {
            }

            protected boolean dispatch() throws IOException, SDWPException {
                switch (this.command.command()) {
                    case 1: {
                        this.LineTable();
                    }
                }
                return false;
            }

            @Override
            public void logReply(CommandPacket command, ReplyPacket reply, PacketInputStream in) throws IOException {
                switch (command.command()) {
                    case 1: {
                        this.LineTableReply(in);
                    }
                }
            }

            private void LineTable() throws SDWPException, IOException {
                this.in.readReferenceTypeID("definingClass");
                this.in.readMethodID("methodID");
            }

            private void LineTableReply(PacketInputStream in) throws IOException {
                in.readLong("start");
                in.readLong("end");
                int lines = in.readInt("lines");
                for (int i = 0; i != lines; ++i) {
                    in.readLong("    lineCodeIndex");
                    in.readInt("    lineNumber");
                }
            }
        }

        static final class EventRequestCommand
        extends SnifferCommandSet {
            EventRequestCommand() {
            }

            protected boolean dispatch() throws IOException, SDWPException {
                switch (this.command.command()) {
                    case 1: {
                        return this.Set();
                    }
                }
                return false;
            }

            private boolean Set() throws SDWPException, IOException {
                byte kind = this.in.readByte("eventKind");
                if (Log.info()) {
                    SniffEventRequest request = new SniffEventRequest(this.in, kind);
                    Log.log((String)("    " + (Object)((Object)request)));
                }
                return false;
            }
        }

        static class SniffEventRequest
        extends EventRequest {
            public SniffEventRequest(PacketInputStream in, int kind) throws SDWPException, IOException {
                super(-999, in, kind);
            }

            public void write(PacketOutputStream out, Debugger.Event event) throws IOException {
                Assert.shouldNotReachHere();
            }

            public boolean matchKind(int eventKind) {
                return false;
            }
        }
    }

    public static class JVMSniffer
    extends JDWPSniffer {
        JVMSniffer() {
            this.commandSets.put(64, (Object)new Event());
        }

        public String sourceName() {
            return "JVM";
        }

        static final class Event
        extends SnifferCommandSet {
            Event() {
            }

            protected boolean dispatch() throws IOException {
                if (this.command.command() == 100) {
                    this.Composite();
                }
                return false;
            }

            private void Composite() throws IOException {
                byte suspendPolicy = this.in.readByte("suspendPolicy");
                if (Log.info()) {
                    Log.log((String)("    suspendPolicy: " + EventRequest.getNameForJDWPSuspendPolicy((int)suspendPolicy)));
                }
                int eventCount = this.in.readInt("events");
                block4: for (int i = 0; i != eventCount; ++i) {
                    byte eventKind = this.in.readByte("eventKind");
                    if (Log.info()) {
                        Log.log((String)("    eventKind: " + EventRequest.getNameForJDWPEventKind((int)eventKind)));
                    }
                    int requestID = this.in.readInt("requestID");
                    switch (eventKind) {
                        case 6: 
                        case 7: {
                            JDWPSniffer.readObjectID(this.in, "thread");
                            continue block4;
                        }
                        case 8: {
                            JDWPSniffer.readObjectID(this.in, "thread");
                            this.in.readByte("refTypeTag");
                            JDWPSniffer.readReferenceTypeID(this.in, "typeID");
                            this.in.readString("signature");
                            this.in.readInt("status");
                        }
                    }
                }
            }
        }
    }

    public static abstract class SnifferCommandSet
    extends JDWPListener.CommandSet {
        public void logReply(CommandPacket command, ReplyPacket reply, PacketInputStream in) throws IOException {
        }
    }

    public static class SnifferPacketInputStream
    extends PacketInputStream {
        public SnifferPacketInputStream(PacketInputStream raw) {
            super(raw);
        }

        public DataType.ObjectID readObjectID(String s) throws IOException {
            JDWPSniffer.readObjectID(this, s);
            return null;
        }

        public DataType.TaggedObjectID readTaggedObjectID(String s) throws IOException {
            JDWPSniffer.readTaggedObjectID(this, s);
            return null;
        }

        public DataType.ReferenceTypeID readReferenceTypeID(String s) throws IOException {
            JDWPSniffer.readReferenceTypeID(this, s);
            return null;
        }

        public DataType.MethodID readMethodID(String s) throws IOException {
            JDWPSniffer.readMethodID(this, s);
            return null;
        }

        public DataType.FrameID readFrameID(String s) throws IOException {
            JDWPSniffer.readFrameID(this, s);
            return null;
        }

        public DataType.FieldID readFieldID(String s) throws IOException {
            JDWPSniffer.readFieldID(this, s);
            return null;
        }

        public DataType.Location readLocation(String s) throws IOException {
            JDWPSniffer.readLocation(this, s);
            return null;
        }
    }
}

