/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger.sdp;

import com.sun.squawk.DebuggerSupport;
import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.Modifier;
import com.sun.squawk.ScopedLocalVariable;
import com.sun.squawk.debugger.DataType;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.sdp.ProxyTypeManager;

public class ProxyMethod {
    private final Method method;
    private final DataType.MethodID id;
    private LineNumberTable lnt;
    private ScopedLocalVariable[] lvt;
    private int argCount = -1;
    private boolean hiddenMethod;

    public String getName() {
        return this.method.getName();
    }

    public String getSignature() {
        return DebuggerSupport.getJNISignature((Method)this.method);
    }

    public int getModifiers() {
        return this.method.getModifiers() & Modifier.getJVMMethodModifiers();
    }

    public DataType.MethodID getID() {
        return this.id;
    }

    public ProxyMethod(DataType.MethodID id, Method method) {
        this.id = id;
        this.method = method;
    }

    public LineNumberTable getLineNumberTable() {
        if (this.lnt == null) {
            Klass definingKlass = this.method.getDefiningClass();
            ProxyTypeManager.convertClass(definingKlass);
            int[] table = this.method.getLineNumberTable();
            if (table == null) {
                if (Log.info()) {
                    Log.log((String)("No linenumber table found for " + this.method));
                }
                this.lnt = LineNumberTable.EMPTY_TABLE;
            } else if (this.hiddenMethod) {
                this.lnt = LineNumberTable.NATIVE_TABLE;
            } else {
                Object methodBody = DebuggerSupport.getMethodBody((Klass)definingKlass, (int)this.id.getOffset(), (boolean)this.id.isStatic());
                int methodLength = DebuggerSupport.getMethodBodyLength((Object)methodBody);
                LineNumberTable.Entry[] entries = new LineNumberTable.Entry[table.length];
                for (int i = 0; i < table.length; ++i) {
                    LineNumberTable.Entry entry;
                    int e = table[i];
                    entries[i] = entry = new LineNumberTable.Entry(e >>> 16, e & 0xFFFF);
                }
                this.lnt = new LineNumberTable(0L, methodLength - 1, entries);
            }
        }
        return this.lnt;
    }

    public synchronized ScopedLocalVariable[] getVariableTable() {
        if (this.lvt == null) {
            Klass definingKlass = this.method.getDefiningClass();
            ProxyTypeManager.convertClass(definingKlass);
            this.lvt = this.method.getLocalVariableTable();
            if (this.lvt == null) {
                if (Log.info()) {
                    Log.log((String)("No local variable table found for " + this.method));
                }
                Klass[] argTypes = this.method.getParameterTypes();
                int count = this.method.isStatic() ? 0 : 1;
                count += argTypes.length;
                if (Log.debug()) {
                    Log.log((String)("  constructing fake variable table for parameters: " + count));
                }
                this.lvt = new ScopedLocalVariable[count];
                int slot = 0;
                if (!this.method.isStatic()) {
                    this.lvt[argTypes.length] = new ScopedLocalVariable("this", definingKlass, slot++, 0, Integer.MAX_VALUE);
                }
                for (int i = 0; i < argTypes.length; ++i) {
                    this.lvt[i] = new ScopedLocalVariable("arg-" + i, argTypes[i], slot++, 0, Integer.MAX_VALUE);
                    if (argTypes[i] != Klass.LONG && argTypes[i] != Klass.DOUBLE) continue;
                    ++slot;
                }
            }
        }
        return this.lvt;
    }

    public int getArgCount() {
        if (this.argCount == -1) {
            Klass[] argTypes = this.method.getParameterTypes();
            this.argCount = this.method.isStatic() ? 0 : 1;
            for (int i = 0; i < argTypes.length; ++i) {
                Klass klass = argTypes[i];
                ++this.argCount;
                if (klass != Klass.LONG && klass != Klass.DOUBLE) continue;
                ++this.argCount;
            }
        }
        return this.argCount;
    }

    public String toString() {
        return "<METHOD id: " + this.getID() + ", " + this.getName() + this.getSignature() + ">";
    }

    public static class LineNumberTable {
        public static final Entry[] NO_ENTRIES = new Entry[0];
        public static final LineNumberTable EMPTY_TABLE = new LineNumberTable(0L, Integer.MAX_VALUE, NO_ENTRIES);
        public static final LineNumberTable NATIVE_TABLE = new LineNumberTable(-1L, -1L, NO_ENTRIES);
        public final long start;
        public final long end;
        public final Entry[] entries;

        public long getOffsetOfLineAfter(int line) {
            if (line == -1) {
                return -1L;
            }
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i].lineNumber != line) continue;
                if (i + 1 < this.entries.length) {
                    if (Log.debug()) {
                        Log.log((String)("LineNumberTable.getOffsetOfLineAfter(line: " + line + "): returning " + this.entries[i + 1].lineCodeIndex));
                    }
                    return this.entries[i + 1].lineCodeIndex;
                }
                return -1L;
            }
            return -1L;
        }

        public long getOffsetOfLineAfter(long offset, int line) {
            if (offset == -1L || line == -1) {
                return -1L;
            }
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i].lineNumber != line || this.entries[i].lineCodeIndex != offset) continue;
                if (i + 1 < this.entries.length) {
                    if (Log.debug()) {
                        Log.log((String)("LineNumberTable.getOffsetOfLineAfter(line: " + offset + ", " + line + "): returning " + this.entries[i + 1].lineCodeIndex));
                    }
                    return this.entries[i + 1].lineCodeIndex;
                }
                return -1L;
            }
            return -1L;
        }

        public long getDuplicateOffset(long offset, int line) {
            long result = -1L;
            if (offset == -1L || line == -1) {
                return result;
            }
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i].lineNumber != line || this.entries[i].lineCodeIndex == offset) continue;
                result = this.entries[i].lineCodeIndex;
                break;
            }
            return result;
        }

        public int getLineNumber(long offset) {
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i].lineCodeIndex != offset) continue;
                return this.entries[i].lineNumber;
            }
            if (Log.debug()) {
                Log.log((String)("LineNumberTable.getLineNumber(): Could not find line number for offset " + offset));
            }
            return -1;
        }

        LineNumberTable(long start, long end, Entry[] entries) {
            this.start = start;
            this.end = end;
            this.entries = entries;
        }

        public static class Entry {
            public final long lineCodeIndex;
            public final int lineNumber;

            Entry(long lineCodeIndex, int lineNumber) {
                this.lineCodeIndex = lineCodeIndex;
                this.lineNumber = lineNumber;
            }
        }
    }
}

