/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger.sdp;

import com.sun.squawk.debugger.DataType;
import com.sun.squawk.debugger.Log;

class ProxyThread
extends Thread {
    public final DataType.ObjectID id;
    private int suspendCount;
    private int status;

    public ProxyThread(DataType.ObjectID id, String name, int status, int suspendCount) {
        super(name);
        this.id = id;
        this.suspendCount = suspendCount;
        this.status = status;
    }

    public void setStatus(int s) {
        this.status = s;
    }

    public int getStatus() {
        return this.status;
    }

    public void setSuspendCount(int count) {
        this.suspendCount = count;
        if (count == 0) {
            if (Log.info()) {
                Log.log((String)("resumed thread " + this.getName()));
            }
        } else if (Log.info()) {
            Log.log((String)("suspended thread " + this.getName()));
        }
    }

    public int getSuspendCount() {
        return this.suspendCount;
    }

    public boolean isSuspended() {
        return this.suspendCount > 0;
    }

    public boolean isZombie() {
        return this.status == 0;
    }

    @Override
    public String toString() {
        return "" + this.id + ": " + this.getName() + " status=" + this.status + " suspendCount=" + this.suspendCount;
    }
}

