/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger.sdp;

import com.sun.squawk.DebuggerSupport;
import com.sun.squawk.Field;
import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.Modifier;
import com.sun.squawk.debugger.DataType;
import com.sun.squawk.debugger.JDWP;
import com.sun.squawk.debugger.SDWPException;
import com.sun.squawk.debugger.sdp.ProxyField;
import com.sun.squawk.debugger.sdp.ProxyMethod;
import com.sun.squawk.debugger.sdp.ProxyTypeManager;
import com.sun.squawk.util.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProxyType {
    private final ProxyTypeManager ptm;
    private final Klass klass;
    private final DataType.ReferenceTypeID id;
    private boolean initialized;
    private List fields;
    private List methods;
    private boolean hasKlassBeenSent;

    public Klass getKlass() {
        return this.klass;
    }

    ProxyType(Klass klass, DataType.ReferenceTypeID id, ProxyTypeManager ptm) {
        this.ptm = ptm;
        this.id = id;
        Assert.that((klass != null ? 1 : 0) != 0);
        this.klass = klass;
    }

    public final ProxyType getSuperclass() throws IOException, SDWPException {
        Klass superClass = this.klass.getSuperclass();
        if (superClass != null && !superClass.isPrimitive()) {
            return this.ptm.lookup(superClass, true);
        }
        return null;
    }

    public final DataType.ReferenceTypeID getID() {
        return this.id;
    }

    public String getSignature() {
        return DebuggerSupport.getJNISignature((Klass)this.klass);
    }

    public String getName() {
        String name = this.klass.getName();
        if (!this.klass.isArray()) {
            return name;
        }
        int dimensions = 0;
        while (name.charAt(dimensions) == '[') {
            ++dimensions;
        }
        char first = (name = name.substring(dimensions)).charAt(0);
        if (first == 'L') {
            name = name.substring(1, name.length() - 2).replace('/', '.');
        } else {
            switch (first) {
                case 'I': {
                    name = "int";
                    break;
                }
                case 'J': {
                    name = "long";
                    break;
                }
                case 'F': {
                    name = "float";
                    break;
                }
                case 'D': {
                    name = "double";
                    break;
                }
                case 'Z': {
                    name = "boolean";
                    break;
                }
                case 'C': {
                    name = "char";
                    break;
                }
                case 'S': {
                    name = "short";
                    break;
                }
                case 'B': {
                    name = "byte";
                    break;
                }
                case 'V': {
                    name = "void";
                }
            }
        }
        while (dimensions-- != 0) {
            name = name + "[]";
        }
        return name;
    }

    public int getModifiers() {
        return this.klass.getModifiers() & Modifier.getJVMClassModifiers();
    }

    public List getFields() {
        if (this.fields == null) {
            this.fields = new ArrayList();
            this.addFields(this.fields, true);
            this.addFields(this.fields, false);
        }
        return this.fields;
    }

    private void addFields(List list, boolean isStatic) {
        int count = this.klass.getFieldCount(isStatic);
        for (int i = 0; i != count; ++i) {
            Field field = this.klass.getField(i, isStatic);
            DataType.FieldID id = new DataType.FieldID((int)JDWP.getTag((Klass)field.getType()), field.getOffset(), isStatic, this.getID());
            ProxyField proxyField = new ProxyField(id, field);
            list.add(proxyField);
        }
    }

    public ProxyField getField(DataType.FieldID id) throws IOException, SDWPException {
        if (id.definingClass.equals((Object)this.id)) {
            for (ProxyField field : this.getFields()) {
                if (!field.getID().equals((Object)id)) continue;
                return field;
            }
            throw new SDWPException(25, id + " is not a field of " + this);
        }
        ProxyType definingProxyType = this.ptm.lookup(id.definingClass, true);
        if (!definingProxyType.getKlass().isAssignableFrom(this.getKlass())) {
            throw new SDWPException(25, id + " is not a field of " + this);
        }
        return definingProxyType.getField(id);
    }

    public List getMethods() {
        if (this.methods == null) {
            if (this.klass.isArray()) {
                this.methods = Collections.EMPTY_LIST;
            } else {
                this.methods = new ArrayList();
                this.addMethods(this.methods, true);
                this.addMethods(this.methods, false);
            }
        }
        return this.methods;
    }

    private void addMethods(List list, boolean isStatic) {
        int count = this.klass.getMethodCount(isStatic);
        for (int i = 0; i != count; ++i) {
            Method method = this.klass.getMethod(i, isStatic);
            if (method.isHosted()) continue;
            DataType.MethodID id = new DataType.MethodID(method.getOffset(), isStatic);
            ProxyMethod proxyMethod = new ProxyMethod(id, method);
            list.add(proxyMethod);
        }
    }

    public ProxyMethod getMethod(DataType.MethodID id) {
        for (ProxyMethod proxyMethod : this.getMethods()) {
            if (!proxyMethod.getID().equals((Object)id)) continue;
            return proxyMethod;
        }
        return null;
    }

    public List getInterfaces() throws IOException, SDWPException {
        Klass[] interfaces = this.klass.getInterfaces();
        ArrayList<ProxyType> list = new ArrayList<ProxyType>(interfaces.length);
        for (int i = 0; i != interfaces.length; ++i) {
            list.add(this.ptm.lookup(interfaces[i], true));
        }
        return list;
    }

    public String toString() {
        return "<" + this.klass + ", id: " + this.getID() + ", " + this.getSignature() + ">";
    }

    public String getSourceName() {
        return this.klass.getSourceFileName();
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (!(o instanceof ProxyType)) {
            return -1;
        }
        ProxyType other = (ProxyType)o;
        return this.getSignature().compareTo(other.getSignature());
    }

    public boolean hasKlassBeenSent() {
        return this.hasKlassBeenSent;
    }

    public void setHasBeenSent() {
        this.hasKlassBeenSent = true;
    }
}

