/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger.sdp;

import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.TranslatorInterface;
import com.sun.squawk.VM;
import com.sun.squawk.debugger.CommandPacket;
import com.sun.squawk.debugger.DataType;
import com.sun.squawk.debugger.JDWPListener;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.PacketInputStream;
import com.sun.squawk.debugger.ReplyPacket;
import com.sun.squawk.debugger.SDWPException;
import com.sun.squawk.debugger.sdp.ProxyType;
import com.sun.squawk.debugger.sdp.UndefinedProxyType;
import com.sun.squawk.util.Assert;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

class ProxyTypeManager {
    private static final int DEFAULT_NUM_REFS = 700;
    private HashMap<Klass, ProxyType> classToType = new HashMap(700);
    private HashMap<DataType.ReferenceTypeID, ProxyType> idToType = new HashMap(700);
    private JDWPListener sda;

    ProxyTypeManager() {
    }

    public ProxyType addClass(DataType.ReferenceTypeID typeID, String name, boolean isJNISignature) {
        Klass klass = this.getClass(name, isJNISignature);
        if (klass.isInternalType()) {
            return null;
        }
        ProxyType type = this.classToType.get(klass);
        if (type != null) {
            Assert.that((boolean)type.getID().equals((Object)typeID));
            return type;
        }
        return this.createProxyType(klass, typeID);
    }

    public ProxyType lookup(Klass klass, boolean resolve) throws SDWPException {
        ProxyType type = this.classToType.get(klass);
        if (type == null) {
            if (!resolve || this.sda == null) {
                throw new SDWPException(21, klass.getName());
            }
            try {
                CommandPacket sdaCommand = new CommandPacket(1, 2, true);
                sdaCommand.getOutputStream().writeString(klass.getSignature(), "signature");
                ReplyPacket sdaReply = this.sda.sendCommand(sdaCommand);
                PacketInputStream sdaIn = sdaReply.getInputStream();
                int classes = sdaIn.readInt("classes");
                if (classes < 1) {
                    throw new SDWPException(21, "class not found for signature: " + klass.getSignature());
                }
                byte tag = sdaIn.readByte("refTypeTag");
                DataType.ReferenceTypeID typeID = sdaIn.readReferenceTypeID("typeID");
                int status = sdaIn.readInt("status");
                if (Log.debug()) {
                    Log.log((String)("resolved signature " + klass.getSignature() + " to typeID " + typeID));
                }
                type = this.createProxyType(klass, typeID);
            }
            catch (IOException e) {
                throw new SDWPException(21, e.toString());
            }
        }
        return type;
    }

    public ProxyType lookup(DataType.ReferenceTypeID typeID, boolean resolve) throws SDWPException {
        ProxyType type = this.idToType.get(typeID);
        if (type == null) {
            if (!resolve || this.sda == null) {
                throw new SDWPException(21, typeID.toString());
            }
            try {
                CommandPacket sdaCommand = new CommandPacket(2, 1, true);
                sdaCommand.getOutputStream().writeReferenceTypeID(typeID, "typeID");
                PacketInputStream sdaIn = this.sda.sendCommand(sdaCommand).getInputStream();
                String sig = sdaIn.readString("signature");
                if (Log.debug()) {
                    Log.log((String)("resolved typeID " + typeID + " to signature " + sig));
                }
                Klass klass = this.getClass(sig, true);
                type = this.createProxyType(klass, typeID);
            }
            catch (IOException e) {
                throw new SDWPException(21, e.toString());
            }
        }
        return type;
    }

    private Klass getClass(String signature, boolean isJNISignature) {
        Klass klass = Klass.getClass((String)signature, (boolean)isJNISignature);
        Isolate isolate = VM.getCurrentIsolate();
        TranslatorInterface translator = isolate.getTranslator();
        Assert.that((translator != null ? 1 : 0) != 0, (String)"Couldn't get translator");
        try {
            translator.load(klass);
        }
        catch (NoClassDefFoundError e) {
            System.err.println("Error: could not find classfile for " + klass.getName() + " - most likely caused by incorrect '-cp' argument");
        }
        catch (LinkageError e) {
            System.err.println("Error: could not resolve class " + klass.getName());
            e.printStackTrace();
        }
        return klass;
    }

    static synchronized void convertClass(Klass klass) {
        Isolate isolate = VM.getCurrentIsolate();
        TranslatorInterface translator = isolate.getTranslator();
        Assert.that((translator != null ? 1 : 0) != 0, (String)"Couldn't get translator");
        try {
            translator.convert(klass);
        }
        catch (LinkageError e) {
            System.err.println("warning: could not convert class " + klass.getName());
            e.printStackTrace();
        }
    }

    private ProxyType createProxyType(Klass klass, DataType.ReferenceTypeID id) {
        ProxyType type = klass.getState() == 2 || klass.getState() == 4 ? new ProxyType(klass, id, this) : new UndefinedProxyType(klass, id, this);
        ProxyType previous = this.classToType.put(klass, type);
        Assert.that((previous == null ? 1 : 0) != 0);
        previous = this.idToType.put(id, type);
        Assert.that((previous == null ? 1 : 0) != 0);
        return type;
    }

    public Collection getTypes() {
        return Collections.unmodifiableCollection(this.idToType.values());
    }

    public void setVM(JDWPListener vm) {
        this.sda = vm;
    }

    public static boolean isDebuggableKlass(Klass klass) {
        return !klass.isInternalType() && !klass.isSquawkPrimitive();
    }
}

