/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger.sdp;

import com.sun.squawk.debugger.CommandPacket;
import com.sun.squawk.debugger.DataType;
import com.sun.squawk.debugger.JDWPListener;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.PacketOutputStream;
import com.sun.squawk.debugger.ReplyPacket;
import com.sun.squawk.debugger.SDWPException;
import com.sun.squawk.debugger.sdp.ProxyMethod;
import com.sun.squawk.debugger.sdp.ProxyType;
import com.sun.squawk.debugger.sdp.ProxyTypeManager;
import com.sun.squawk.debugger.sdp.SDP;
import com.sun.squawk.debugger.sdp.SDPCommandSet;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.IntHashtable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

final class SDAListener
extends JDWPListener {
    private final SDP sdp;
    private String isolateName;
    private final IntHashtable commandSets = new IntHashtable();
    private Event eventHandler;
    private boolean forwarderStarted = false;

    public void enableForwardedEvents() {
        if (!this.forwarderStarted) {
            this.eventHandler.enableForwardedEvents();
            this.forwarderStarted = true;
        }
    }

    public SDAListener(SDP sdp) {
        this.sdp = sdp;
        this.eventHandler = new Event(this);
        this.commandSets.put(64, (Object)this.eventHandler);
        this.commandSets.put(128, (Object)new SquawkVM(this.eventHandler));
    }

    public Event getEventHandler() {
        return this.eventHandler;
    }

    public String getIsolateName() {
        return this.isolateName;
    }

    public void processCommand(CommandPacket command) throws IOException {
        block3: {
            try {
                SDPCommandSet handler = (SDPCommandSet)((Object)this.commandSets.get(command.set()));
                if (handler == null || !handler.handle(this.sdp, this, this.otherHost, command)) {
                    System.err.println("Unrecognized command: " + command);
                }
            }
            catch (IOException e) {
                System.err.println(command + " caused: " + e);
                if (!command.needsReply()) break block3;
                ReplyPacket reply = command.createReply(113);
                this.sendReply(reply);
            }
        }
    }

    public String sourceName() {
        return "SquawkVM";
    }

    static final class SquawkVM
    extends SDPCommandSet {
        private final Event event;

        SquawkVM(Event event) {
            this.event = event;
        }

        protected boolean dispatch() throws IOException {
            try {
                switch (this.command.command()) {
                    case 2: {
                        this.SteppingInfo();
                        break;
                    }
                    case 4: {
                        this.ThreadStateChanged();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
            catch (SDWPException e) {
                e.printStackTrace();
                Assert.shouldNotReachHere();
                return false;
            }
        }

        private void SteppingInfo() throws IOException, SDWPException {
            if (Log.debug()) {
                Log.log((String)"SteppingInfo: getting stepping info");
            }
            DataType.ReferenceTypeID typeID = this.in.readReferenceTypeID("refType");
            DataType.MethodID methodID = this.in.readMethodID("method");
            long bci = this.in.readLong("bci");
            if (Log.debug()) {
                Log.log((String)("SteppingInfo: class typeID = " + typeID + ", methodID = " + methodID));
            }
            ProxyType definingClass = this.sdp.getPTM().lookup(typeID, false);
            ProxyMethod method = null;
            if (definingClass == null || (method = definingClass.getMethod(methodID)) == null) {
                if (Log.debug()) {
                    Log.log((String)"SteppingInfo: definingClass and/or method was null");
                }
                throw new SDWPException(101, "definingClass and/or method was null");
            }
            ProxyMethod.LineNumberTable table = method.getLineNumberTable();
            int line = table.getLineNumber(bci);
            if (Log.debug()) {
                Log.log((String)("SteppingInfo: (offset " + bci + ") --> (line " + line + ")"));
            }
            Assert.thatFatal((table != null ? 1 : 0) != 0, (String)"SteppingInfo: unable to acquire line number table");
            long targetBCI = table.getOffsetOfLineAfter(line);
            long dupBCI = table.getDuplicateOffset(table.getDuplicateOffset(bci, line), line);
            long afterDupBCI = table.getOffsetOfLineAfter(dupBCI, table.getLineNumber(dupBCI));
            if (Log.debug()) {
                Log.log((String)("SteppingInfo [current bci = " + bci + ", target bci = " + targetBCI + ", dup current line bci = " + dupBCI + ", bci after current dup = " + afterDupBCI + "]"));
            }
            this.out.writeLong(targetBCI, "targetBCI");
            this.out.writeLong(dupBCI, "dupBCI");
            this.out.writeLong(afterDupBCI, "afterDupBCI");
        }

        private void ThreadStateChanged() throws IOException {
            this.sdp.getTPM().updateThreads(this.in);
        }
    }

    static final class Event
    extends SDPCommandSet {
        final SDAListener sdaListener;
        private boolean vmDeath;
        private LinkedList<ForwardedComposite> forwardedEventQueue = new LinkedList();

        Event(SDAListener sdaListener) {
            this.sdaListener = sdaListener;
        }

        protected boolean dispatch() throws IOException {
            this.vmDeath = false;
            if (this.command.command() == 100) {
                this.Composite();
                return true;
            }
            return false;
        }

        protected void postDispatch() {
            if (this.vmDeath) {
                this.host.quit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void Composite() throws IOException {
            byte suspendPolicy = this.in.readByte("suspendPolicy");
            int eventCount = this.in.readInt("events");
            ArrayList<ForwardedEvent> events = new ArrayList<ForwardedEvent>(eventCount);
            block14: for (int i = 0; i != eventCount; ++i) {
                byte eventKind = this.in.readByte("eventKind");
                int requestID = this.in.readInt("requestID");
                switch (eventKind) {
                    case 99: {
                        this.vmDeath = true;
                        events.add(new ForwardedEvent(eventKind, requestID));
                        continue block14;
                    }
                    case 6: 
                    case 7: {
                        final DataType.ObjectID threadID = this.in.readObjectID("thread");
                        if (requestID == 0) {
                            int status = this.in.readInt("status");
                            int suspendCount = this.in.readInt("suspendCount");
                            String name = this.in.readString("name");
                            this.sdp.getTPM().updateThread(threadID, name, status, suspendCount);
                            continue block14;
                        }
                        events.add(new ForwardedEvent(eventKind, requestID){

                            @Override
                            void writeBody(PacketOutputStream out) throws IOException {
                                out.writeObjectID(threadID, "thread");
                            }
                        });
                        continue block14;
                    }
                    case 8: {
                        DataType.ObjectID threadID;
                        try {
                            threadID = this.in.readObjectID("thread");
                            final byte refTypeTag = this.in.readByte("refTypeTag");
                            final DataType.ReferenceTypeID typeID = this.in.readReferenceTypeID("typeID");
                            final String sig = this.in.readString("signature");
                            final int status = this.in.readInt("status");
                            this.sdp.getTPM().getThread(threadID);
                            ProxyType type = this.sdp.getPTM().addClass(typeID, sig, true);
                            if (type == null || !ProxyTypeManager.isDebuggableKlass(type.getKlass())) continue block14;
                            int state = type.getKlass().getState();
                            if (state == 2 || state == 4) {
                                events.add(new ForwardedEvent(eventKind, requestID){

                                    @Override
                                    void writeBody(PacketOutputStream out) throws IOException {
                                        out.writeObjectID(threadID, "thread");
                                        out.writeByte((int)refTypeTag, "refTypeTag");
                                        out.writeReferenceTypeID(typeID, "typeID");
                                        out.writeString(sig, "signature");
                                        out.writeInt(status, "status");
                                    }
                                });
                                continue block14;
                            }
                            this.vmDeath = true;
                        }
                        catch (SDWPException e) {
                            e.printStackTrace();
                        }
                        continue block14;
                    }
                    case 90: {
                        Assert.always((requestID == 0 ? 1 : 0) != 0);
                        final DataType.ObjectID threadID = this.in.readObjectID("thread");
                        this.sdaListener.isolateName = this.in.readString("isolate name");
                        int classes = this.in.readInt("classes");
                        String lastName = "";
                        for (int j = 0; j != classes; ++j) {
                            DataType.ReferenceTypeID typeID = this.in.readReferenceTypeID("typeID");
                            int commonPrefix = this.in.readByte("commonPrefix") & 0xFF;
                            String name = this.in.readString("name");
                            if (commonPrefix != 0) {
                                name = lastName.substring(0, commonPrefix) + name;
                            }
                            lastName = name;
                            ProxyType type = this.sdp.getPTM().addClass(typeID, name, false);
                            if (type == null || !ProxyTypeManager.isDebuggableKlass(type.getKlass())) continue;
                            int state = type.getKlass().getState();
                            if (type.getKlass().isArray() || state == 2 || state == 4) continue;
                            System.err.println("Can't find classfile for " + type.getKlass() + ". The debug proxy may be looking at the wrong set of jar files.");
                            if (this.sdp.quitOnError) {
                                System.err.println("Quiting debug proxy...");
                                this.host.quit();
                                continue;
                            }
                            System.err.println("WARNING: Continuing execution of debug proxy, but debug information may be wrong...");
                            break;
                        }
                        this.sdp.setCanTalkToDebugger();
                        events.add(new ForwardedEvent(eventKind, requestID){

                            @Override
                            void writeBody(PacketOutputStream out) throws IOException {
                                out.writeObjectID(threadID, "thread");
                            }
                        });
                        continue block14;
                    }
                    case 2: {
                        final DataType.ObjectID threadID = this.in.readObjectID("thread");
                        final DataType.Location location = this.in.readLocation("location");
                        events.add(new ForwardedEvent(eventKind, requestID){

                            @Override
                            void writeBody(PacketOutputStream out) throws IOException {
                                out.writeObjectID(threadID, "thread");
                                out.writeLocation(location, "location");
                            }
                        });
                        continue block14;
                    }
                    case 4: {
                        final DataType.ObjectID threadID = this.in.readObjectID("thread");
                        final DataType.Location location = this.in.readLocation("location");
                        final DataType.TaggedObjectID exception = this.in.readTaggedObjectID("exception");
                        final DataType.Location catchLocation = this.in.readLocation("catchLocation");
                        events.add(new ForwardedEvent(eventKind, requestID){

                            @Override
                            void writeBody(PacketOutputStream out) throws IOException {
                                out.writeObjectID(threadID, "thread");
                                out.writeLocation(location, "location");
                                out.writeTaggedObjectID(exception, "exception");
                                out.writeLocation(catchLocation, "catchLocation");
                            }
                        });
                        continue block14;
                    }
                    case 1: {
                        final DataType.ObjectID threadID = this.in.readObjectID("thread");
                        final DataType.Location location = this.in.readLocation("location");
                        events.add(new ForwardedEvent(eventKind, requestID){

                            @Override
                            void writeBody(PacketOutputStream out) throws IOException {
                                out.writeObjectID(threadID, "thread");
                                out.writeLocation(location, "location");
                            }
                        });
                        continue block14;
                    }
                }
            }
            if (!events.isEmpty()) {
                LinkedList<ForwardedComposite> linkedList = this.forwardedEventQueue;
                synchronized (linkedList) {
                    this.forwardedEventQueue.addLast(new ForwardedComposite(suspendPolicy, events));
                    this.forwardedEventQueue.notifyAll();
                }
            }
        }

        void enableForwardedEvents() {
            Thread forwarder = new Thread((Runnable)new CompositeEventForwarder(), "EventForwarder");
            forwarder.setDaemon(true);
            forwarder.start();
        }

        class CompositeEventForwarder
        implements Runnable {
            CompositeEventForwarder() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (Log.info()) {
                    Log.log((String)"Started CompositeEventForwarder thread");
                }
                while (true) {
                    LinkedList linkedList = Event.this.forwardedEventQueue;
                    synchronized (linkedList) {
                        if (Event.this.forwardedEventQueue.isEmpty()) {
                            try {
                                Event.this.forwardedEventQueue.wait();
                            }
                            catch (InterruptedException ex) {}
                        } else {
                            block17: {
                                ForwardedComposite composite = (ForwardedComposite)Event.this.forwardedEventQueue.removeFirst();
                                List events = composite.events;
                                if (Log.info()) {
                                    Log.log((String)"Forwarding composit event");
                                }
                                try {
                                    CommandPacket command = new CommandPacket(64, 100, false);
                                    PacketOutputStream out = command.getOutputStream();
                                    out.writeByte(composite.suspendPolicy, "suspendPolicy");
                                    out.writeInt(events.size(), "events");
                                    for (ForwardedEvent fe : events) {
                                        fe.writeHeader(out);
                                        fe.writeBody(out);
                                    }
                                    Event.this.otherHost.sendCommand(command);
                                }
                                catch (SDWPException e) {
                                    Assert.shouldNotReachHere();
                                }
                                catch (IOException e) {
                                    if (Event.this.sdaListener != null && Event.this.sdaListener.otherHost != null && (Event.this.sdaListener.hasQuit() || Event.this.sdaListener.otherHost.hasQuit())) break block17;
                                    e.printStackTrace();
                                }
                            }
                            CompositeEventForwarder compositeEventForwarder = this;
                            synchronized (compositeEventForwarder) {
                                this.notifyAll();
                            }
                        }
                    }
                }
            }
        }

        static class ForwardedEvent {
            final int eventKind;
            final int requestID;

            ForwardedEvent(int eventKind, int requestID) {
                this.eventKind = eventKind;
                this.requestID = requestID;
            }

            final void writeHeader(PacketOutputStream out) throws IOException {
                out.writeByte(this.eventKind, "eventKind");
                out.writeInt(this.requestID, "requestID");
            }

            void writeBody(PacketOutputStream out) throws IOException {
            }
        }

        static class ForwardedComposite {
            final int suspendPolicy;
            final List events;

            ForwardedComposite(int suspendPolicy, List events) {
                this.suspendPolicy = suspendPolicy;
                this.events = events;
            }
        }
    }
}

