/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.debugger.sdp;

import com.sun.squawk.Debugger;
import com.sun.squawk.ProxySupport;
import com.sun.squawk.debugger.CommandPacket;
import com.sun.squawk.debugger.DataType;
import com.sun.squawk.debugger.EventManager;
import com.sun.squawk.debugger.EventRequest;
import com.sun.squawk.debugger.EventRequestModifier;
import com.sun.squawk.debugger.JDWPListener;
import com.sun.squawk.debugger.Log;
import com.sun.squawk.debugger.PacketInputStream;
import com.sun.squawk.debugger.PacketOutputStream;
import com.sun.squawk.debugger.SDWPException;
import com.sun.squawk.debugger.sdp.JDBListener;
import com.sun.squawk.debugger.sdp.JDWPSniffer;
import com.sun.squawk.debugger.sdp.ProxyThread;
import com.sun.squawk.debugger.sdp.ProxyType;
import com.sun.squawk.debugger.sdp.ProxyTypeManager;
import com.sun.squawk.debugger.sdp.SDAListener;
import com.sun.squawk.util.ArgsUtilities;
import com.sun.squawk.util.Assert;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SDP {
    protected static final byte KILL_MARKER1 = -127;
    protected static final byte KILL_MARKER2 = 126;
    private ProxyTypeManager ptm;
    private String vm_url = "socket://localhost:2800";
    private int retry = 5;
    protected int killPort;
    private String debugger_url = "serversocket://:2900";
    private String proxyName;
    private JDBListener jdb;
    private SDAListener sda;
    SDPEventManager eventManager;
    private ThreadProxiesManager tpm;
    private boolean singleSession = false;
    private boolean sniffOnly = false;
    boolean quitOnError = true;
    private boolean canTalkToDebugger;
    private static Hashtable sdpTable = new Hashtable();
    private boolean quitSDP;

    ProxyTypeManager getPTM() {
        return this.ptm;
    }

    public static SDP getSDP(String proxyName) {
        return (SDP)sdpTable.get(proxyName);
    }

    public String getProxyName() {
        return this.proxyName;
    }

    ThreadProxiesManager getTPM() {
        return this.tpm;
    }

    private boolean parseArgs(String[] args) {
        String logLevel = "none";
        String logURL = null;
        String classPath = null;
        for (int argc = 0; argc != args.length; ++argc) {
            String arg = args[argc];
            try {
                if (arg.startsWith("-cp:")) {
                    classPath = ArgsUtilities.toPlatformPath((String)arg.substring("-cp:".length()), (boolean)true);
                    continue;
                }
                if (arg.startsWith("-log:")) {
                    logLevel = arg.substring("-log:".length());
                    continue;
                }
                if (arg.startsWith("-logFile:")) {
                    logURL = "file://" + arg.substring("-logFile:".length());
                    continue;
                }
                if (arg.startsWith("-replay:")) {
                    this.debugger_url = arg.substring("-replay:".length());
                    continue;
                }
                if (arg.startsWith("-l:")) {
                    this.debugger_url = "serversocket://:" + arg.substring("-l:".length());
                    continue;
                }
                if (arg.startsWith("-vm:")) {
                    this.vm_url = arg.substring("-vm:".length());
                    continue;
                }
                if (arg.startsWith("-debugger:")) {
                    this.debugger_url = arg.substring("-debugger:".length());
                    continue;
                }
                if (arg.startsWith("-retry:")) {
                    try {
                        this.retry = Integer.parseInt(arg.substring("-retry:".length()));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.usage("argument to '-retry' must be an integer");
                        return false;
                    }
                }
                if (arg.startsWith("-quitOnError:")) {
                    String boolStr = arg.substring("-quitOnError:".length());
                    this.quitOnError = Boolean.parseBoolean(boolStr);
                    continue;
                }
                if (arg.equals("-h")) {
                    this.usage(null);
                    return false;
                }
                if (arg.equals("-singlesession")) {
                    this.singleSession = true;
                    continue;
                }
                if (arg.equals("-sniffer")) {
                    this.sniffOnly = true;
                    continue;
                }
                if (arg.startsWith("-killport:")) {
                    try {
                        this.killPort = Integer.parseInt(arg.substring("-killport:".length()));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.usage("Expected integer argument " + arg);
                        return false;
                    }
                }
                this.usage("Unknown option: " + arg);
                return false;
            }
            catch (NumberFormatException e) {
                System.err.println("Badly formatted option: " + arg);
                return false;
            }
        }
        if (!this.sniffOnly) {
            if (classPath == null) {
                System.err.println("A path for the Squawk classes must be specified using the -cp option. For example:");
                System.err.println("    -cp:j2me/j2meclasses:debugger/j2meclasses:samples/j2meclasses");
                return false;
            }
            ProxySupport.initializeTranslator(classPath);
        }
        System.setProperty("squawk.debugger.log.level", logLevel);
        if (logURL != null) {
            System.setProperty("squawk.debugger.log.url", logURL);
        }
        this.proxyName = this.debugger_url.indexOf("serversocket://:") == 0 ? this.debugger_url.substring("serversocket://:".length()) : this.debugger_url;
        return true;
    }

    private void usage(String errMsg) {
        PrintStream out = System.out;
        if (errMsg != null) {
            out.println(errMsg);
        }
        out.println("Usage: SDP [-options] ");
        out.println("where options include:");
        out.println();
        out.println("    -debugger:<url> The URL of the channel that debug proxy will");
        out.println("                    listen on for a connection from a JPDA debugger.");
        out.println("                    Only specify -debugger OR -l, not both.");
        out.println("                    (default is " + this.debugger_url + ").");
        out.println("    -retry:<n>      retry to connect to VM every 'n' seconds (default is " + this.retry + ")");
        out.println("    -l:<port>       local port number that the debug proxy will");
        out.println("                    listen on for a connection from a JPDA debugger.");
        out.println("                    (default is 2900)");
        out.println("    -vm:<url>       The URL of the channel to the VM running the");
        out.println("                    application to be debugged.");
        out.println("                    (default is " + this.vm_url + ").");
        out.println("    -log:<level>    sets logging level to 'none', 'info', 'verbose' or 'debug'");
        out.println("    -logFile:<file> where messages should be logged (default is stdout),");
        out.println("    -cp:<path>      a list of paths separated by '" + File.pathSeparator + "' where the");
        out.println("                    debug proxy can find class files.");
        out.println("                    (default is '.')");
        out.println("    -singlesession  allow only one connection from a debugger before exiting");
        out.println("    -sniffer        act as a JDWP packet sniffer between a JVM and a debugger,");
        out.println("                    logging packets as specified by -log and -logfile options.");
        out.println("    -quitOnError:<b> If false, the proxy will try to ignore certain proxy errors.");
        out.println("                    (default is true).");
        out.println("    -h              shows this usage message");
        out.println();
    }

    public void quit() {
        this.quitSDP = true;
        if (this.sda != null) {
            this.sda.quit();
        }
        if (this.jdb != null) {
            this.jdb.quit();
        }
    }

    synchronized void setCanTalkToDebugger() {
        this.canTalkToDebugger = true;
        this.notifyAll();
    }

    synchronized void waitTillReadyForDebugger0(boolean showProgress) throws SDWPException {
        if (showProgress) {
            System.out.print("Synchronizing debug state with VM...");
            System.out.flush();
        }
        while (!this.canTalkToDebugger) {
            if (Log.debug()) {
                Log.log((String)"Waiting for proxy types to be populated...");
            }
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (showProgress) {
                System.out.print(".");
                System.out.flush();
            }
            if (this.sda.hasQuit()) {
                throw new SDWPException();
            }
            if (!Log.debug() || !this.canTalkToDebugger) continue;
            Log.log((String)"...Proxy types are populated");
        }
        if (showProgress) {
            System.out.println("");
            System.out.flush();
        }
    }

    public boolean waitTillReadyForDebugger() {
        try {
            this.waitTillReadyForDebugger0(false);
            return true;
        }
        catch (SDWPException e) {
            System.err.println("Error while waiting for proxy to sync with VM: " + (Object)((Object)e));
            return false;
        }
    }

    private static boolean connect(boolean toVM, final SDP sdp, JDWPListener listener, String handshakeStr, String url) {
        byte[] handshake = handshakeStr.getBytes();
        String targetName = toVM ? "VM" : "Debugger";
        while (true) {
            try {
                long now = System.currentTimeMillis();
                if (toVM) {
                    System.out.println("Trying to connect to VM on " + url);
                    listener.open(url, handshake, true, false, null);
                } else {
                    System.out.println("Waiting for connection from debugger on " + url);
                    listener.open(url, handshake, false, true, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                sdp.waitTillReadyForDebugger0(true);
                            }
                            catch (SDWPException sDWPException) {
                                // empty catch block
                            }
                        }
                    });
                }
                System.out.println("Established connection to " + targetName + " (handshake took " + (System.currentTimeMillis() - now) + "ms)");
                return true;
            }
            catch (IOException e) {
                if (sdp.quitSDP) {
                    return false;
                }
                System.out.println("Failed to establish connection with " + targetName + ": " + e.getMessage() + " - trying again in " + sdp.retry + " seconds...");
                try {
                    Thread.sleep(sdp.retry * 1000);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (toVM) continue;
                return false;
            }
            break;
        }
    }

    private static boolean connectToVM(SDP sdp, JDWPListener listener, String handshakeStr) {
        return SDP.connect(true, sdp, listener, handshakeStr, sdp.vm_url);
    }

    private static boolean connectToDebugger(SDP sdp, JDWPListener listener, String handshakeStr) {
        return SDP.connect(false, sdp, listener, handshakeStr, sdp.debugger_url);
    }

    private void go() {
        this.sda = new SDAListener(this);
        this.ptm = new ProxyTypeManager();
        this.tpm = new ThreadProxiesManager();
        if (!SDP.connectToVM(this, this.sda, "SDWP-Handshake")) {
            return;
        }
        this.ptm.setVM(this.sda);
        this.jdb = new JDBListener(this);
        this.jdb.bindProxyPeer(this.sda);
        this.eventManager = new SDPEventManager(new MatcherImpl());
        Thread sdaThread = new Thread((Runnable)((Object)this.sda), "SDAListener");
        Thread jdbThread = new Thread((Runnable)((Object)this.jdb), "JDBListener");
        sdaThread.start();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!SDP.connectToDebugger(this, this.jdb, "JDWP-Handshake")) {
            this.sda.quit();
            this.jdb.quit();
            return;
        }
        if (!this.sda.hasQuit()) {
            jdbThread.start();
        }
        try {
            sdaThread.join();
            jdbThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (Log.info()) {
            Log.log((String)"Completed shutdown");
        }
        System.out.println("Debug session completed.");
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        SDP sdp = new SDP();
        try {
            Thread.currentThread().setName("SDP");
            if (!sdp.parseArgs(args)) {
                System.exit(1);
            }
            if (sdp.killPort != 0) {
                SDP.killOthers(sdp.killPort, sdp);
            }
            sdpTable.put(sdp.getProxyName(), sdp);
            do {
                if (sdp.sniffOnly) {
                    sdp.goSniff();
                    continue;
                }
                sdp.go();
            } while (!sdp.singleSession);
        }
        finally {
            sdpTable.remove(sdp.getProxyName());
        }
    }

    public static void killOthers(int killPort, final SDP me) {
        DatagramSocket socket = null;
        while (true) {
            int currentKillPort = killPort;
            while (true) {
                try {
                    if (Log.verbose()) {
                        Log.log((String)("--- trying port " + currentKillPort));
                    }
                    socket = new DatagramSocket(currentKillPort);
                    if (!Log.verbose()) break;
                    Log.log((String)"--- got it");
                }
                catch (SocketException e) {
                    ++currentKillPort;
                    continue;
                }
                break;
            }
            if (currentKillPort == killPort) break;
            byte[] buffer = new byte[]{-127, 126};
            DatagramPacket packet = null;
            try {
                packet = new DatagramPacket(buffer, 0, buffer.length, new InetSocketAddress(killPort));
            }
            catch (SocketException e) {
                continue;
            }
            try {
                if (Log.verbose()) {
                    Log.log((String)"--- sending kill");
                }
                socket.send(packet);
            }
            catch (IOException e) {
                // empty catch block
            }
            socket.close();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {}
        }
        if (Log.verbose()) {
            Log.log((String)"--- getting ready to listen for kill");
        }
        final DatagramSocket finalSocket = socket;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                byte[] buffer = new byte[2];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                try {
                    while (true) {
                        finalSocket.receive(packet);
                        if (packet.getLength() != 2 || buffer[0] != -127 || buffer[1] != 126) continue;
                        if (Log.verbose()) {
                            Log.log((String)"--- received kill");
                        }
                        me.quit();
                        finalSocket.close();
                    }
                }
                catch (IOException e) {
                    return;
                }
            }
        });
        thread.setName("SDP.killListenThread");
        thread.start();
    }

    private void goSniff() {
        this.canTalkToDebugger = true;
        JDWPSniffer.JVMSniffer vmSniffer = new JDWPSniffer.JVMSniffer();
        if (!SDP.connectToVM(this, vmSniffer, "JDWP-Handshake")) {
            return;
        }
        JDWPSniffer.JDBSniffer dbSniffer = new JDWPSniffer.JDBSniffer();
        if (!SDP.connectToDebugger(this, dbSniffer, "JDWP-Handshake")) {
            vmSniffer.quit();
            dbSniffer.quit();
            return;
        }
        dbSniffer.bindProxyPeer(vmSniffer);
        Thread jvmThread = new Thread((Runnable)((Object)vmSniffer), "JVM-Sniffer");
        Thread jdbThread = new Thread((Runnable)((Object)dbSniffer), "Debugger-Sniffer");
        jvmThread.start();
        jdbThread.start();
        try {
            jvmThread.join();
            jdbThread.join();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (Log.info()) {
            Log.log((String)"Completed shutdown");
        }
        System.out.println("Sniff session completed.");
        System.out.println();
    }

    public void suspendThreads(Thread thread) {
        try {
            if (thread == null) {
                this.tpm.suspendAllThreads();
                CommandPacket command = new CommandPacket(1, 8, false);
                this.sda.sendCommand(command);
            } else {
                ProxyThread pt = (ProxyThread)thread;
                pt.setSuspendCount(pt.getSuspendCount() + 1);
                CommandPacket command = new CommandPacket(11, 2, false);
                command.getOutputStream().writeObjectID(pt.id, "thread");
                this.sda.sendCommand(command);
            }
        }
        catch (IOException e) {
            System.err.println("Error sending suspend command to VM: ");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Error sending suspend command to VM: ");
            e.printStackTrace();
        }
    }

    class Unsupported
    extends SDPEventRequest {
        public Unsupported(int id, PacketInputStream in, int kind) throws SDWPException, IOException {
            super(id, in, kind);
        }

        @Override
        public void write(PacketOutputStream out, Debugger.Event event) throws IOException {
            Assert.shouldNotReachHere();
        }

        public boolean matchKind(int eventKind) {
            return false;
        }
    }

    abstract class SDPEventRequest
    extends EventRequest {
        protected SDPEventRequest(int kind, int suspendPolicy) {
            super(kind, suspendPolicy);
        }

        protected SDPEventRequest(int id, PacketInputStream in, int kind) throws SDWPException, IOException {
            super(id, in, kind);
        }

        protected EventRequestModifier readModifier(PacketInputStream in, int kind) throws SDWPException, IOException {
            EventRequestModifier.Count modifier;
            byte modKind = in.readByte("modKind");
            switch (modKind) {
                case 1: {
                    modifier = new EventRequestModifier.Count(in);
                    break;
                }
                case 4: {
                    modifier = new EventRequestModifier.ClassOnly(in, kind);
                    break;
                }
                case 5: {
                    modifier = new EventRequestModifier.ClassMatch(in, kind, false);
                    break;
                }
                case 6: {
                    modifier = new EventRequestModifier.ClassMatch(in, kind, true);
                    break;
                }
                case 3: {
                    modifier = new EventRequestModifier.ThreadOnly(in, kind);
                    break;
                }
                default: {
                    throw new SDWPException(99, "Unimplemented modkind " + modKind);
                }
            }
            return modifier;
        }

        abstract void write(PacketOutputStream var1, Debugger.Event var2) throws IOException, SDWPException;
    }

    class SDPEventManager
    extends EventManager {
        private int nextEventID;

        SDPEventManager(EventRequestModifier.Matcher matcher) {
            super(matcher);
            this.nextEventID = 1;
        }

        public boolean isMyEventRequestID(int id) {
            return (id & 1) == 1;
        }

        private int getNextEventRequestID() {
            int id = this.nextEventID += 2;
            Assert.that((boolean)this.isMyEventRequestID(id));
            return id;
        }

        public int registerEventRequest(PacketInputStream in) throws IOException, SDWPException {
            Unsupported request;
            byte kind = in.readByte("eventKind");
            switch (kind) {
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 90: 
                case 99: {
                    return -1;
                }
                case 3: 
                case 5: 
                case 9: 
                case 10: 
                case 20: 
                case 21: 
                case 30: 
                case 40: 
                case 41: {
                    request = new Unsupported(this.getNextEventRequestID(), in, kind);
                    break;
                }
                default: {
                    throw new SDWPException(102, "event kind = " + kind);
                }
            }
            this.register(request);
            return request.id;
        }

        public void send(Debugger.Event event, EventManager.MatchedRequests mr) throws IOException, SDWPException {
            Assert.that((mr.suspendPolicy == 0 ? 1 : 0) != 0);
            CommandPacket command = new CommandPacket(64, 100, false);
            PacketOutputStream out = command.getOutputStream();
            out.writeByte(mr.suspendPolicy, "suspendPolicy");
            out.writeInt(mr.requests.size(), "events");
            Enumeration e = mr.requests.elements();
            while (e.hasMoreElements()) {
                SDPEventRequest request = (SDPEventRequest)((Object)e.nextElement());
                out.writeByte(request.kind, "eventKind");
                out.writeInt(request.id, "requestID");
                request.write(out, event);
                if (!Log.info()) continue;
                Log.log((String)("Added notification: " + (Object)((Object)request)));
            }
            SDP.this.jdb.sendCommand(command);
        }
    }

    class MatcherImpl
    implements EventRequestModifier.Matcher {
        MatcherImpl() {
        }

        public boolean matches(EventRequestModifier.ClassMatch modifier, Debugger.Event event) {
            String name = ((ProxyType)event.object).getName();
            boolean result = false;
            switch (modifier.matchKind) {
                case 1: {
                    result = name.equals(modifier.pattern);
                    break;
                }
                case 2: {
                    result = name.startsWith(modifier.pattern);
                    break;
                }
                case 3: {
                    result = name.endsWith(modifier.pattern);
                    break;
                }
                case 4: {
                    result = name.indexOf(modifier.pattern) != -1;
                    break;
                }
                default: {
                    Assert.shouldNotReachHere();
                }
            }
            return modifier.exclude ^ result;
        }

        public boolean matches(EventRequestModifier.ClassOnly modifier, Debugger.Event event) {
            ProxyType type = (ProxyType)event.object;
            try {
                return SDP.this.ptm.lookup(modifier.clazz, true).getKlass().isAssignableFrom(type.getKlass());
            }
            catch (SDWPException e) {
                System.err.println("Class ID in ClassOnly modifier is invalid: " + (Object)((Object)e));
                return false;
            }
        }

        public boolean matches(EventRequestModifier.ExceptionOnly modifier, Debugger.Event event) {
            return false;
        }

        public boolean matches(EventRequestModifier.LocationOnly modifier, Debugger.Event event) {
            return false;
        }
    }

    static class ThreadProxiesManager {
        private Map<DataType.ObjectID, ProxyThread> liveThreads = new HashMap<DataType.ObjectID, ProxyThread>();
        private HashMap<DataType.ObjectID, ProxyThread> zombieThreads = new HashMap();

        ThreadProxiesManager() {
        }

        synchronized void suspendAllThreads() {
            for (ProxyThread pt : this.liveThreads.values()) {
                pt.setSuspendCount(pt.getSuspendCount() + 1);
            }
        }

        synchronized ProxyThread getRunningThread() {
            for (ProxyThread thread : this.liveThreads.values()) {
                if (thread.getStatus() != 1 || thread.isSuspended()) continue;
                return thread;
            }
            return null;
        }

        synchronized ProxyThread getSomeThread() {
            Iterator<ProxyThread> i = this.liveThreads.values().iterator();
            if (i.hasNext()) {
                return i.next();
            }
            return null;
        }

        synchronized Collection<ProxyThread> getThreads() {
            Assert.that((!this.liveThreads.isEmpty() ? 1 : 0) != 0);
            return new ArrayList<ProxyThread>(this.liveThreads.values());
        }

        synchronized ProxyThread getThread(DataType.ObjectID id) throws SDWPException {
            ProxyThread thread = this.liveThreads.get(id);
            if (thread == null && (thread = this.zombieThreads.get(id)) == null) {
                throw new SDWPException(10, "object ID does not denote a Thread instance: " + id);
            }
            return thread;
        }

        synchronized void updateThreads(PacketInputStream in) throws IOException {
            int count = in.readInt("threads");
            HashMap<DataType.ObjectID, ProxyThread> nowLive = new HashMap<DataType.ObjectID, ProxyThread>(count);
            for (int i = 0; i != count; ++i) {
                DataType.ObjectID id = in.readObjectID("thread");
                int status = in.readInt("status");
                int suspendCount = in.readInt("suspendCount");
                String name = in.readString("name");
                ProxyThread thread = this.liveThreads.get(id);
                if (thread == null) {
                    thread = new ProxyThread(id, name, status, suspendCount);
                    this.liveThreads.put(id, thread);
                } else {
                    thread.setName(name);
                    thread.setStatus(status);
                    thread.setSuspendCount(suspendCount);
                }
                nowLive.put(id, thread);
            }
            Set<DataType.ObjectID> liveThreadKeys = this.liveThreads.keySet();
            Iterator<DataType.ObjectID> i = liveThreadKeys.iterator();
            while (i.hasNext()) {
                DataType.ObjectID id = i.next();
                if (nowLive.get(id) != null) continue;
                ProxyThread deadThread = this.liveThreads.get(id);
                deadThread.setStatus(0);
                deadThread.setSuspendCount(0);
                i.remove();
                Assert.always((this.liveThreads.get(id) == null ? 1 : 0) != 0);
                this.zombieThreads.put(id, deadThread);
            }
        }

        synchronized void updateThread(DataType.ObjectID id, String name, int status, int suspendCount) {
            Assert.always((this.zombieThreads.get(id) == null ? 1 : 0) != 0);
            ProxyThread thread = this.liveThreads.get(id);
            if (thread == null) {
                thread = new ProxyThread(id, name, status, suspendCount);
                this.liveThreads.put(id, thread);
            } else {
                thread.setName(name);
                thread.setStatus(status);
                thread.setSuspendCount(suspendCount);
            }
            if (status == 0) {
                this.liveThreads.remove(id);
                this.zombieThreads.put(id, thread);
            }
        }
    }
}

