/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2;

import edu.wpi.first.wpilibj.networktables2.AbstractNetworkTableEntryStore;
import edu.wpi.first.wpilibj.networktables2.connection.NetworkTableConnection;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryType;
import java.io.DataOutputStream;
import java.io.IOException;

public class NetworkTableEntry {
    public static final char UNKNOWN_ID = '\uffff';
    private char id;
    private char sequenceNumber;
    public final String name;
    private NetworkTableEntryType type;
    private Object value;
    private volatile boolean isNew = true;
    private volatile boolean isDirty = false;
    private static final char HALF_OF_CHAR = '\u8000';

    public NetworkTableEntry(String name, NetworkTableEntryType type, Object value) {
        this('\uffff', name, '\u0000', type, value);
    }

    public NetworkTableEntry(char id, String name, char sequenceNumber, NetworkTableEntryType type, Object value) {
        this.id = id;
        this.name = name;
        this.sequenceNumber = sequenceNumber;
        this.type = type;
        this.value = value;
    }

    public char getId() {
        return this.id;
    }

    public Object getValue() {
        return this.value;
    }

    public NetworkTableEntryType getType() {
        return this.type;
    }

    public boolean putValue(char newSequenceNumber, Object newValue) {
        if (this.sequenceNumber < newSequenceNumber && newSequenceNumber - this.sequenceNumber < 32768 || this.sequenceNumber > newSequenceNumber && this.sequenceNumber - newSequenceNumber > 32768) {
            this.value = newValue;
            this.sequenceNumber = newSequenceNumber;
            return true;
        }
        return false;
    }

    public void forcePut(char newSequenceNumber, Object newValue) {
        this.value = newValue;
        this.sequenceNumber = newSequenceNumber;
    }

    public void forcePut(char newSequenceNumber, NetworkTableEntryType type, Object newValue) {
        this.type = type;
        this.forcePut(newSequenceNumber, newValue);
    }

    public void makeDirty() {
        this.isDirty = true;
    }

    public void makeClean() {
        this.isDirty = false;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void sendValue(DataOutputStream os) throws IOException {
        this.type.sendValue(this.value, os);
    }

    public char getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setId(char id) throws IllegalStateException {
        if (this.id != '\uffff') {
            throw new IllegalStateException("Cannot set the Id of a table entry that already has a valid id");
        }
        this.id = id;
    }

    public void clearId() {
        this.id = (char)65535;
    }

    public void send(NetworkTableConnection connection) throws IOException {
        connection.sendEntryAssignment(this);
    }

    public void fireListener(AbstractNetworkTableEntryStore.TableListenerManager listenerManager) {
        listenerManager.fireTableListeners(this.name, this.value, this.isNew);
        this.isNew = false;
    }

    public String toString() {
        return "Network Table " + this.type.name + " entry: " + this.name + ": " + this.getId() + " - " + this.getSequenceNumber() + " - " + this.getValue();
    }
}

