/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.client;

public class ClientConnectionState {
    public static final ClientConnectionState DISCONNECTED_FROM_SERVER = new ClientConnectionState("DISCONNECTED_FROM_SERVER");
    public static final ClientConnectionState CONNECTED_TO_SERVER = new ClientConnectionState("CONNECTED_TO_SERVER");
    public static final ClientConnectionState SENT_HELLO_TO_SERVER = new ClientConnectionState("SENT_HELLO_TO_SERVER");
    public static final ClientConnectionState IN_SYNC_WITH_SERVER = new ClientConnectionState("IN_SYNC_WITH_SERVER");
    private String name;

    protected ClientConnectionState(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static class Error
    extends ClientConnectionState {
        private final Exception e;

        public Error(Exception e) {
            super("CLIENT_ERROR");
            this.e = e;
        }

        public Exception getException() {
            return this.e;
        }

        @Override
        public String toString() {
            return "CLIENT_ERROR: " + this.e.getClass() + ": " + this.e.getMessage();
        }
    }

    public static class ProtocolUnsuppotedByServer
    extends ClientConnectionState {
        private final char serverVersion;

        public ProtocolUnsuppotedByServer(char serverVersion) {
            super("PROTOCOL_UNSUPPORTED_BY_SERVER");
            this.serverVersion = serverVersion;
        }

        public char getServerVersion() {
            return this.serverVersion;
        }

        @Override
        public String toString() {
            return "PROTOCOL_UNSUPPORTED_BY_SERVER: Server Version: 0x" + Integer.toHexString(this.serverVersion);
        }
    }
}

