/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.connection;

import edu.wpi.first.wpilibj.networktables2.NetworkTableEntry;
import edu.wpi.first.wpilibj.networktables2.connection.BadMessageException;
import edu.wpi.first.wpilibj.networktables2.connection.ConnectionAdapter;
import edu.wpi.first.wpilibj.networktables2.stream.IOStream;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryType;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryTypeManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class NetworkTableConnection {
    public static final char PROTOCOL_REVISION = '\u0200';
    private final Object WRITE_LOCK = new Object();
    private final DataInputStream is;
    private final DataOutputStream os;
    public final IOStream stream;
    private final NetworkTableEntryTypeManager typeManager;
    private boolean isValid;

    public NetworkTableConnection(IOStream stream, NetworkTableEntryTypeManager typeManager) {
        this.stream = stream;
        this.typeManager = typeManager;
        this.is = new DataInputStream(new BufferedInputStream(stream.getInputStream()));
        this.os = new DataOutputStream(new BufferedOutputStream(stream.getOutputStream()));
        this.isValid = true;
    }

    public void close() {
        if (this.isValid) {
            this.isValid = false;
            this.stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageHeader(int messageType) throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.os.writeByte(messageType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.os.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKeepAlive() throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.sendMessageHeader(0);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendClientHello() throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.sendMessageHeader(1);
            this.os.writeChar(512);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendServerHelloComplete() throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.sendMessageHeader(3);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendProtocolVersionUnsupported() throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.sendMessageHeader(2);
            this.os.writeChar(512);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEntryAssignment(NetworkTableEntry entry) throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.sendMessageHeader(16);
            this.os.writeUTF(entry.name);
            this.os.writeByte(entry.getType().id);
            this.os.writeChar(entry.getId());
            this.os.writeChar(entry.getSequenceNumber());
            entry.sendValue(this.os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEntryUpdate(NetworkTableEntry entry) throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.sendMessageHeader(17);
            this.os.writeChar(entry.getId());
            this.os.writeChar(entry.getSequenceNumber());
            entry.sendValue(this.os);
        }
    }

    public void read(ConnectionAdapter adapter) throws IOException {
        byte messageType = this.is.readByte();
        switch (messageType) {
            case 0: {
                adapter.keepAlive();
                return;
            }
            case 1: {
                char protocolRevision = this.is.readChar();
                adapter.clientHello(protocolRevision);
                return;
            }
            case 3: {
                adapter.serverHelloComplete();
                return;
            }
            case 2: {
                char protocolRevision = this.is.readChar();
                adapter.protocolVersionUnsupported(protocolRevision);
                return;
            }
            case 16: {
                String entryName = this.is.readUTF();
                byte typeId = this.is.readByte();
                NetworkTableEntryType entryType = this.typeManager.getType(typeId);
                if (entryType == null) {
                    throw new BadMessageException("Unknown data type: 0x" + Integer.toHexString(typeId));
                }
                char entryId = this.is.readChar();
                char entrySequenceNumber = this.is.readChar();
                Object value = entryType.readValue(this.is);
                adapter.offerIncomingAssignment(new NetworkTableEntry(entryId, entryName, entrySequenceNumber, entryType, value));
                return;
            }
            case 17: {
                char entryId = this.is.readChar();
                char entrySequenceNumber = this.is.readChar();
                NetworkTableEntry entry = adapter.getEntry(entryId);
                if (entry == null) {
                    throw new BadMessageException("Received update for unknown entry id: " + entryId);
                }
                Object value = entry.getType().readValue(this.is);
                adapter.offerIncomingUpdate(entry, entrySequenceNumber, value);
                return;
            }
        }
        throw new BadMessageException("Unknown Network Table Message Type: " + messageType);
    }
}

