/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.server;

import edu.wpi.first.wpilibj.networktables2.NetworkTableNode;
import edu.wpi.first.wpilibj.networktables2.TransactionDirtier;
import edu.wpi.first.wpilibj.networktables2.WriteManager;
import edu.wpi.first.wpilibj.networktables2.server.ServerConnectionAdapter;
import edu.wpi.first.wpilibj.networktables2.server.ServerConnectionList;
import edu.wpi.first.wpilibj.networktables2.server.ServerIncomingConnectionListener;
import edu.wpi.first.wpilibj.networktables2.server.ServerIncomingStreamMonitor;
import edu.wpi.first.wpilibj.networktables2.server.ServerNetworkTableEntryStore;
import edu.wpi.first.wpilibj.networktables2.stream.IOStreamProvider;
import edu.wpi.first.wpilibj.networktables2.thread.DefaultThreadManager;
import edu.wpi.first.wpilibj.networktables2.thread.NTThreadManager;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryTypeManager;

public class NetworkTableServer
extends NetworkTableNode
implements ServerIncomingConnectionListener {
    private final ServerIncomingStreamMonitor incomingStreamMonitor;
    private final WriteManager writeManager;
    private final IOStreamProvider streamProvider;
    private final ServerConnectionList connectionList;

    public NetworkTableServer(IOStreamProvider streamProvider, NetworkTableEntryTypeManager typeManager, NTThreadManager threadManager) {
        ServerNetworkTableEntryStore entryStore = new ServerNetworkTableEntryStore(this);
        this.init(entryStore);
        this.streamProvider = streamProvider;
        this.connectionList = new ServerConnectionList();
        this.writeManager = new WriteManager(this.connectionList, threadManager, this.getEntryStore(), Long.MAX_VALUE);
        this.incomingStreamMonitor = new ServerIncomingStreamMonitor(streamProvider, entryStore, this, this.connectionList, typeManager, threadManager);
        this.getEntryStore().setIncomingReceiver(new TransactionDirtier(this.writeManager));
        this.getEntryStore().setOutgoingReceiver(new TransactionDirtier(this.writeManager));
        this.incomingStreamMonitor.start();
        this.writeManager.start();
    }

    public NetworkTableServer(IOStreamProvider streamProvider) {
        this(streamProvider, new NetworkTableEntryTypeManager(), new DefaultThreadManager());
    }

    @Override
    public void close() {
        try {
            this.incomingStreamMonitor.stop();
            this.writeManager.stop();
            this.connectionList.closeAll();
            Thread.sleep(1000L);
            this.streamProvider.close();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onNewConnection(ServerConnectionAdapter connectionAdapter) {
        this.connectionList.add(connectionAdapter);
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public boolean isServer() {
        return true;
    }
}

