/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.server;

import edu.wpi.first.wpilibj.networktables2.FlushableOutgoingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.IncomingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.NetworkTableEntry;
import edu.wpi.first.wpilibj.networktables2.connection.BadMessageException;
import edu.wpi.first.wpilibj.networktables2.connection.ConnectionAdapter;
import edu.wpi.first.wpilibj.networktables2.connection.ConnectionMonitorThread;
import edu.wpi.first.wpilibj.networktables2.connection.NetworkTableConnection;
import edu.wpi.first.wpilibj.networktables2.server.ServerAdapterManager;
import edu.wpi.first.wpilibj.networktables2.server.ServerConnectionState;
import edu.wpi.first.wpilibj.networktables2.server.ServerNetworkTableEntryStore;
import edu.wpi.first.wpilibj.networktables2.stream.IOStream;
import edu.wpi.first.wpilibj.networktables2.thread.NTThread;
import edu.wpi.first.wpilibj.networktables2.thread.NTThreadManager;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryTypeManager;
import java.io.EOFException;
import java.io.IOException;

public class ServerConnectionAdapter
implements ConnectionAdapter,
IncomingEntryReceiver,
FlushableOutgoingEntryReceiver {
    private final ServerNetworkTableEntryStore entryStore;
    private final IncomingEntryReceiver transactionReceiver;
    private final ServerAdapterManager adapterListener;
    public final NetworkTableConnection connection;
    private final NTThread readThread;
    private ServerConnectionState connectionState;

    private void gotoState(ServerConnectionState newState) {
        if (this.connectionState != newState) {
            System.out.println(this + " entered connection state: " + newState);
            this.connectionState = newState;
        }
    }

    public ServerConnectionAdapter(IOStream stream, ServerNetworkTableEntryStore entryStore, IncomingEntryReceiver transactionReceiver, ServerAdapterManager adapterListener, NetworkTableEntryTypeManager typeManager, NTThreadManager threadManager) {
        this.connection = new NetworkTableConnection(stream, typeManager);
        this.entryStore = entryStore;
        this.transactionReceiver = transactionReceiver;
        this.adapterListener = adapterListener;
        this.gotoState(ServerConnectionState.GOT_CONNECTION_FROM_CLIENT);
        this.readThread = threadManager.newBlockingPeriodicThread(new ConnectionMonitorThread(this, this.connection), "Server Connection Reader Thread");
    }

    @Override
    public void badMessage(BadMessageException e) {
        this.gotoState(new ServerConnectionState.Error(e));
        this.adapterListener.close(this, true);
    }

    @Override
    public void ioException(IOException e) {
        if (e instanceof EOFException) {
            this.gotoState(ServerConnectionState.CLIENT_DISCONNECTED);
        } else {
            this.gotoState(new ServerConnectionState.Error(e));
        }
        this.adapterListener.close(this, false);
    }

    public void shutdown(boolean closeStream) {
        this.readThread.stop();
        if (closeStream) {
            this.connection.close();
        }
    }

    @Override
    public void keepAlive() throws IOException {
    }

    @Override
    public void clientHello(char protocolRevision) throws IOException {
        if (this.connectionState != ServerConnectionState.GOT_CONNECTION_FROM_CLIENT) {
            throw new BadMessageException("A server should not receive a client hello after it has already connected/entered an error state");
        }
        if (protocolRevision != '\u0200') {
            this.connection.sendProtocolVersionUnsupported();
            throw new BadMessageException("Client Connected with bad protocol revision: 0x" + Integer.toHexString(protocolRevision));
        }
        this.entryStore.sendServerHello(this.connection);
        this.gotoState(ServerConnectionState.CONNECTED_TO_CLIENT);
    }

    @Override
    public void protocolVersionUnsupported(char protocolRevision) throws IOException {
        throw new BadMessageException("A server should not receive a protocol version unsupported message");
    }

    @Override
    public void serverHelloComplete() throws IOException {
        throw new BadMessageException("A server should not receive a server hello complete message");
    }

    @Override
    public void offerIncomingAssignment(NetworkTableEntry entry) {
        this.transactionReceiver.offerIncomingAssignment(entry);
    }

    @Override
    public void offerIncomingUpdate(NetworkTableEntry entry, char sequenceNumber, Object value) {
        this.transactionReceiver.offerIncomingUpdate(entry, sequenceNumber, value);
    }

    @Override
    public NetworkTableEntry getEntry(char id) {
        return this.entryStore.getEntry(id);
    }

    @Override
    public void offerOutgoingAssignment(NetworkTableEntry entry) {
        try {
            if (this.connectionState == ServerConnectionState.CONNECTED_TO_CLIENT) {
                this.connection.sendEntryAssignment(entry);
            }
        }
        catch (IOException e) {
            this.ioException(e);
        }
    }

    @Override
    public void offerOutgoingUpdate(NetworkTableEntry entry) {
        try {
            if (this.connectionState == ServerConnectionState.CONNECTED_TO_CLIENT) {
                this.connection.sendEntryUpdate(entry);
            }
        }
        catch (IOException e) {
            this.ioException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.connection.flush();
        }
        catch (IOException e) {
            this.ioException(e);
        }
    }

    public ServerConnectionState getConnectionState() {
        return this.connectionState;
    }

    @Override
    public void ensureAlive() {
        try {
            this.connection.sendKeepAlive();
        }
        catch (IOException e) {
            this.ioException(e);
        }
    }
}

