/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TextParseException;

public class SetResponseTest
extends TestCase {
    public void test_ctor_1arg() {
        int[] types = new int[]{0, 1, 2, 3, 4, 5, 6};
        for (int i = 0; i < types.length; ++i) {
            SetResponse sr = new SetResponse(types[i]);
            SetResponseTest.assertNull((Object)sr.getNS());
            SetResponseTest.assertEquals((types[i] == 0 ? 1 : 0) != 0, (boolean)sr.isUnknown());
            SetResponseTest.assertEquals((types[i] == 1 ? 1 : 0) != 0, (boolean)sr.isNXDOMAIN());
            SetResponseTest.assertEquals((types[i] == 2 ? 1 : 0) != 0, (boolean)sr.isNXRRSET());
            SetResponseTest.assertEquals((types[i] == 3 ? 1 : 0) != 0, (boolean)sr.isDelegation());
            SetResponseTest.assertEquals((types[i] == 4 ? 1 : 0) != 0, (boolean)sr.isCNAME());
            SetResponseTest.assertEquals((types[i] == 5 ? 1 : 0) != 0, (boolean)sr.isDNAME());
            SetResponseTest.assertEquals((types[i] == 6 ? 1 : 0) != 0, (boolean)sr.isSuccessful());
        }
    }

    public void test_ctor_1arg_toosmall() {
        try {
            new SetResponse(-1);
            SetResponseTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_ctor_1arg_toobig() {
        try {
            new SetResponse(7);
            SetResponseTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_ctor_2arg() {
        int[] types = new int[]{0, 1, 2, 3, 4, 5, 6};
        for (int i = 0; i < types.length; ++i) {
            RRset rs = new RRset();
            SetResponse sr = new SetResponse(types[i], rs);
            SetResponseTest.assertSame((Object)rs, (Object)sr.getNS());
            SetResponseTest.assertEquals((types[i] == 0 ? 1 : 0) != 0, (boolean)sr.isUnknown());
            SetResponseTest.assertEquals((types[i] == 1 ? 1 : 0) != 0, (boolean)sr.isNXDOMAIN());
            SetResponseTest.assertEquals((types[i] == 2 ? 1 : 0) != 0, (boolean)sr.isNXRRSET());
            SetResponseTest.assertEquals((types[i] == 3 ? 1 : 0) != 0, (boolean)sr.isDelegation());
            SetResponseTest.assertEquals((types[i] == 4 ? 1 : 0) != 0, (boolean)sr.isCNAME());
            SetResponseTest.assertEquals((types[i] == 5 ? 1 : 0) != 0, (boolean)sr.isDNAME());
            SetResponseTest.assertEquals((types[i] == 6 ? 1 : 0) != 0, (boolean)sr.isSuccessful());
        }
    }

    public void test_ctor_2arg_toosmall() {
        try {
            new SetResponse(-1, new RRset());
            SetResponseTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_ctor_2arg_toobig() {
        try {
            new SetResponse(7, new RRset());
            SetResponseTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_ofType_basic() {
        int[] types = new int[]{3, 4, 5, 6};
        for (int i = 0; i < types.length; ++i) {
            SetResponse sr = SetResponse.ofType(types[i]);
            SetResponseTest.assertNull((Object)sr.getNS());
            SetResponseTest.assertEquals((types[i] == 0 ? 1 : 0) != 0, (boolean)sr.isUnknown());
            SetResponseTest.assertEquals((types[i] == 1 ? 1 : 0) != 0, (boolean)sr.isNXDOMAIN());
            SetResponseTest.assertEquals((types[i] == 2 ? 1 : 0) != 0, (boolean)sr.isNXRRSET());
            SetResponseTest.assertEquals((types[i] == 3 ? 1 : 0) != 0, (boolean)sr.isDelegation());
            SetResponseTest.assertEquals((types[i] == 4 ? 1 : 0) != 0, (boolean)sr.isCNAME());
            SetResponseTest.assertEquals((types[i] == 5 ? 1 : 0) != 0, (boolean)sr.isDNAME());
            SetResponseTest.assertEquals((types[i] == 6 ? 1 : 0) != 0, (boolean)sr.isSuccessful());
            SetResponse sr2 = SetResponse.ofType(types[i]);
            SetResponseTest.assertNotSame((Object)sr, (Object)sr2);
        }
    }

    public void test_ofType_singleton() {
        int[] types = new int[]{0, 1, 2};
        for (int i = 0; i < types.length; ++i) {
            SetResponse sr = SetResponse.ofType(types[i]);
            SetResponseTest.assertNull((Object)sr.getNS());
            SetResponseTest.assertEquals((types[i] == 0 ? 1 : 0) != 0, (boolean)sr.isUnknown());
            SetResponseTest.assertEquals((types[i] == 1 ? 1 : 0) != 0, (boolean)sr.isNXDOMAIN());
            SetResponseTest.assertEquals((types[i] == 2 ? 1 : 0) != 0, (boolean)sr.isNXRRSET());
            SetResponseTest.assertEquals((types[i] == 3 ? 1 : 0) != 0, (boolean)sr.isDelegation());
            SetResponseTest.assertEquals((types[i] == 4 ? 1 : 0) != 0, (boolean)sr.isCNAME());
            SetResponseTest.assertEquals((types[i] == 5 ? 1 : 0) != 0, (boolean)sr.isDNAME());
            SetResponseTest.assertEquals((types[i] == 6 ? 1 : 0) != 0, (boolean)sr.isSuccessful());
            SetResponse sr2 = SetResponse.ofType(types[i]);
            SetResponseTest.assertSame((Object)sr, (Object)sr2);
        }
    }

    public void test_ofType_toosmall() {
        try {
            SetResponse.ofType(-1);
            SetResponseTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_ofType_toobig() {
        try {
            SetResponse.ofType(7);
            SetResponseTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_addRRset() throws TextParseException, UnknownHostException {
        RRset rrs = new RRset();
        rrs.addRR(new ARecord(Name.fromString("The.Name."), 1, 43981L, InetAddress.getByName("192.168.0.1")));
        rrs.addRR(new ARecord(Name.fromString("The.Name."), 1, 43981L, InetAddress.getByName("192.168.0.2")));
        SetResponse sr = new SetResponse(6);
        sr.addRRset(rrs);
        Object[] exp = new RRset[]{rrs};
        SetResponseTest.assertTrue((boolean)Arrays.equals(exp, sr.answers()));
    }

    public void test_addRRset_multiple() throws TextParseException, UnknownHostException {
        RRset rrs = new RRset();
        rrs.addRR(new ARecord(Name.fromString("The.Name."), 1, 43981L, InetAddress.getByName("192.168.0.1")));
        rrs.addRR(new ARecord(Name.fromString("The.Name."), 1, 43981L, InetAddress.getByName("192.168.0.2")));
        RRset rrs2 = new RRset();
        rrs2.addRR(new ARecord(Name.fromString("The.Other.Name."), 1, 43982L, InetAddress.getByName("192.168.1.1")));
        rrs2.addRR(new ARecord(Name.fromString("The.Other.Name."), 1, 43982L, InetAddress.getByName("192.168.1.2")));
        SetResponse sr = new SetResponse(6);
        sr.addRRset(rrs);
        sr.addRRset(rrs2);
        Object[] exp = new RRset[]{rrs, rrs2};
        SetResponseTest.assertTrue((boolean)Arrays.equals(exp, sr.answers()));
    }

    public void test_answers_nonSUCCESSFUL() {
        SetResponse sr = new SetResponse(0, new RRset());
        SetResponseTest.assertNull((Object)sr.answers());
    }

    public void test_getCNAME() throws TextParseException, UnknownHostException {
        RRset rrs = new RRset();
        CNAMERecord cr = new CNAMERecord(Name.fromString("The.Name."), 1, 43981L, Name.fromString("The.Alias."));
        rrs.addRR(cr);
        SetResponse sr = new SetResponse(4, rrs);
        SetResponseTest.assertEquals((Object)cr, (Object)sr.getCNAME());
    }

    public void test_getDNAME() throws TextParseException, UnknownHostException {
        RRset rrs = new RRset();
        DNAMERecord dr = new DNAMERecord(Name.fromString("The.Name."), 1, 43981L, Name.fromString("The.Alias."));
        rrs.addRR(dr);
        SetResponse sr = new SetResponse(5, rrs);
        SetResponseTest.assertEquals((Object)dr, (Object)sr.getDNAME());
    }

    public void test_toString() throws TextParseException, UnknownHostException {
        int[] types = new int[]{0, 1, 2, 3, 4, 5, 6};
        RRset rrs = new RRset();
        rrs.addRR(new ARecord(Name.fromString("The.Name."), 1, 43981L, InetAddress.getByName("192.168.0.1")));
        String[] labels = new String[]{"unknown", "NXDOMAIN", "NXRRSET", "delegation: " + rrs, "CNAME: " + rrs, "DNAME: " + rrs, "successful"};
        for (int i = 0; i < types.length; ++i) {
            SetResponse sr = new SetResponse(types[i], rrs);
            SetResponseTest.assertEquals((String)labels[i], (String)sr.toString());
        }
    }
}

