/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.U16NameBase;

public class U16NameBaseTest
extends TestCase {
    private void assertEquals(byte[] exp, byte[] act) {
        U16NameBaseTest.assertTrue((boolean)Arrays.equals(exp, act));
    }

    public void test_ctor_0arg() {
        TestClass tc = new TestClass();
        U16NameBaseTest.assertNull((Object)tc.getName());
        U16NameBaseTest.assertEquals((int)0, (int)tc.getType());
        U16NameBaseTest.assertEquals((int)0, (int)tc.getDClass());
        U16NameBaseTest.assertEquals((long)0L, (long)tc.getTTL());
        U16NameBaseTest.assertEquals((int)0, (int)tc.getU16Field());
        U16NameBaseTest.assertNull((Object)tc.getNameField());
    }

    public void test_ctor_4arg() throws TextParseException {
        Name n = Name.fromString("My.Name.");
        TestClass tc = new TestClass(n, 15, 1, 48346L);
        U16NameBaseTest.assertSame((Object)n, (Object)tc.getName());
        U16NameBaseTest.assertEquals((int)15, (int)tc.getType());
        U16NameBaseTest.assertEquals((int)1, (int)tc.getDClass());
        U16NameBaseTest.assertEquals((long)48346L, (long)tc.getTTL());
        U16NameBaseTest.assertEquals((int)0, (int)tc.getU16Field());
        U16NameBaseTest.assertNull((Object)tc.getNameField());
    }

    public void test_ctor_8arg() throws TextParseException {
        Name n = Name.fromString("My.Name.");
        Name m = Name.fromString("My.Other.Name.");
        TestClass tc = new TestClass(n, 15, 1, 45359L, 7979, "u16 description", m, "name description");
        U16NameBaseTest.assertSame((Object)n, (Object)tc.getName());
        U16NameBaseTest.assertEquals((int)15, (int)tc.getType());
        U16NameBaseTest.assertEquals((int)1, (int)tc.getDClass());
        U16NameBaseTest.assertEquals((long)45359L, (long)tc.getTTL());
        U16NameBaseTest.assertEquals((int)7979, (int)tc.getU16Field());
        U16NameBaseTest.assertEquals((Object)m, (Object)tc.getNameField());
        try {
            new TestClass(n, 15, 1, 45359L, 65536, "u16 description", m, "name description");
            U16NameBaseTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Name rel = Name.fromString("My.relative.Name");
        try {
            new TestClass(n, 15, 1, 45359L, 7979, "u16 description", rel, "name description");
            U16NameBaseTest.fail((String)"RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
    }

    public void test_rrFromWire() throws IOException {
        byte[] raw = new byte[]{-68, 31, 2, 77, 121, 6, 115, 105, 78, 103, 108, 69, 4, 110, 65, 109, 69, 0};
        DNSInput in = new DNSInput(raw);
        TestClass tc = new TestClass();
        tc.rrFromWire(in);
        Name exp = Name.fromString("My.single.name.");
        U16NameBaseTest.assertEquals((long)48159L, (long)tc.getU16Field());
        U16NameBaseTest.assertEquals((Object)exp, (Object)tc.getNameField());
    }

    public void test_rdataFromString() throws IOException {
        Name exp = Name.fromString("My.Single.Name.");
        Tokenizer t = new Tokenizer("6562 My.Single.Name.");
        TestClass tc = new TestClass();
        tc.rdataFromString(t, null);
        U16NameBaseTest.assertEquals((int)6562, (int)tc.getU16Field());
        U16NameBaseTest.assertEquals((Object)exp, (Object)tc.getNameField());
        t = new Tokenizer("10 My.Relative.Name");
        tc = new TestClass();
        try {
            tc.rdataFromString(t, null);
            U16NameBaseTest.fail((String)"RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
    }

    public void test_rrToString() throws IOException, TextParseException {
        Name n = Name.fromString("My.Name.");
        Name m = Name.fromString("My.Other.Name.");
        TestClass tc = new TestClass(n, 15, 1, 45359L, 7979, "u16 description", m, "name description");
        String out = tc.rrToString();
        String exp = "7979 My.Other.Name.";
        U16NameBaseTest.assertEquals((String)exp, (String)out);
    }

    public void test_rrToWire() throws IOException, TextParseException {
        Name n = Name.fromString("My.Name.");
        Name m = Name.fromString("M.O.n.");
        TestClass tc = new TestClass(n, 15, 1, 45359L, 7979, "u16 description", m, "name description");
        DNSOutput dout = new DNSOutput();
        tc.rrToWire(dout, null, true);
        byte[] out = dout.toByteArray();
        byte[] exp = new byte[]{31, 43, 1, 109, 1, 111, 1, 110, 0};
        U16NameBaseTest.assertTrue((boolean)Arrays.equals(exp, out));
        dout = new DNSOutput();
        tc.rrToWire(dout, null, false);
        out = dout.toByteArray();
        exp = new byte[]{31, 43, 1, 77, 1, 79, 1, 110, 0};
        U16NameBaseTest.assertTrue((boolean)Arrays.equals(exp, out));
    }

    private static class TestClass
    extends U16NameBase {
        public TestClass() {
        }

        public TestClass(Name name, int type, int dclass, long ttl) {
            super(name, type, dclass, ttl);
        }

        public TestClass(Name name, int type, int dclass, long ttl, int u16Field, String u16Description, Name nameField, String nameDescription) {
            super(name, type, dclass, ttl, u16Field, u16Description, nameField, nameDescription);
        }

        public int getU16Field() {
            return super.getU16Field();
        }

        public Name getNameField() {
            return super.getNameField();
        }

        public Record getObject() {
            return null;
        }
    }
}

