/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.runtime;

import com.ochafik.lang.jnaerator.runtime.Mangling;
import com.sun.jna.FunctionMapper;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.win32.StdCallFunctionMapper;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MangledFunctionMapper
implements FunctionMapper {
    public static final Map<Object, Object> DEFAULT_OPTIONS;
    public List<FunctionMapper> mappers;

    public MangledFunctionMapper(FunctionMapper ... mappers) {
        if (mappers != null) {
            this.mappers = Arrays.asList(mappers);
        }
    }

    public String getFunctionName(NativeLibrary library, Method method) {
        Mangling name = method.getAnnotation(Mangling.class);
        if (name != null) {
            for (String n : name.value()) {
                try {
                    if (library.getGlobalVariableAddress(n) != null) {
                        return n;
                    }
                    if (n.startsWith("_") && library.getGlobalVariableAddress(n = n.substring(1)) != null) {
                        return n;
                    }
                }
                catch (Throwable ex2) {
                    Object ex2 = null;
                }
            }
        }
        if (this.mappers != null) {
            for (FunctionMapper mapper : this.mappers) {
                String n = mapper.getFunctionName(library, method);
                if (n == null || library.getGlobalVariableAddress(n) == null) continue;
                return n;
            }
        }
        return method.getName();
    }

    static {
        FunctionMapper[] functionMapperArray;
        HashMap<String, MangledFunctionMapper> m = new HashMap<String, MangledFunctionMapper>();
        if (Platform.isWindows()) {
            FunctionMapper[] functionMapperArray2 = new FunctionMapper[1];
            functionMapperArray = functionMapperArray2;
            functionMapperArray2[0] = new StdCallFunctionMapper();
        } else {
            functionMapperArray = null;
        }
        FunctionMapper[] mappers = functionMapperArray;
        m.put("function-mapper", new MangledFunctionMapper(mappers));
        DEFAULT_OPTIONS = Collections.unmodifiableMap(m);
    }
}

