/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.jna;

import com.sun.cldc.jna.Function;
import com.sun.cldc.jna.TaskExecutor;
import com.sun.squawk.Address;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.VM;

public class BlockingFunction
extends Function {
    private TaskExecutor taskExecutor = null;

    BlockingFunction(String name, Address funcAddr) {
        super(name, funcAddr);
    }

    public String toString() {
        return "BlockingFunction(" + this.name + ", " + this.funcAddr.toUWord().toInt() + ")";
    }

    protected void preamble() {
        VM.print(this.toString());
        VM.println(".call...");
    }

    protected void postscript(int result) {
        VM.print("DONE: ");
        VM.print(this.name);
        VM.print(".blockingCall returned: ");
        VM.print(result);
        VM.println();
    }

    public void setTaskExecutor(TaskExecutor te) {
        if (this.taskExecutor != null) {
            throw new IllegalStateException("already has TaskExecutor");
        }
        this.taskExecutor = te;
    }

    public void setDefaultTaskExecutor() {
        this.taskExecutor = null;
    }

    private TaskExecutor getTE() {
        if (this.taskExecutor == null) {
            return TaskExecutor.getCachedTaskExecutor();
        }
        return this.taskExecutor;
    }

    public int call0() {
        TaskExecutor te = this.getTE();
        Address ntask = te.runBlockingFunction(this.funcAddr, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        int result = NativeUnsafe.waitForBlockingFunction(ntask);
        te.cleanup();
        return result;
    }

    public int call1(int i1) {
        TaskExecutor te = this.getTE();
        Address ntask = te.runBlockingFunction(this.funcAddr, i1, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        int result = NativeUnsafe.waitForBlockingFunction(ntask);
        te.cleanup();
        return result;
    }

    public int call2(int i1, int i2) {
        TaskExecutor te = this.getTE();
        Address ntask = te.runBlockingFunction(this.funcAddr, i1, i2, 0, 0, 0, 0, 0, 0, 0, 0);
        int result = NativeUnsafe.waitForBlockingFunction(ntask);
        te.cleanup();
        return result;
    }

    public int call3(int i1, int i2, int i3) {
        TaskExecutor te = this.getTE();
        Address ntask = te.runBlockingFunction(this.funcAddr, i1, i2, i3, 0, 0, 0, 0, 0, 0, 0);
        int result = NativeUnsafe.waitForBlockingFunction(ntask);
        te.cleanup();
        return result;
    }

    public int call4(int i1, int i2, int i3, int i4) {
        TaskExecutor te = this.getTE();
        Address ntask = te.runBlockingFunction(this.funcAddr, i1, i2, i3, i4, 0, 0, 0, 0, 0, 0);
        int result = NativeUnsafe.waitForBlockingFunction(ntask);
        te.cleanup();
        return result;
    }

    public int call5(int i1, int i2, int i3, int i4, int i5) {
        TaskExecutor te = this.getTE();
        Address ntask = te.runBlockingFunction(this.funcAddr, i1, i2, i3, i4, i5, 0, 0, 0, 0, 0);
        int result = NativeUnsafe.waitForBlockingFunction(ntask);
        te.cleanup();
        return result;
    }

    public int call6(int i1, int i2, int i3, int i4, int i5, int i6) {
        TaskExecutor te = this.getTE();
        Address ntask = te.runBlockingFunction(this.funcAddr, i1, i2, i3, i4, i5, i6, 0, 0, 0, 0);
        int result = NativeUnsafe.waitForBlockingFunction(ntask);
        te.cleanup();
        return result;
    }

    public int call7(int i1, int i2, int i3, int i4, int i5, int i6, int i7) {
        TaskExecutor te = this.getTE();
        Address ntask = te.runBlockingFunction(this.funcAddr, i1, i2, i3, i4, i5, i6, i7, 0, 0, 0);
        int result = NativeUnsafe.waitForBlockingFunction(ntask);
        te.cleanup();
        return result;
    }

    public int call8(int i1, int i2, int i3, int i4, int i5, int i6, int i7, int i8) {
        TaskExecutor te = this.getTE();
        Address ntask = te.runBlockingFunction(this.funcAddr, i1, i2, i3, i4, i5, i6, i7, i8, 0, 0);
        int result = NativeUnsafe.waitForBlockingFunction(ntask);
        te.cleanup();
        return result;
    }

    public int call9(int i1, int i2, int i3, int i4, int i5, int i6, int i7, int i8, int i9) {
        TaskExecutor te = this.getTE();
        Address ntask = te.runBlockingFunction(this.funcAddr, i1, i2, i3, i4, i5, i6, i7, i8, i9, 0);
        int result = NativeUnsafe.waitForBlockingFunction(ntask);
        te.cleanup();
        return result;
    }

    public int call10(int i1, int i2, int i3, int i4, int i5, int i6, int i7, int i8, int i9, int i10) {
        TaskExecutor te = this.getTE();
        Address ntask = te.runBlockingFunction(this.funcAddr, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10);
        int result = NativeUnsafe.waitForBlockingFunction(ntask);
        te.cleanup();
        return result;
    }
}

