/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.jna;

import com.sun.cldc.jna.Library;
import com.sun.cldc.jna.NativeLibrary;
import com.sun.cldc.jna.Platform;

public class Native {
    public static final boolean DEBUG = false;
    public static final int POINTER_SIZE = 4;
    public static final int LONG_SIZE = 4;
    public static final int WCHAR_SIZE = 2;
    public static final String DEFAULT = "RTLD";
    private static volatile NativeLibrary libraryLoading;
    private static final Object lock;

    private Native() {
    }

    public static NativeLibrary getLibraryLoading() {
        return libraryLoading;
    }

    private static Class getImplClass(Class interfaceClass) {
        Class implClass = null;
        String interfaceName = interfaceClass.getName();
        int pos = interfaceName.lastIndexOf(46);
        String packageName = interfaceName.substring(0, pos);
        String intfNameStem = interfaceName.substring(pos + 1);
        try {
            if (packageName.endsWith(".natives")) {
                packageName = packageName.substring(0, packageName.length() - ".natives".length());
            }
            String platformImplName = packageName + '.' + Platform.getPlatform().platformName() + ".natives." + intfNameStem + "Impl";
            implClass = Class.forName(platformImplName);
        }
        catch (ClassNotFoundException ex) {
            try {
                implClass = Class.forName(interfaceName + "Impl");
            }
            catch (ClassNotFoundException ex1) {
                ex1.printStackTrace();
            }
        }
        return implClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Library loadLibrary(String name, Class interfaceClass) {
        try {
            Object implementation = null;
            Object object = lock;
            synchronized (object) {
                try {
                    String customName = Platform.commonLibraryMapping(name);
                    if (customName != null) {
                        name = customName;
                    }
                    libraryLoading = name == null || name.length() == 0 || name.equals(DEFAULT) ? NativeLibrary.getDefaultInstance() : NativeLibrary.getInstance(name);
                    Class implClass = Native.getImplClass(interfaceClass);
                    implementation = implClass.newInstance();
                }
                finally {
                    libraryLoading = null;
                }
            }
            return (Library)implementation;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static boolean[] doInitCheck(boolean[] checkArray, int length, int index) {
        if (checkArray == null) {
            checkArray = new boolean[length];
        }
        if (checkArray[index]) {
            throw new RuntimeException("index already checked: " + index);
        }
        checkArray[index] = true;
        if (index == checkArray.length - 1) {
            for (int i = 0; i < checkArray.length; ++i) {
                if (checkArray[index]) continue;
                throw new RuntimeException("index never checked: " + index);
            }
        }
        return checkArray;
    }

    static {
        lock = new Object();
    }
}

