/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.jna;

import com.sun.cldc.jna.BlockingFunction;
import com.sun.cldc.jna.Function;
import com.sun.cldc.jna.Platform;
import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.VarPointer;
import com.sun.squawk.Address;
import com.sun.squawk.VM;

public class NativeLibrary {
    private static final boolean DEBUG = false;
    private static final NativeLibrary RTLD_DEFAULT = new NativeLibrary("RTLD_DEFAULT", Address.zero());
    private final String name;
    private final Address ptr;
    private boolean closed;

    private NativeLibrary(String name, Address ptr) {
        this.name = name;
        this.ptr = ptr;
    }

    private static String nativeLibraryName(String baseName) {
        Platform platform = Platform.getPlatform();
        if (platform.isSolaris() || platform.isLinux()) {
            return "lib" + baseName + ".so";
        }
        if (platform.isMac()) {
            return "lib" + baseName + ".dylib";
        }
        if (platform.isWindows()) {
            return baseName;
        }
        return baseName;
    }

    private Address getSymbolAddress(String name) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        Pointer name0 = Pointer.createStringBuffer(name);
        int result = VM.execSyncIO(1999, this.ptr.toUWord().toInt(), name0.address().toUWord().toInt(), 0, 0, 0, 0, null, null);
        name0.free();
        return Address.fromPrimitive(result);
    }

    public Function getFunction(String funcName) {
        Address result = this.getFunction0(funcName);
        return new Function(funcName, result);
    }

    public BlockingFunction getBlockingFunction(String funcName) {
        Address result = this.getFunction0(funcName);
        return new BlockingFunction(funcName, result);
    }

    private Address getFunction0(String funcName) {
        Address result = this.getSymbolAddress(funcName);
        if (result.isZero()) {
            if (Platform.getPlatform().isWindows()) {
                if (funcName.charAt(funcName.length() - 1) != 'A') {
                    return this.getFunction0(funcName + 'A');
                }
            } else if (funcName.charAt(0) != '_') {
                return this.getFunction0("_" + funcName);
            }
            throw new RuntimeException("Can't find native symbol " + funcName + ". OS Error: " + NativeLibrary.errorStr());
        }
        return result;
    }

    public VarPointer getGlobalVariableAddress(String varName, int size) {
        Address result = this.getSymbolAddress(varName);
        if (result.isZero()) {
            if (varName.charAt(0) != '_') {
                return this.getGlobalVariableAddress("_" + varName, size);
            }
            throw new RuntimeException("Can't find native symbol " + varName + ". OS Error: " + NativeLibrary.errorStr());
        }
        return new VarPointer(varName, result, size);
    }

    public static NativeLibrary getInstance(String name) {
        String nativeName = NativeLibrary.nativeLibraryName(name);
        Pointer name0 = Pointer.createStringBuffer(nativeName);
        int result = VM.execSyncIO(1996, name0.address().toUWord().toInt(), 0, 0, 0, 0, 0, null, null);
        Address r = Address.fromPrimitive(result);
        name0.free();
        if (r.isZero()) {
            throw new RuntimeException("Can't open library " + name + ". OS Error: " + NativeLibrary.errorStr());
        }
        return new NativeLibrary(name, r);
    }

    public static NativeLibrary getDefaultInstance() {
        return RTLD_DEFAULT;
    }

    public void dispose() {
        if (this.closed || this.ptr.isZero()) {
            throw new RuntimeException("closed or RTLD_DEFAULT");
        }
        Pointer name0 = Pointer.createStringBuffer(this.name);
        int result = VM.execSyncIO(1997, this.ptr.toUWord().toInt(), 0, 0, 0, 0, 0, 0, null, null);
        name0.free();
        if (result != 0) {
            throw new RuntimeException("Error on dlclose: " + NativeLibrary.errorStr());
        }
        this.closed = true;
    }

    public static String errorStr() {
        int result = VM.execSyncIO(1998, 0, 0, 0, 0, 0, 0, null, null);
        Address r = Address.fromPrimitive(result);
        if (r.isZero()) {
            return null;
        }
        return Pointer.NativeUnsafeGetString(r);
    }

    public String toString() {
        return "NativeLibrary(" + this.name + ", " + this.ptr.toUWord().toInt() + ")";
    }
}

