/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.jna;

import com.sun.cldc.jna.Pointer;
import com.sun.squawk.Address;
import com.sun.squawk.Klass;
import com.sun.squawk.VM;
import java.util.Hashtable;

public abstract class Platform {
    private static final boolean DEBUG = false;
    private static final Platform INSTANCE = Platform.makePlatform();
    protected static Hashtable commonMappings;
    private final String platformName;
    public static final String PLATFORM_PACKAGE = "com.sun.cldc.jna";

    public static Platform getPlatform() {
        return INSTANCE;
    }

    public abstract boolean deleteNativeLibraryAfterVMExit();

    public abstract boolean hasRuntimeExec();

    public abstract boolean isFreeBSD();

    public abstract boolean isLinux();

    public abstract boolean isMac();

    public abstract boolean isOpenBSD();

    public abstract boolean isSolaris();

    public abstract boolean isWindows();

    public abstract boolean isWindowsCE();

    public abstract boolean isX11();

    public abstract String getPlatformPackageName();

    public abstract String getPlatformNativePackageName();

    public static String commonLibraryMapping(String genericName) {
        return (String)commonMappings.get(genericName);
    }

    private static String getNativePlatformName() {
        int result = VM.execSyncIO(1029, 0, 0, 0, 0, 0, 0, null, null);
        Address r = Address.fromPrimitive(result);
        if (r.isZero()) {
            return null;
        }
        return Pointer.NativeUnsafeGetString(r);
    }

    public String platformName() {
        return this.platformName;
    }

    public Platform() {
        commonMappings = new Hashtable();
        this.platformName = Platform.getNativePlatformName().toLowerCase();
    }

    public String toString() {
        return "Platform(" + this.platformName + ")";
    }

    private static Object getInstance(String name) {
        String fullname = "com.sun.cldc.jna." + name;
        Klass klass = Klass.lookupKlass(fullname);
        if (klass != null) {
            return klass.newInstance();
        }
        return null;
    }

    private static Platform makePlatform() {
        Platform result = (Platform)Platform.getInstance(Platform.getNativePlatformName());
        if (result == null) {
            result = (Platform)Platform.getInstance("Posix");
        }
        if (result != null) {
            return result;
        }
        VM.println("Error in makePlatform. Exiting...");
        VM.haltVM(1);
        return null;
    }
}

