/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.jna;

import com.sun.cldc.jna.Pointer;
import com.sun.squawk.Address;
import com.sun.squawk.GC;
import com.sun.squawk.Klass;
import com.sun.squawk.util.Assert;

public class PrivatePointer {
    private PrivatePointer() {
    }

    private static Address getPtrToArray(byte[] array, int offset, int len) {
        int alen = array.length;
        if (offset < 0 || offset + len > alen) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return Address.fromObject(array).add(offset);
    }

    public static boolean setUpArrayBufferState() {
        return GC.setGCEnabled(false);
    }

    public static void tearDownArrayBufferState(boolean oldState) {
        GC.setGCEnabled(oldState);
    }

    public static Address createArrayBuffer(Object array) throws OutOfMemoryError {
        Assert.always(!GC.setGCEnabled(false), "PrivatePointer.java", 85);
        Klass klass = GC.getKlass(array);
        if (!klass.isArray()) {
            throw new IllegalArgumentException();
        }
        return Address.fromObject(array);
    }

    public static Address createArrayBuffer(Object array, int offset, int number) throws OutOfMemoryError {
        Assert.always(!GC.setGCEnabled(false), "PrivatePointer.java", 109);
        Klass klass = GC.getKlass(array);
        if (!klass.isArray()) {
            throw new IllegalArgumentException();
        }
        int length = GC.getArrayLength(array);
        int elemsize = klass.getComponentType().getDataSize();
        Pointer.checkMultiBounds1(length + elemsize, offset, number, elemsize);
        return Address.fromObject(array).add(offset * elemsize);
    }
}

