/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.jna;

import com.sun.cldc.jna.Pointer;
import com.sun.squawk.Klass;
import com.sun.squawk.VM;
import com.sun.squawk.util.Assert;

public abstract class Structure {
    private static final boolean DEBUG = false;
    protected Pointer backingNativeMemory;
    public static final Structure NULL = new NullStruct();

    protected Structure(Pointer backingNativeMemory) {
        this.backingNativeMemory = backingNativeMemory;
    }

    protected Structure() {
        this.backingNativeMemory = null;
    }

    public abstract void read();

    public abstract void write();

    public abstract int size();

    public final Pointer getPointer() {
        return this.backingNativeMemory;
    }

    public final void useMemory(Pointer m) {
        if (this.backingNativeMemory != null && this.backingNativeMemory.isValid()) {
            throw new IllegalStateException();
        }
        this.backingNativeMemory = m;
    }

    private void VMprintStruct() {
        VM.print("Structure(");
        VM.print(Klass.asKlass(this.getClass()).getInternalName());
        VM.print(" size: ");
        VM.print(this.size());
        if (this.backingNativeMemory == null) {
            VM.println(" memory never allocated)");
        } else {
            VM.print(" Pointer(");
            VM.printAddress(this.getPointer().address());
            VM.println("))");
        }
    }

    public void allocateMemory() throws OutOfMemoryError {
        if (this.backingNativeMemory != null && this.backingNativeMemory.isValid()) {
            throw new IllegalStateException();
        }
        this.backingNativeMemory = new Pointer(this.size());
    }

    public void allocateMemory(int size) throws OutOfMemoryError {
        int defaultsize = this.size();
        if (size < defaultsize) {
            throw new IllegalArgumentException();
        }
        if (this.backingNativeMemory != null && this.backingNativeMemory.isValid()) {
            throw new IllegalStateException();
        }
        this.backingNativeMemory = new Pointer(size);
    }

    public void freeMemory() throws IllegalStateException {
        this.backingNativeMemory.free();
        this.backingNativeMemory = null;
    }

    public void release() throws IllegalStateException {
        this.backingNativeMemory.release();
        this.backingNativeMemory = null;
    }

    public void clear() {
        this.backingNativeMemory.clear(this.size());
    }

    public String toString() {
        String backingStr = this.backingNativeMemory == null ? " memory never allocated" : this.backingNativeMemory.toString();
        return "Structure(" + this.getClass().getName() + " size: " + this.size() + backingStr + ")";
    }

    static class NullStruct
    extends Structure {
        NullStruct() {
            super(Pointer.NULL());
        }

        public void read() {
            Assert.shouldNotReachHere("Structure.java", 196);
        }

        public void write() {
            Assert.shouldNotReachHere("Structure.java", 200);
        }

        public int size() {
            return 0;
        }
    }
}

