/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Offset;
import com.sun.squawk.UWord;
import com.sun.squawk.pragma.HostedPragma;
import com.sun.squawk.pragma.NativePragma;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.IntHashtable;

public final class Address {
    private final int value;
    private static IntHashtable pool;

    public static Address fromPrimitive(int value) throws NativePragma {
        return Address.get(value);
    }

    public static Address fromObject(Object object) throws NativePragma {
        return (Address)object;
    }

    public static Address zero() throws NativePragma {
        return Address.get(0);
    }

    public static Address max() throws NativePragma {
        return Address.get(-1);
    }

    public Object toObject() throws NativePragma {
        return this;
    }

    public UWord toUWord() throws NativePragma {
        return UWord.fromPrimitive(this.value);
    }

    public Address add(int offset) throws NativePragma {
        return Address.get(this.value + offset);
    }

    public Address sub(int offset) throws NativePragma {
        return Address.get(this.value - offset);
    }

    public Address addOffset(Offset offset) throws NativePragma {
        return Address.get(this.value + offset.toPrimitive());
    }

    public Address subOffset(Offset offset) throws NativePragma {
        return Address.get(this.value - offset.toPrimitive());
    }

    public Address or(UWord word) throws NativePragma {
        return Address.get(this.value | word.toPrimitive());
    }

    public Address and(UWord word) throws NativePragma {
        return Address.get(this.value & word.toPrimitive());
    }

    public Offset diff(Address address2) throws NativePragma {
        return Offset.fromPrimitive(this.value - address2.value);
    }

    public boolean isZero() throws NativePragma {
        return this == Address.zero();
    }

    public boolean isMax() throws NativePragma {
        return this == Address.max();
    }

    public boolean eq(Address address2) throws NativePragma {
        return this == address2;
    }

    public boolean ne(Address address2) throws NativePragma {
        return this != address2;
    }

    public boolean lo(Address address2) throws NativePragma {
        if (this.value >= 0 && address2.value >= 0) {
            return this.value < address2.value;
        }
        if (this.value < 0 && address2.value < 0) {
            return this.value < address2.value;
        }
        return this.value >= 0;
    }

    public boolean loeq(Address address2) throws NativePragma {
        return this == address2 || this.lo(address2);
    }

    public boolean hi(Address address2) throws NativePragma {
        return address2.lo(this);
    }

    public boolean hieq(Address address2) throws NativePragma {
        return address2.loeq(this);
    }

    public Address roundUp(int alignment) throws NativePragma {
        return Address.get(this.value + (alignment - 1) & ~(alignment - 1));
    }

    public Address roundUpToWord() throws NativePragma {
        return Address.get(this.value + 3 & 0xFFFFFFFC);
    }

    public Address roundDown(int alignment) throws NativePragma {
        return Address.get(this.value & ~(alignment - 1));
    }

    public Address roundDownToWord() throws NativePragma {
        return Address.get(this.value & 0xFFFFFFFC);
    }

    public int hashCode() throws HostedPragma {
        return this.value;
    }

    public String toString() throws HostedPragma {
        return "" + this.value;
    }

    static Address get(int value) throws HostedPragma {
        Address addr;
        if (pool == null) {
            pool = new IntHashtable();
        }
        if ((addr = (Address)pool.get(value)) == null) {
            addr = new Address(value);
            try {
                pool.put(value, addr);
            }
            catch (OutOfMemoryError e) {
                throw new OutOfMemoryError("Failed to grow pool when adding " + value);
            }
        }
        return addr;
    }

    private Address(int value) throws HostedPragma {
        this.value = value;
    }

    static int assert32(long value) throws HostedPragma {
        Assert.always((long)((int)value) == value, "address is out of 32 bit range", "Address.java", 472);
        return (int)value;
    }

    int asIndex() throws HostedPragma {
        return Address.assert32(this.value);
    }
}

