/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.CallbackGroup;
import com.sun.squawk.HookWrapper;
import com.sun.squawk.Isolate;
import com.sun.squawk.VM;
import com.sun.squawk.util.SquawkVector;

public final class CallbackManager {
    private final boolean runOnce;
    private boolean ran;
    private final SquawkVector hooks;

    public CallbackManager(boolean runOnce) {
        this.runOnce = runOnce;
        this.hooks = new SquawkVector();
    }

    private CallbackGroup findGroup(Isolate iso) {
        int len = this.hooks.size();
        for (int i = 0; i < len; ++i) {
            CallbackGroup cbg = (CallbackGroup)this.hooks.elementAt(i);
            if (cbg.iso != iso) continue;
            return cbg;
        }
        return null;
    }

    public boolean isRunOnce() {
        return this.runOnce;
    }

    public synchronized void add(Isolate iso, Runnable hook) {
        if (hook == null) {
            throw new IllegalArgumentException();
        }
        CallbackGroup cbg = this.findGroup(iso);
        if (cbg == null) {
            cbg = new CallbackGroup(iso);
            this.hooks.addElement(cbg);
        }
        cbg.add(hook);
    }

    public void add(Runnable hook) {
        this.add(Isolate.currentIsolate(), hook);
    }

    public synchronized boolean remove(Isolate iso, Runnable hook) {
        if (hook == null) {
            throw new IllegalArgumentException();
        }
        CallbackGroup cbg = this.findGroup(iso);
        if (cbg != null && cbg.remove(hook)) {
            if (cbg.hooks.size() == 0) {
                this.hooks.removeElement(cbg);
            }
            return true;
        }
        return false;
    }

    synchronized HookWrapper findHookWrapper(Isolate iso, Object hook) {
        if (hook == null) {
            throw new IllegalArgumentException();
        }
        CallbackGroup cbg = this.findGroup(iso);
        if (cbg != null) {
            return cbg.findHookWrapper(hook);
        }
        return null;
    }

    public boolean remove(Runnable hook) {
        return this.remove(Isolate.currentIsolate(), hook);
    }

    public synchronized boolean remove(Isolate iso) {
        CallbackGroup cbg = this.findGroup(iso);
        if (cbg != null) {
            this.hooks.removeElement(cbg);
            return true;
        }
        return false;
    }

    public synchronized void removeAll() {
        this.hooks.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runHooks() {
        Object[] grps;
        CallbackManager callbackManager = this;
        synchronized (callbackManager) {
            if (this.runOnce & this.ran) {
                if (VM.isVeryVerbose()) {
                    System.err.println("Already ran one-time callbacks");
                }
                return;
            }
            this.ran = true;
            grps = new CallbackGroup[this.hooks.size()];
            this.hooks.copyInto(grps);
        }
        for (int i = 0; i < grps.length; ++i) {
            Object cbg = grps[i];
            if (((CallbackGroup)cbg).iso.isAlive()) {
                ((CallbackGroup)cbg).run();
            } else {
                System.err.println("Tried to execute callbacks in the context of an isolate that is no longer alive: " + ((CallbackGroup)cbg).iso);
                System.err.println("Skipping that set of callbacks");
            }
            if (!this.runOnce) continue;
            this.hooks.setElementAt(null, i);
        }
    }

    public synchronized boolean containsOtherIsolates() {
        if (this.hooks != null) {
            for (int i = 0; i < this.hooks.size(); ++i) {
                CallbackGroup cbg = (CallbackGroup)this.hooks.elementAt(i);
                if (cbg.iso == Isolate.currentIsolate()) continue;
                return true;
            }
        }
        return false;
    }
}

