/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.Debugger;
import com.sun.squawk.ExecutionPoint;
import com.sun.squawk.Field;
import com.sun.squawk.GC;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.MethodBody;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.Offset;
import com.sun.squawk.UWord;
import com.sun.squawk.VM;
import com.sun.squawk.VMThread;
import com.sun.squawk.debugger.DataType;
import com.sun.squawk.util.Assert;

public class DebuggerSupport {
    static final boolean DEBUG_STACK_INSPECTION = false;

    public static int getThreadJDWPState(VMThread vmThread) {
        int combinedState = vmThread.getInternalStatus();
        int inqueue = combinedState & 0xFF;
        if (vmThread.isAlive()) {
            switch (inqueue) {
                case 8: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
                case 2: 
                case 5: 
                case 6: {
                    return 4;
                }
                case 0: 
                case 3: 
                case 4: {
                    return 1;
                }
                case 7: {
                    return 0;
                }
            }
            throw Assert.shouldNotReachHere();
        }
        return 0;
    }

    public static String getJNISignature(Klass klass) {
        if (klass.isSquawkPrimitive()) {
            return Klass.INT.getSignature();
        }
        if (!klass.isArray()) {
            return klass.getSignature();
        }
        return "[" + DebuggerSupport.getJNISignature(klass.getComponentType());
    }

    public static String getJNISignature(Field field) {
        return DebuggerSupport.getJNISignature(field.getType());
    }

    public static String getJNISignature(Method method) {
        StringBuffer buf = new StringBuffer("(");
        Klass[] parameters = method.getParameterTypes();
        for (int i = 0; i != parameters.length; ++i) {
            buf.append(DebuggerSupport.getJNISignature(parameters[i]));
        }
        buf.append(')').append(DebuggerSupport.getJNISignature(method.getReturnType()));
        return buf.toString();
    }

    public static int getIDForROMObject(Object object) {
        int id;
        Address address = Address.fromObject(object);
        if (VM.inRom(address)) {
            Offset offset = VM.getOffsetInRom(address).bytesToWords();
            id = offset.toInt();
        } else if (GC.inNvm(address)) {
            int romSizeInWords = VM.getRomEnd().diff(VM.getRomStart()).bytesToWords().toInt();
            Offset offset = GC.getOffsetInNvm(address).bytesToWords();
            id = offset.toInt() + romSizeInWords;
        } else {
            id = 0;
        }
        return id;
    }

    public static Object getROMObjectForID(int id) {
        int romSizeInWords = VM.getRomEnd().diff(VM.getRomStart()).bytesToWords().toInt();
        if (id <= romSizeInWords) {
            Offset offset = Offset.fromPrimitive(id).wordsToBytes();
            return VM.getObjectInRom(offset);
        }
        Offset offset = Offset.fromPrimitive(id - romSizeInWords).wordsToBytes();
        return GC.getObjectInNvm(offset);
    }

    public static boolean isInitialized(Klass klass, Isolate isolate) {
        return klass.getState() == 4 && (!klass.mustClinit() || isolate.getClassState(klass) != null);
    }

    public static Object getStaticOop(Isolate isolate, Klass klass, int offset) {
        int wordOffset = offset + 2;
        Object ks = isolate.getClassState(klass);
        if (ks == null) {
            return null;
        }
        return NativeUnsafe.getObject(ks, wordOffset);
    }

    public static int getStaticInt(Isolate isolate, Klass klass, int offset) {
        int wordOffset = offset + 2;
        Object ks = isolate.getClassState(klass);
        if (ks == null) {
            return 0;
        }
        return NativeUnsafe.getUWord(ks, wordOffset).toPrimitive();
    }

    public static long getStaticLong(Isolate isolate, Klass klass, int offset) {
        int wordOffset = offset + 2;
        Object ks = isolate.getClassState(klass);
        if (ks == null) {
            return 0L;
        }
        return NativeUnsafe.getLongAtWord(ks, wordOffset);
    }

    public static void setStaticOop(Isolate isolate, Klass klass, int offset, Object value) {
        int wordOffset = offset + 2;
        Object ks = isolate.getClassState(klass);
        if (ks == null) {
            return;
        }
        NativeUnsafe.setObject(ks, wordOffset, value);
    }

    public static void setStaticInt(Isolate isolate, Klass klass, int offset, int value) {
        int wordOffset = offset + 2;
        Object ks = isolate.getClassState(klass);
        if (ks == null) {
            return;
        }
        NativeUnsafe.setUWord(ks, wordOffset, UWord.fromPrimitive(value));
    }

    public static void setStaticLong(Isolate isolate, Klass klass, int offset, long value) {
        int wordOffset = offset + 2;
        Object ks = isolate.getClassState(klass);
        if (ks == null) {
            return;
        }
        NativeUnsafe.setLongAtWord(ks, wordOffset, value);
    }

    public static Klass getDefiningClass(Object methodBody) {
        return VM.asKlass(NativeUnsafe.getObject(methodBody, -3));
    }

    public static Object getMethodBody(Klass klass, int offset, boolean isStatic) {
        Object[] table = isStatic ? klass.getStaticMethods() : klass.getVirtualMethods();
        Object method = table[offset];
        return method;
    }

    public static int getMethodBodyLength(Object methodBody) {
        if (VM.isHosted()) {
            return ((MethodBody)methodBody).getCode().length;
        }
        return GC.getArrayLength(methodBody);
    }

    private static boolean isValidMethodBody(Object methodBody) {
        return methodBody != null && (VM.isHosted() && methodBody instanceof MethodBody || GC.getKlass(methodBody) == Klass.BYTECODE_ARRAY);
    }

    public static DataType.MethodID getIDForMethodBody(Klass definingClass, Object methodBody) {
        int i;
        Object[] methods = definingClass.getVirtualMethods();
        for (i = 0; i != methods.length; ++i) {
            if (methods[i] != methodBody) continue;
            return new DataType.MethodID(i, false);
        }
        methods = definingClass.getStaticMethods();
        for (i = 0; i != methods.length; ++i) {
            if (methods[i] != methodBody) continue;
            return new DataType.MethodID(i, true);
        }
        throw Assert.shouldNotReachHere();
    }

    public static boolean isAtExceptionBreakpoint(VMThread vmThread) {
        return vmThread.getHitBreakpoint() != null && vmThread.getHitBreakpoint().getException() != null;
    }

    public static ExecutionPoint getThreadCurrentExecutionPoint(VMThread thread) {
        if (!thread.isAlive()) {
            return null;
        }
        Object stack = thread.getStack();
        Address fp = NativeUnsafe.getAddress(stack, 2);
        if (fp.isZero()) {
            return null;
        }
        Object mp = VM.getMP(fp);
        Offset frame = thread.framePointerAsOffset(fp);
        Offset bci = NativeUnsafe.getUWord(stack, 3).toOffset();
        return new ExecutionPoint(frame, bci, mp);
    }

    public static int inspectStack(StackInspector inspector, ExecutionPoint from, int frameNo) {
        VMThread thread = inspector.vmThread;
        if (!thread.isAlive()) {
            return 0;
        }
        Object stack = thread.getStack();
        boolean isInnerMostActivation = false;
        if (from == null) {
            from = DebuggerSupport.getThreadCurrentExecutionPoint(thread);
            if (from == null) {
                return 0;
            }
            isInnerMostActivation = true;
        }
        Object mp = from.mp;
        Offset bci = from.bci;
        Offset frame = from.frame;
        int thisFrame = 0;
        int inspectedFrames = 0;
        while (true) {
            if (frameNo == -1 || frameNo == thisFrame) {
                inspector.inspectFrame(mp, bci, thisFrame, frame);
                if (inspector.doSlots) {
                    int localCount = isInnerMostActivation ? 1 : MethodBody.decodeLocalCount(mp);
                    int parameterCount = MethodBody.decodeParameterCount(mp);
                    Klass[] typeMap = inspector.getTypeMap(thisFrame, mp, parameterCount);
                    int slot = 0;
                    slot = DebuggerSupport.inspectSlots(parameterCount, 3, slot, typeMap, thread, frame, inspector, true);
                    slot = DebuggerSupport.inspectSlots(localCount, 0, slot, typeMap, thread, frame, inspector, false);
                }
                ++inspectedFrames;
            }
            isInnerMostActivation = false;
            ++thisFrame;
            Address fp = thread.frameOffsetAsPointer(frame);
            Address ip = VM.getPreviousIP(fp);
            if ((fp = VM.getPreviousFP(fp)).isZero()) break;
            mp = VM.getMP(fp);
            bci = ip.diff(Address.fromObject(mp));
            frame = thread.framePointerAsOffset(fp);
        }
        inspector.postInspection();
        return inspectedFrames;
    }

    private static int inspectSlots(int count, int offset, int slot, Klass[] typeMap, VMThread vmThread, Offset fo, StackInspector inspector, boolean isParameter) {
        Object stack = vmThread.getStack();
        SlotSetter setter = null;
        if (inspector instanceof SlotSetter) {
            setter = (SlotSetter)inspector;
        }
        while (count-- > 0) {
            Klass type = typeMap[slot];
            int varOffset = vmThread.frameOffsetAsPointer(fo).diff(Address.fromObject(stack)).bytesToWords().toInt() + (isParameter ? offset : -offset);
            if (type.isReferenceType()) {
                Object value = NativeUnsafe.getObject(stack, varOffset);
                inspector.inspectSlot(isParameter, slot, value);
                if (setter != null && setter.shouldSetSlot(slot, type)) {
                    Object newVal = setter.newObjValue();
                    NativeUnsafe.setObject(stack, varOffset, newVal);
                }
            } else {
                long value;
                boolean skipSlot = false;
                boolean isTwoWordLongLocal = false;
                if (type.isDoubleWord()) {
                    value = NativeUnsafe.getLongAtWord(stack, isParameter ? varOffset : varOffset - 1);
                    skipSlot = true;
                    isTwoWordLongLocal = !isParameter;
                } else {
                    value = NativeUnsafe.getAsUWord(stack, varOffset).toPrimitive();
                }
                inspector.inspectSlot(isParameter, isTwoWordLongLocal ? slot + 1 : slot, type, value);
                if (setter != null && setter.shouldSetSlot(isTwoWordLongLocal ? slot + 1 : slot, type)) {
                    long newVal = setter.newPrimValue();
                    if (skipSlot) {
                        NativeUnsafe.setLongAtWord(stack, isParameter ? varOffset : varOffset - 1, newVal);
                    } else {
                        NativeUnsafe.setUWord(stack, varOffset, UWord.fromPrimitive((int)newVal));
                    }
                }
                if (skipSlot) {
                    --count;
                    ++slot;
                    ++offset;
                }
            }
            ++offset;
            ++slot;
        }
        return slot;
    }

    public static void setDebugger(Isolate isolate, Debugger debugger, boolean attach) {
        if (attach) {
            if (isolate.getDebugger() != null) {
                throw new RuntimeException("Isolate is already being debugged: " + isolate);
            }
            isolate.setDebugger(debugger);
        } else {
            if (isolate.getDebugger() != debugger) {
                throw new RuntimeException("Isolate is not being debugged by this debugger: " + isolate);
            }
            isolate.setDebugger(null);
        }
    }

    public static int countStackFrames(VMThread vmThread, ExecutionPoint from) {
        return DebuggerSupport.inspectStack(new StackInspector(vmThread, false), from, -1);
    }

    private DebuggerSupport() {
    }

    public static abstract class SlotSetter
    extends StackInspector {
        protected SlotSetter(VMThread thread) {
            super(thread, true);
        }

        public abstract boolean shouldSetSlot(int var1, Klass var2);

        public abstract long newPrimValue();

        public abstract Object newObjValue();
    }

    public static class StackInspector {
        protected final boolean doSlots;
        protected final VMThread vmThread;

        protected StackInspector(VMThread thread, boolean doSlots) {
            this.vmThread = thread;
            this.doSlots = doSlots;
        }

        public void inspectFrame(Object mp, Offset bci, int frame, Offset fo) {
        }

        public void inspectSlot(boolean isParameter, int slot, Object value) {
        }

        public void inspectSlot(boolean isParameter, int slot, Klass type, long value) {
        }

        public void postInspection() {
        }

        public Object getResult() {
            return null;
        }

        public Klass[] getTypeMap(int frameNo, Object mp, int parameterCount) {
            return MethodBody.decodeTypeMap(mp);
        }
    }
}

