/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.GC;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.ObjectMemoryLoader;
import com.sun.squawk.Suite;
import com.sun.squawk.VM;
import com.sun.squawk.util.StringTokenizer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import javax.microedition.io.Connector;

public class JavaApplicationManager {
    private static String classPath;
    private static String parentSuiteURI;
    private static boolean displayExecutionStatistics;
    private static final boolean testoms = false;
    private static int midletPropertyNum;
    private static String testMIDletClass;

    private JavaApplicationManager() {
    }

    public static void main(String[] args) throws Exception {
        int exitCode;
        long startTime;
        block11: {
            midletPropertyNum = 1;
            String mainClassName = null;
            String[] javaArgs = null;
            if (args.length != 0) {
                args = JavaApplicationManager.processVMOptions(args);
            }
            if (testMIDletClass != null) {
                mainClassName = "com.sun.squawk.imp.MIDletMainWrapper";
                javaArgs = new String[]{"-name", testMIDletClass};
            } else if (args.length > 0) {
                mainClassName = args[0].replace('/', '.');
                javaArgs = new String[args.length - 1];
                for (int i = 0; i < javaArgs.length; ++i) {
                    javaArgs[i] = args[i + 1];
                }
            }
            startTime = System.currentTimeMillis();
            exitCode = 999;
            try {
                Isolate isolate = mainClassName != null ? new Isolate(null, mainClassName, javaArgs, classPath, parentSuiteURI) : new Isolate(null, midletPropertyNum, classPath, parentSuiteURI);
                isolate.start();
                isolate.join();
                if (isolate.isHibernated()) {
                    // empty if block
                }
                exitCode = isolate.getExitCode();
            }
            catch (Error e) {
                System.err.println(e);
                if (!VM.isVerbose()) break block11;
                e.printStackTrace();
            }
        }
        if (displayExecutionStatistics) {
            long endTime = System.currentTimeMillis();
            System.out.println();
            System.out.println("=============================");
            System.out.println("Squawk VM exiting with code " + exitCode);
            if (GC.getPartialCount() > 0) {
                System.out.println("" + GC.getPartialCount() + " partial collections");
            }
            if (GC.getFullCount() > 0) {
                System.out.println("" + GC.getFullCount() + " full collections");
            }
            GC.getCollector().dumpTimings(System.out);
            System.out.println("Execution time was " + (endTime - startTime) + " ms");
            System.out.println("=============================");
            System.out.println();
        }
        VM.stopVM(exitCode);
    }

    private static String[] processVMOptions(String[] args) {
        String arg;
        int offset;
        for (offset = 0; offset != args.length && (arg = args[offset]).charAt(0) == '-'; ++offset) {
            JavaApplicationManager.processVMOption(arg);
        }
        String[] javaArgs = new String[args.length - offset];
        for (int i = 0; i < javaArgs.length; ++i) {
            javaArgs[i] = args[offset++];
        }
        return javaArgs;
    }

    private static void showVersion(PrintStream out) {
        out.println("32 bit squawk:");
        out.println("    debug code disabled");
        out.println("    assertions disabled");
        out.println("    tracing disabled");
        boolean floatSupported = "${build.properties:FLOATS}".equals("true");
        if (floatSupported) {
            out.println("    floating point supported");
        } else {
            out.println("    no floating point support");
        }
        out.println("    bootstrap suite: ");
        StringTokenizer st = new StringTokenizer(VM.getCurrentIsolate().getBootstrapSuite().getConfiguration(), ",");
        while (st.hasMoreTokens()) {
            out.println("        " + st.nextToken().trim());
        }
        VM.printConfiguration();
    }

    private static void showImageContents(PrintStream out, boolean packagesOnly) {
        Suite bootstrapSuite = VM.getCurrentIsolate().getBootstrapSuite();
        if (packagesOnly) {
            out.println("Packages in image:");
            Hashtable packages = new Hashtable();
            int count = bootstrapSuite.getClassCount();
            for (int i = 0; i != count; ++i) {
                String packageName;
                String className;
                int index;
                Klass klass = bootstrapSuite.getKlass(i);
                if (klass == null || klass.isSynthetic() || (index = (className = klass.getInternalName()).lastIndexOf(46)) == -1 || packages.get(packageName = className.substring(0, className.lastIndexOf(46))) != null) continue;
                out.println("  " + packageName);
                packages.put(packageName, packageName);
            }
        } else {
            out.println("Classes in image:");
            int count = bootstrapSuite.getClassCount();
            for (int i = 0; i != count; ++i) {
                Klass klass = bootstrapSuite.getKlass(i);
                if (klass == null || klass.isSynthetic()) continue;
                out.println("  " + klass.getName());
            }
        }
    }

    private static void processVMOption(String arg) {
        if (arg.startsWith("-suite:")) {
            parentSuiteURI = "file://" + arg.substring(7) + ".suite";
        } else if (arg.equals("-egc")) {
            GC.setExcessiveGC(true);
        } else if (arg.equals("-nogc")) {
            VM.allowUserGC(false);
        } else if (arg.startsWith("-isolateinit:")) {
            String initializer = arg.substring(13);
            VM.setIsolateInitializerClassName(initializer);
        } else if (arg.startsWith("-MIDlet-")) {
            try {
                midletPropertyNum = Integer.parseInt(arg.substring("-MIDlet-".length()));
            }
            catch (NumberFormatException ex) {
                JavaApplicationManager.usage("Bad value for -MIDlet- " + arg);
                VM.stopVM(0);
            }
        } else if (arg.startsWith("-testMIDlet:")) {
            testMIDletClass = arg.substring(12);
        } else if (arg.equals("-version")) {
            JavaApplicationManager.showVersion(System.err);
            VM.stopVM(0);
        } else if (arg.equals("-verbose")) {
            if (!VM.isVerbose()) {
                VM.setVerboseLevel(1);
            }
        } else if (arg.equals("-veryverbose")) {
            if (!VM.isVeryVerbose()) {
                VM.setVerboseLevel(2);
            }
        } else if (arg.equals("-stats")) {
            displayExecutionStatistics = true;
        } else if (arg.startsWith("-sampleStatData:")) {
            String url = arg.substring("-sampleStatData:".length());
            try {
                System.out.println("Sending samples of statictics to " + url);
                final DataOutputStream dos = Connector.openDataOutputStream(url);
                new Thread(new Runnable(){

                    public void run() {
                        VM.Stats stats = new VM.Stats();
                        while (true) {
                            stats.sendStatData(dos);
                            try {
                                Thread.sleep(500L);
                                continue;
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                                continue;
                            }
                            break;
                        }
                    }
                }).start();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.err.println("Ignoring -sampleStatData option");
            }
        } else if (arg.startsWith("-D")) {
            String propAndValue = arg.substring("-D".length());
            int seperator = propAndValue.indexOf(61);
            String prop = propAndValue.substring(0, seperator);
            String val = propAndValue.substring(seperator + 1);
            VM.getCommandLineProperties().put(prop, val);
        } else if (arg.startsWith("-suitepath:")) {
            String path = arg.substring("-suitepath:".length());
            ObjectMemoryLoader.setFilePath(path);
        } else if (arg.equals("-h")) {
            JavaApplicationManager.usage("");
            VM.stopVM(0);
        } else if (!GC.getCollector().processCommandLineOption(arg)) {
            JavaApplicationManager.usage("Unrecognised option: " + arg);
            VM.stopVM(0);
        }
    }

    private static void usage(String msg) {
        PrintStream out = System.out;
        out.println();
        if (msg.length() > 0) {
            out.println("** " + msg + " **\n");
        }
        out.print("Usage: squawk [-options] class [args...] | [-MIDlet-x]\n\nif there is no class specified, then try MIDlet-1 property to find a MIDlet\nwhere options include:\n    -suite:<name>         suite name (without \".suite\") to load\n    -suitepath:<path>     host path to look for suites in\n    -isolateinit:<class>  class whose main will be invoked on Isolate start, single arg \"true\" if first Isolate being initialized\n    -MIDlet-x             which MIDlet-x property to use from META-INF/MANIFEST.MF\n    -testMIDlet:<class>   specify MIDlet class name directly\n    -sampleStatData:url   poll VM.Stats every 500ms and send samples to url\n    -version              print product version and exit\n    -verbose              report when a class is loaded\n    -veryverbose          report when a class is initialized or looked up and\n                          various other output\n");
        GC.getCollector().usage(out);
        out.print("    -egc                  enable excessive garbage collection\n    -nogc                 disable application calls to Runtime.gc()\n    -stats                display execution statistics before exiting\n    -D<name>=<value>      set a system property\n    -h                    display this help message\n    -X                    display help on native VM options\n");
        VM.stopVM(0);
    }
}

