/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.GC;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.ObjectMemory;
import com.sun.squawk.UWord;
import com.sun.squawk.vm.OPC;

public final class ObjectMemoryEndianessSwapper {
    private final ObjectMemory om;
    private Address object;
    private final boolean toPlatform;
    private final boolean isCanonical;

    public static void swap(ObjectMemory om, boolean toPlatform, boolean isCanonical) {
        new ObjectMemoryEndianessSwapper(om, toPlatform, isCanonical).run();
    }

    private ObjectMemoryEndianessSwapper(ObjectMemory om, boolean toPlatform, boolean isCanonical) {
        this.om = om;
        this.toPlatform = toPlatform;
        this.isCanonical = isCanonical;
    }

    private boolean requiresSwapping(Address ea) {
        if (this.toPlatform) {
            return ea.hieq(this.object);
        }
        return ea.lo(this.object);
    }

    private int getInt(Address base, int offset) {
        int result;
        Address ea = base.add(offset * 4);
        if (this.om.containsAddress(ea)) {
            if (this.requiresSwapping(ea)) {
                NativeUnsafe.swap4(ea);
                result = NativeUnsafe.getInt(base, offset);
                NativeUnsafe.swap4(ea);
            } else {
                result = NativeUnsafe.getInt(base, offset);
            }
        } else {
            result = NativeUnsafe.getInt(base, offset);
        }
        return result;
    }

    private int getShort(Address base, int offset) {
        int result;
        Address ea = base.add(offset * 2);
        if (this.om.containsAddress(ea)) {
            if (this.requiresSwapping(ea)) {
                NativeUnsafe.swap2(ea);
                result = NativeUnsafe.getShort(base, offset);
                NativeUnsafe.swap2(ea);
            } else {
                result = NativeUnsafe.getShort(base, offset);
            }
        } else {
            result = NativeUnsafe.getShort(base, offset);
        }
        return result;
    }

    private UWord getUWord(Address base, int offset) {
        UWord result;
        Address ea = base.add(offset * 4);
        if (this.om.containsAddress(ea)) {
            if (this.requiresSwapping(ea)) {
                NativeUnsafe.swap(ea, 4);
                result = NativeUnsafe.getUWord(base, offset);
                NativeUnsafe.swap(ea, 4);
            } else {
                result = NativeUnsafe.getUWord(base, offset);
            }
        } else {
            result = NativeUnsafe.getUWord(base, offset);
        }
        return result;
    }

    private Address getAddress(Address base, int offset) {
        Address result;
        Address ea = base.add(offset * 4);
        if (this.om.containsAddress(ea)) {
            if (this.requiresSwapping(ea)) {
                NativeUnsafe.swap(ea, 4);
                result = NativeUnsafe.getAddress(base, offset);
                NativeUnsafe.swap(ea, 4);
            } else {
                result = NativeUnsafe.getAddress(base, offset);
            }
            if (this.isCanonical) {
                ObjectMemory om = this.om.findCanonicalAddress(result);
                result = om.fromCanonical(result);
            }
        } else {
            result = NativeUnsafe.getAddress(base, offset);
        }
        return result;
    }

    private static void swapWord(Address base, int offset) {
        Address ea = base.add(offset * 4);
        NativeUnsafe.swap(ea, 4);
    }

    private void run() {
        Address end = this.om.getEnd();
        Address block = this.om.getStart();
        while (block.lo(end)) {
            UWord dataMapWord;
            int dataMapLength;
            if (this.toPlatform) {
                ObjectMemoryEndianessSwapper.swapWord(block, 0);
            }
            this.object = GC.blockToOop(block);
            int headerSize = this.object.diff(block).toInt();
            if (!this.toPlatform) {
                ObjectMemoryEndianessSwapper.swapWord(block, 0);
            }
            if (headerSize != 4) {
                ObjectMemoryEndianessSwapper.swapWord(this.object, -1);
                if (headerSize != 8) {
                    ObjectMemoryEndianessSwapper.swapWord(this.object, -2);
                    ObjectMemoryEndianessSwapper.swapWord(this.object, -3);
                }
            }
            Address classOrAssociation = this.getAddress(this.object, -1);
            Address klass = this.getAddress(classOrAssociation, 0);
            if (headerSize != 4) {
                int dataSize;
                int length = GC.decodeLengthWord(this.getUWord(this.object, -2));
                if (headerSize != 8) {
                    this.swapInlineConstants(length);
                    dataSize = 1;
                } else {
                    int encodedDataSize = this.getUWord(klass, 12).toInt();
                    dataSize = 1 << (encodedDataSize & 3);
                    if (dataSize > 1) {
                        for (int i = 0; i < length; ++i) {
                            NativeUnsafe.swap(this.object.add(i * dataSize), dataSize);
                        }
                    }
                }
                block = this.object.add(length * dataSize).roundUpToWord();
                continue;
            }
            int byteOffset = 0;
            if (dataMapLength > 16) {
                Address dataMap = this.getAddress(klass, 11);
                int i = 0;
                for (dataMapLength = this.getShort(klass, 28); dataMapLength > 0; dataMapLength -= 16) {
                    dataMapWord = this.getUWord(dataMap, i++);
                    byteOffset = ObjectMemoryEndianessSwapper.swapFields(this.object, byteOffset, dataMapWord, Math.min(dataMapLength, 16));
                }
            } else {
                dataMapWord = this.getUWord(klass, 12);
                byteOffset = ObjectMemoryEndianessSwapper.swapFields(this.object, 0, dataMapWord, Math.min(dataMapLength, 16));
            }
            block = this.object.add(byteOffset).roundUpToWord();
        }
    }

    private void swapInlineConstants(int length) {
        int ip = 0;
        block10: while (ip < length) {
            int opcode = 0xFF & NativeUnsafe.getAsByte(this.object, ip);
            if (opcode == 77) {
                opcode = (0xFF & NativeUnsafe.getAsByte(this.object, ++ip)) + 256;
            }
            switch (opcode) {
                case 87: 
                case 88: {
                    NativeUnsafe.swap2(this.object.add(ip + 1));
                    ip += OPC.getSize(opcode);
                    continue block10;
                }
                case 89: 
                case 382: {
                    NativeUnsafe.swap4(this.object.add(ip + 1));
                    ip += OPC.getSize(opcode);
                    continue block10;
                }
                case 90: 
                case 383: {
                    NativeUnsafe.swap8(this.object.add(ip + 1));
                    ip += OPC.getSize(opcode);
                    continue block10;
                }
                case 72: 
                case 73: 
                case 74: 
                case 78: 
                case 79: 
                case 80: {
                    ip += 3;
                    continue block10;
                }
                case 75: 
                case 81: {
                    NativeUnsafe.swap2(this.object.add(ip + 2));
                    ip += 4;
                    continue block10;
                }
                case 76: 
                case 82: {
                    NativeUnsafe.swap4(this.object.add(ip + 2));
                    ip += 6;
                    continue block10;
                }
                case 194: {
                    ip = this.swapSwitchTable(ip, 2);
                    continue block10;
                }
                case 193: {
                    ip = this.swapSwitchTable(ip, 4);
                    continue block10;
                }
            }
            ip += OPC.getSize(opcode);
        }
    }

    private int swapSwitchTable(int ip, int dataSize) {
        int high;
        int low;
        int padding = (dataSize - (ip + 1) % dataSize) % dataSize;
        Address lowAddress = this.object.add(ip + 1 + padding);
        Address highAddress = lowAddress.add(dataSize);
        Address defAddress = highAddress.add(dataSize);
        Address tableEntriesAddress = defAddress.add(dataSize);
        if (this.toPlatform) {
            NativeUnsafe.swap(lowAddress, dataSize);
            NativeUnsafe.swap(highAddress, dataSize);
            NativeUnsafe.swap(defAddress, dataSize);
        }
        if (dataSize == 2) {
            low = NativeUnsafe.getAsShort(lowAddress, 0);
            high = NativeUnsafe.getAsShort(highAddress, 0);
        } else {
            low = NativeUnsafe.getAsInt(lowAddress, 0);
            high = NativeUnsafe.getAsInt(highAddress, 0);
        }
        if (!this.toPlatform) {
            NativeUnsafe.swap(lowAddress, dataSize);
            NativeUnsafe.swap(highAddress, dataSize);
            NativeUnsafe.swap(defAddress, dataSize);
        }
        int entries = high - low + 1;
        for (int j = 0; j < entries; ++j) {
            NativeUnsafe.swap(tableEntriesAddress.add(j * dataSize), dataSize);
        }
        return ip += entries * dataSize + (padding + 3 * dataSize + 1);
    }

    private static int swapFields(Address object, int byteOffset, UWord dataMapWord, int entries) {
        for (int i = 0; i != entries; ++i) {
            int log2DataSize = dataMapWord.toPrimitive() >> i % 16 * 2 & 3;
            int dataSize = 1 << log2DataSize;
            NativeUnsafe.swap(object.add(byteOffset), dataSize);
            byteOffset += dataSize;
        }
        return byteOffset;
    }
}

