/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.flash;

import com.sun.squawk.Address;
import com.sun.squawk.flash.IMemoryHeapBlock;
import com.sun.squawk.util.ByteArrayInputStreamWithSetBytes;
import java.io.DataInputStream;

public class MemoryHeapBlock
implements IMemoryHeapBlock {
    protected Address address;
    protected boolean isAllocated;
    protected int nextBlockOffset;
    protected byte[] bytes;
    protected int offset;
    protected int length;
    protected ByteArrayInputStreamWithSetBytes bytesIn;
    protected DataInputStream dataIn;

    public ByteArrayInputStreamWithSetBytes getByteArrayInputStream() {
        if (this.dataIn == null) {
            this.getDataInputStream();
        }
        return this.bytesIn;
    }

    public Address getAddress() {
        return this.address;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public DataInputStream getDataInputStream() {
        if (this.dataIn == null) {
            this.bytesIn = new ByteArrayInputStreamWithSetBytes(this.bytes, this.offset, this.length);
            this.dataIn = new DataInputStream(this.bytesIn);
        }
        return this.dataIn;
    }

    public int getLength() {
        return this.length;
    }

    public int getNextBlockOffset() {
        return this.nextBlockOffset;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isAllocated() {
        return this.isAllocated;
    }

    public void resetBytes() {
        this.bytes = null;
        this.length = 0;
        this.offset = 0;
        this.bytesIn = null;
        this.dataIn = null;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setBytes(byte[] bytes, int offset, int length) {
        if ((bytes.length & 1) == 1) {
            throw new IllegalArgumentException("bytes passed in must be even in length");
        }
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        if (this.bytesIn != null) {
            this.bytesIn.setBytes(bytes, offset, length);
        }
    }

    public void setLength(int length) {
        this.offset = 0;
        this.length = length;
        if (this.bytes == null || this.bytes.length < length + (length & 1)) {
            this.bytes = new byte[length + (length & 1)];
        }
        if (this.bytesIn != null) {
            this.bytesIn.setBytes(this.bytes, this.offset, length);
        }
    }

    public void setIsAllocated(boolean isAllocated) {
        this.isAllocated = isAllocated;
    }

    public void setNextOffset(int offset) {
        this.nextBlockOffset = offset;
    }
}

