/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.flash;

import com.sun.squawk.Address;
import com.sun.squawk.flash.INorFlashSectorState;
import com.sun.squawk.flash.INorFlashSectorStateList;
import com.sun.squawk.peripheral.INorFlashSector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStoreException;

public class NorFlashSectorState
implements INorFlashSectorState {
    public static final byte[] ERASED_HEADER = new byte[]{83, 81, 85, 65, 87, 75};
    public static final int ERASED_HEADER_SIZE = 2 + ERASED_HEADER.length + 8 + 2;
    public static final byte[] BUFFER = new byte[ERASED_HEADER_SIZE];
    protected Address startAddress;
    protected Address endAddress;
    protected int writeHead;
    protected INorFlashSector flashSector;
    protected long sequence;
    protected INorFlashSectorState nextSector;
    protected INorFlashSectorStateList owningList;
    protected int mallocedBlockCount;
    protected int freedBlockCount;
    protected boolean hasErasedHeader;

    protected NorFlashSectorState() {
    }

    public NorFlashSectorState(INorFlashSector flashSector) {
        this.flashSector = flashSector;
        this.init(flashSector.getStartAddress(), flashSector.getSize());
    }

    protected void checkReadWriteParameters(int offset, byte[] buffer, int bufferStart, int bufferLength) {
        String message;
        if (bufferLength == 0) {
            return;
        }
        if (offset < 0 || bufferStart < 0 || bufferLength < 0) {
            message = "one of offset(" + offset + "), bufferStart(" + bufferStart + "), bufferLength(" + bufferLength + ") is < 0";
        } else if (offset >= this.flashSector.getSize()) {
            message = "offset(" + offset + ") >= size(" + this.flashSector.getSize() + ")";
        } else if (offset + bufferLength > this.getSize()) {
            message = "offset(" + offset + ") + bufferLength(" + bufferLength + ") > size(" + this.getSize() + ")";
        } else if (bufferStart >= buffer.length) {
            message = "bufferStart(" + bufferStart + ") >= buffer.length(" + buffer.length + ")";
        } else if (bufferStart + bufferLength > buffer.length) {
            message = "bufferStart(" + bufferStart + ") + bufferLength(" + bufferLength + ") > buffer.length(" + buffer.length + ")";
        } else {
            return;
        }
        throw new IndexOutOfBoundsException(message);
    }

    public void decrementMallocedCount() {
        --this.mallocedBlockCount;
    }

    public void erase(long sequence) throws RecordStoreException {
        this.flashSector.erase();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(ERASED_HEADER_SIZE);
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.writeHead = 0;
        try {
            dataOut.write(0);
            dataOut.write(0);
            dataOut.write(ERASED_HEADER);
            dataOut.writeLong(sequence);
            dataOut.write(0);
            dataOut.write(0);
        }
        catch (IOException e) {
            throw new RecordStoreException("Unexpected IO exception: " + e);
        }
        this.writeBytes(bytesOut.toByteArray(), 0, bytesOut.size());
        this.hasErasedHeader = true;
        this.freedBlockCount = 0;
        this.mallocedBlockCount = 0;
    }

    public void forceErase() throws RecordStoreException {
        this.flashSector.setBytes(2, new byte[]{0, 0}, 0, 2);
    }

    public INorFlashSectorState getNextSector() {
        return this.nextSector;
    }

    public INorFlashSectorStateList getOwningList() {
        return this.owningList;
    }

    public Address getEndAddress() {
        return this.endAddress;
    }

    public int getFreedBlockCount() {
        return this.freedBlockCount;
    }

    public long getSequence() {
        return this.sequence;
    }

    public int getSize() {
        return this.flashSector.getSize();
    }

    public Address getStartAddress() {
        return this.startAddress;
    }

    public int getAllocatedBlockCount() {
        return this.mallocedBlockCount;
    }

    public Address getWriteHeadAddress() {
        return this.startAddress.add(this.writeHead);
    }

    public int getWriteHeadPosition() {
        return this.writeHead;
    }

    public boolean hasAvailable(int length) {
        if (length == 0) {
            return true;
        }
        return length > 0 && this.writeHead + length <= this.getSize();
    }

    public boolean hasErasedHeader() {
        return this.hasErasedHeader;
    }

    public void incrementAllocatedBlockCount() {
        ++this.mallocedBlockCount;
    }

    public void incrementFreedBlockCount() {
        ++this.freedBlockCount;
    }

    public void init(Address startAddress, int size) {
        this.startAddress = startAddress;
        this.endAddress = startAddress.add(size);
        this.writeHead = 0;
        this.initState();
    }

    protected void initState() {
        if (this.flashSector.getSize() < ERASED_HEADER_SIZE) {
            throw new IllegalArgumentException("Sector size is too small to be used");
        }
        byte[] bytes = BUFFER;
        this.readBytes(0, bytes, 0, ERASED_HEADER_SIZE);
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            if (input.readByte() != 0) {
                return;
            }
            if (input.readByte() != 0) {
                return;
            }
            int max = ERASED_HEADER.length;
            for (int i = 0; i < max; ++i) {
                if (input.readByte() == ERASED_HEADER[i]) continue;
                return;
            }
            this.sequence = input.readLong();
            if (input.readByte() != 0) {
                return;
            }
            if (input.readByte() != 0) {
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("System error: " + e);
        }
        this.writeHead = bytes.length;
        this.hasErasedHeader = true;
    }

    public void readBytes(int offset, byte[] buffer, int bufferStart, int bufferLength) {
        if (bufferLength == 0) {
            return;
        }
        this.checkReadWriteParameters(offset, buffer, bufferStart, bufferLength);
        this.flashSector.getBytes(offset, buffer, bufferStart, bufferLength);
    }

    public void removeErasedHeader() throws RecordStoreException {
        byte[] bytes = new byte[ERASED_HEADER_SIZE];
        for (int i = 0; i < ERASED_HEADER_SIZE; ++i) {
            bytes[i] = 0;
        }
        this.writeBytes(0, bytes, 0, ERASED_HEADER_SIZE);
        this.hasErasedHeader = false;
        this.freedBlockCount = 0;
        this.mallocedBlockCount = 0;
    }

    public void resetHead() {
        this.writeHead = this.hasErasedHeader ? ERASED_HEADER_SIZE : 0;
    }

    public void setNextSector(INorFlashSectorState next) {
        this.nextSector = next;
    }

    public void setOwningList(INorFlashSectorStateList list) {
        this.owningList = list;
    }

    public void setWriteHeadPosition(int position) {
        this.writeHead = position;
    }

    public void writeBytes(byte[] buffer, int bufferStart, int bufferLength) {
        if (bufferLength == 0) {
            return;
        }
        this.checkReadWriteParameters(this.writeHead, buffer, bufferStart, bufferLength);
        this.flashSector.setBytes(this.writeHead, buffer, bufferStart, bufferLength);
        this.writeHead += bufferLength;
    }

    public void writeBytes(int offset, byte[] buffer, int bufferStart, int bufferLength) {
        if (bufferLength == 0) {
            return;
        }
        this.checkReadWriteParameters(offset, buffer, bufferStart, bufferLength);
        this.flashSector.setBytes(offset, buffer, bufferStart, bufferLength);
    }
}

