/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io;

import com.sun.squawk.io.BaseInputStream;
import com.sun.squawk.io.BaseOutputStream;
import com.sun.squawk.io.ConnectionBase;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.StreamConnection;

public abstract class ConnectionBaseAdapter
extends ConnectionBase
implements StreamConnection {
    protected boolean connectionOpen = false;
    protected int iStreams = 0;
    protected int maxIStreams = 1;
    protected int oStreams = 0;
    protected int maxOStreams = 1;

    public abstract Connection openPrim(String var1, int var2, boolean var3) throws IOException;

    public void initStreamConnection(int mode) throws IOException {
        switch (mode) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal mode");
            }
        }
        this.connectionOpen = true;
    }

    public InputStream openInputStream() throws IOException {
        this.ensureOpen();
        if (this.maxIStreams == 0) {
            throw new IOException("no more input streams available");
        }
        BaseInputStream i = new BaseInputStream(this);
        --this.maxIStreams;
        ++this.iStreams;
        return i;
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public OutputStream openOutputStream() throws IOException {
        this.ensureOpen();
        if (this.maxOStreams == 0) {
            throw new IOException("no more output streams available");
        }
        BaseOutputStream o = new BaseOutputStream(this);
        --this.maxOStreams;
        ++this.oStreams;
        return o;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public void close() throws IOException {
        if (this.connectionOpen) {
            this.connectionOpen = false;
            this.closeCommon();
        }
    }

    protected void closeInputStream() throws IOException {
        --this.iStreams;
        this.notifyClosedInput();
        this.closeCommon();
    }

    protected void closeOutputStream() throws IOException {
        --this.oStreams;
        this.notifyClosedOutput();
        this.closeCommon();
    }

    void closeCommon() throws IOException {
        if (!this.connectionOpen && this.iStreams == 0 && this.oStreams == 0) {
            this.disconnect();
        }
    }

    protected void notifyClosedInput() {
    }

    protected void notifyClosedOutput() {
    }

    protected void ensureOpen() throws IOException {
        if (!this.connectionOpen) {
            throw new IOException("Connection closed");
        }
    }

    protected abstract void disconnect() throws IOException;

    protected abstract int readBytes(byte[] var1, int var2, int var3) throws IOException;

    public int available() throws IOException {
        return 0;
    }

    protected abstract int writeBytes(byte[] var1, int var2, int var3) throws IOException;

    protected void flush() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

