/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public final class MulticastOutputStream
extends OutputStream {
    private Hashtable streams = new Hashtable();

    public void write(int b) throws IOException {
        IOException ioe = null;
        Enumeration e = this.streams.elements();
        while (e.hasMoreElements()) {
            OutputStream stream = (OutputStream)e.nextElement();
            try {
                stream.write(b);
            }
            catch (IOException ex) {
                ioe = ex;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        IOException ioe = null;
        Enumeration e = this.streams.elements();
        while (e.hasMoreElements()) {
            OutputStream stream = (OutputStream)e.nextElement();
            try {
                stream.write(b, off, len);
            }
            catch (IOException ex) {
                ioe = ex;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public void close() throws IOException {
        IOException ioe = null;
        Enumeration e = this.streams.elements();
        while (e.hasMoreElements()) {
            OutputStream stream = (OutputStream)e.nextElement();
            try {
                stream.close();
            }
            catch (IOException ex) {
                ioe = ex;
            }
        }
        this.streams = new Hashtable();
        if (ioe != null) {
            throw ioe;
        }
    }

    public void flush() throws IOException {
        IOException ioe = null;
        Enumeration e = this.streams.elements();
        while (e.hasMoreElements()) {
            OutputStream stream = (OutputStream)e.nextElement();
            try {
                stream.flush();
            }
            catch (IOException ex) {
                ioe = ex;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public OutputStream add(String name, OutputStream out) {
        if (name == null || out == null) {
            throw new IllegalArgumentException();
        }
        return (OutputStream)this.streams.put(name, out);
    }

    public OutputStream remove(String name) {
        return (OutputStream)this.streams.remove(name);
    }

    public Enumeration removeAll() {
        Hashtable t = this.streams;
        this.streams = new Hashtable();
        return t.elements();
    }

    public int getSize() {
        return this.streams.size();
    }

    public Enumeration listNames() {
        return this.streams.keys();
    }

    public OutputStream get(String name) {
        return (OutputStream)this.streams.get(name);
    }
}

