/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.j2me.file;

import com.sun.squawk.io.ConnectionBaseAdapter;
import com.sun.squawk.io.j2me.ParameterParser;
import com.sun.squawk.io.j2me.file.ConnectionClosedException;
import com.sun.squawk.io.j2me.file.EscapedUtil;
import com.sun.squawk.microedition.io.FileConnection;
import com.sun.squawk.platform.GCFFile;
import com.sun.squawk.platform.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;

public class Protocol
extends ConnectionBaseAdapter
implements FileConnection {
    private int mode;
    private String fileName;
    private static final String filePath = "";
    private static final String fileRoot = "";
    private String fileURL;
    private GCFFile fileHandler;
    InputStream fis;
    OutputStream fos;
    private static String sep = System.getProperty("file.separator");

    public Protocol() {
        this.connectionOpen = false;
        this.fileHandler = null;
    }

    public int available() throws IOException {
        return 0;
    }

    public Connection open(String protocol, String name, int mode, boolean timeouts) throws IOException {
        return this.openPrim(name, mode, timeouts);
    }

    public Connection openPrim(String name, int mode, boolean timeouts) throws IOException {
        if (!name.startsWith("//")) {
            throw new IllegalArgumentException("Missing protocol separator");
        }
        class Parameters
        extends ParameterParser {
            boolean append;
            Vector path = new Vector();

            Parameters() {
            }

            public boolean parameter(String key, String value) {
                if (key.equals("append")) {
                    this.append = value.equals("true");
                } else if (key.equals("pathelement")) {
                    this.path.addElement(value);
                } else {
                    return false;
                }
                return true;
            }
        }
        Parameters p = new Parameters();
        String realfileName = p.parse(name.substring(2));
        try {
            if (mode == 1) {
                if (realfileName.endsWith("/")) {
                    throw new IllegalArgumentException("Directory listing not yet supported");
                }
                if (p.path.size() != 0) {
                    boolean found = false;
                    Enumeration e = p.path.elements();
                    while (e.hasMoreElements()) {
                        String path = (String)e.nextElement();
                        String possibleName = path + sep + realfileName;
                        if (!Protocol.exists(possibleName)) continue;
                        found = true;
                        realfileName = possibleName;
                        break;
                    }
                    if (!found) {
                        throw new IOException();
                    }
                }
            } else if (mode == 2 && p.path.size() != 0) {
                boolean found = false;
                Enumeration e = p.path.elements();
                while (e.hasMoreElements()) {
                    String path = (String)e.nextElement();
                    String possibleName = path + sep + realfileName;
                    try {
                        Protocol.create(possibleName);
                        found = true;
                        realfileName = possibleName;
                        break;
                    }
                    catch (IOException ex) {
                    }
                }
                if (!found) {
                    throw new IOException();
                }
            }
        }
        catch (IOException ex) {
            throw new ConnectionNotFoundException(name);
        }
        this.fileName = "//" + realfileName;
        return this.openPrimImpl(this.fileName, mode, timeouts, true);
    }

    public boolean isOpen() {
        return this.connectionOpen;
    }

    public InputStream openInputStream() throws IOException {
        this.checkReadPermission();
        try {
            this.ensureOpenAndConnected();
        }
        catch (ConnectionClosedException e) {
            throw new IOException(e.getMessage());
        }
        if (!this.fileHandler.exists()) {
            throw new IOException("Target file doesn't exist: " + this.fileURL);
        }
        this.fileHandler.openForRead();
        this.fis = super.openInputStream();
        return this.fis;
    }

    public OutputStream openOutputStream() throws IOException {
        return this.openOutputStream(0L);
    }

    public OutputStream openOutputStream(long byteOffset) throws IOException {
        if (byteOffset < 0L) {
            throw new IllegalArgumentException("Offset has a negative value");
        }
        this.checkWritePermission();
        try {
            this.ensureOpenAndConnected();
        }
        catch (ConnectionClosedException e) {
            throw new IOException(e.getMessage());
        }
        if (!this.fileHandler.exists()) {
            throw new IOException("Target file doesn't exist");
        }
        this.fileHandler.openForWrite();
        this.fileHandler.positionForWrite(byteOffset);
        this.fos = super.openOutputStream();
        return this.fos;
    }

    public long fileSize() throws IOException {
        long size = -1L;
        this.checkReadPermission();
        if (this.isDirectory()) {
            throw new IOException("fileSize invoked on a directory");
        }
        try {
            this.ensureOpenAndConnected();
            size = this.fileHandler.fileSize();
        }
        catch (IOException e) {
            size = -1L;
        }
        return size;
    }

    public void create() throws IOException {
        this.checkWritePermission();
        this.ensureOpenAndConnected();
        if (this.fileName.charAt(this.fileName.length() - 1) == '/') {
            throw new IOException("Can not create directory");
        }
        this.fileHandler.create();
    }

    public boolean exists() {
        boolean res = false;
        try {
            this.checkReadPermission();
            this.ensureOpenAndConnected();
            res = this.fileHandler.exists();
        }
        catch (IOException e) {
            res = false;
        }
        return res;
    }

    public boolean isDirectory() {
        boolean res = false;
        try {
            this.checkReadPermission();
            this.ensureOpenAndConnected();
            res = this.fileHandler.isDirectory();
        }
        catch (IOException e) {
            res = false;
        }
        return res;
    }

    public void delete() throws IOException {
        this.checkWritePermission();
        this.ensureOpenAndConnected();
        try {
            if (this.fis != null) {
                this.fis.close();
                this.fis = null;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.fos != null) {
                this.fos.close();
                this.fos = null;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fileHandler.closeForReadWrite();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fileHandler.delete();
    }

    public String getName() {
        String name = this.fileName;
        try {
            if (this.exists()) {
                int lastPos = name.length() - 1;
                if (this.isDirectory()) {
                    if (!name.equals("") && name.charAt(lastPos) != '/') {
                        name = name + '/';
                    }
                } else if (name.charAt(lastPos) == '/') {
                    name = name.substring(0, lastPos);
                }
            }
        }
        catch (SecurityException e) {
        }
        catch (IllegalStateException e) {
        }
        catch (ConnectionClosedException connectionClosedException) {
            // empty catch block
        }
        return name;
    }

    public String getPath() {
        return "";
    }

    public String getURL() {
        String url = EscapedUtil.getEscapedString(this.fileURL);
        try {
            if (this.exists()) {
                int lastPos = url.length() - 1;
                if (this.isDirectory()) {
                    if (url.charAt(lastPos) != '/') {
                        url = url + '/';
                    }
                } else if (url.charAt(lastPos) == '/') {
                    url = url.substring(0, lastPos);
                }
            }
        }
        catch (SecurityException e) {
        }
        catch (IllegalStateException e) {
        }
        catch (ConnectionClosedException connectionClosedException) {
            // empty catch block
        }
        return url;
    }

    protected int readBytes(byte[] b, int off, int len) throws IOException {
        this.checkReadPermission();
        this.ensureConnected();
        int readBytes = this.fileHandler.read(b, off, len);
        return readBytes > 0 ? readBytes : -1;
    }

    protected int writeBytes(byte[] b, int off, int len) throws IOException {
        this.checkWritePermission();
        this.ensureConnected();
        return this.fileHandler.write(b, off, len);
    }

    protected void flush() throws IOException {
        this.checkWritePermission();
        this.ensureConnected();
        this.fileHandler.flush();
    }

    protected void closeInputStream() throws IOException {
        ++this.maxIStreams;
        this.fileHandler.closeForRead();
        super.closeInputStream();
    }

    protected void closeOutputStream() throws IOException {
        ++this.maxOStreams;
        this.flush();
        this.fileHandler.closeForWrite();
        super.closeOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() throws IOException {
        try {
            if (this.fileHandler != null) {
                this.fileHandler.close();
            }
        }
        finally {
            this.fileHandler = null;
        }
    }

    protected void connect(String name, int mode, boolean timeouts) throws IOException {
    }

    protected void ensureConnected() throws IOException {
        if (this.fileHandler == null) {
            this.fileHandler = Protocol.getFileHandler();
            this.fileHandler.connect("", "" + this.fileName);
        }
    }

    public static boolean exists(String name) {
        GCFFile handler = Protocol.getFileHandler();
        handler.connect("", name);
        return handler.exists();
    }

    public static void create(String name) throws IOException {
        GCFFile handler = Protocol.getFileHandler();
        handler.connect("", name);
        handler.create();
    }

    private Connection openPrimImpl(String name, int mode, boolean timeouts, boolean unescape) throws IOException {
        if (unescape) {
            name = EscapedUtil.getUnescapedString(name);
        }
        this.fileURL = "file:" + name;
        switch (mode) {
            case 1: {
                this.checkReadPermission(this.fileURL, mode);
                this.maxOStreams = 0;
                break;
            }
            case 2: {
                this.checkWritePermission(this.fileURL, mode);
                this.maxIStreams = 0;
                break;
            }
            case 3: {
                this.checkReadPermission(this.fileURL, mode);
                this.checkWritePermission(this.fileURL, mode);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mode");
            }
        }
        this.mode = mode;
        int pathStart = 2;
        if (name.indexOf(47, 2) == 2 && name.indexOf(47, 3) == 3) {
            pathStart = 3;
        }
        this.fileName = name.substring(pathStart).trim();
        if (this.fileName.length() == 0) {
            throw new IllegalArgumentException("Missing file path");
        }
        this.connectionOpen = true;
        return this;
    }

    protected void ensureOpenAndConnected() throws IOException {
        if (!this.isOpen()) {
            throw new ConnectionClosedException("Connection is closed");
        }
        this.ensureConnected();
    }

    private final void checkReadPermission(String fileURL, int mode) throws InterruptedIOException {
        if (mode == 2) {
            throw new IllegalStateException("Connection is write only");
        }
    }

    protected final void checkReadPermission() throws InterruptedIOException {
        this.checkReadPermission(this.fileURL, this.mode);
    }

    protected final void checkRootReadPermission() throws InterruptedIOException {
        if (this.mode == 2) {
            throw new IllegalStateException("Connection is write only");
        }
    }

    private final void checkWritePermission(String fileURL, int mode) throws InterruptedIOException {
        if (mode == 1) {
            throw new IllegalStateException("Connection is read only");
        }
    }

    protected final void checkWritePermission() throws InterruptedIOException {
        this.checkWritePermission(this.fileURL, this.mode);
    }

    private static GCFFile getFileHandler() {
        return Platform.getFileHandler();
    }

    static {
        if (sep == null) {
            throw new NullPointerException("Undefined \"file.separator\" property");
        }
    }
}

