/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.mailboxes;

import com.sun.squawk.io.mailboxes.AddressClosedException;
import com.sun.squawk.io.mailboxes.Envelope;
import com.sun.squawk.io.mailboxes.Mailbox;
import com.sun.squawk.io.mailboxes.MailboxAddress;
import com.sun.squawk.io.mailboxes.MailboxClosedException;
import com.sun.squawk.io.mailboxes.NoSuchMailboxException;

public final class Channel {
    Mailbox inBox;
    MailboxAddress outBox;

    Channel(MailboxAddress outBox, Mailbox inBox) {
        this.outBox = outBox;
        this.inBox = inBox;
    }

    public static Channel lookup(String serverChannelName) throws NoSuchMailboxException {
        Mailbox inBox = Mailbox.create();
        MailboxAddress outBox = MailboxAddress.lookupMailbox(serverChannelName, inBox);
        return new Channel(outBox, inBox);
    }

    public void send(Envelope env) throws AddressClosedException {
        this.outBox.send(env);
    }

    public Envelope receive() throws AddressClosedException, MailboxClosedException {
        return this.inBox.receive();
    }

    public void close() {
        if (this.inBox.isOpen()) {
            this.inBox.close();
        }
        if (this.outBox.isOpen()) {
            this.outBox.close();
        }
    }

    public boolean isOpen() {
        return this.inBox.isOpen() && this.outBox.isOpen();
    }
}

