/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.mailboxes;

import com.sun.squawk.Isolate;
import com.sun.squawk.VM;
import com.sun.squawk.io.mailboxes.AddressClosedException;
import com.sun.squawk.io.mailboxes.Envelope;
import com.sun.squawk.io.mailboxes.MailboxAddress;
import com.sun.squawk.io.mailboxes.MailboxClosedException;
import com.sun.squawk.io.mailboxes.MailboxHandler;
import com.sun.squawk.io.mailboxes.MailboxInUseException;
import com.sun.squawk.util.SimpleLinkedList;

public final class Mailbox {
    private final String name;
    private boolean closed = false;
    private boolean registered = false;
    private MailboxHandler handler;
    private Isolate owner;
    private SimpleLinkedList inbox;
    private static int anonCounter;

    private Mailbox(String name, MailboxHandler handler) {
        this(name, handler, Isolate.currentIsolate());
    }

    private Mailbox(String name, MailboxHandler handler, Isolate owner) {
        this.name = name;
        this.handler = handler;
        this.owner = owner;
        this.inbox = new SimpleLinkedList();
        owner.recordMailbox(this);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (this.registered) {
            VM.unregisterMailbox(this.name, this);
        }
        this.closed = true;
        SimpleLinkedList simpleLinkedList = this.inbox;
        synchronized (simpleLinkedList) {
            this.inbox.notifyAll();
        }
        this.owner.forgetMailbox(this);
        this.inbox.clear();
        this.owner = null;
        this.handler = null;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public static Mailbox create(String name, MailboxHandler handler) throws MailboxInUseException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Mailbox box = new Mailbox(name, handler);
        if (VM.registerMailbox(name, box)) {
            box.registered = true;
            return box;
        }
        box.close();
        throw new MailboxInUseException(name);
    }

    public static Mailbox create() {
        return Mailbox.create(Isolate.currentIsolate());
    }

    private static synchronized Mailbox create(Isolate owner) {
        int id = anonCounter++;
        String anonName = "anonymous mailbox " + id + " in " + owner.getName();
        Mailbox box = new Mailbox(anonName, new AnonymousMailboxHandler(), owner);
        return box;
    }

    public Mailbox createSubMailbox() {
        return Mailbox.create(this.owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Envelope receive() throws AddressClosedException, MailboxClosedException {
        if (Isolate.currentIsolate() != this.owner) {
            throw new IllegalStateException("Attempted receive() on " + this + " by " + Isolate.currentIsolate());
        }
        Envelope env = null;
        SimpleLinkedList simpleLinkedList = this.inbox;
        synchronized (simpleLinkedList) {
            while (env == null) {
                while (this.inbox.size() == 0) {
                    if (this.closed) {
                        throw new MailboxClosedException(this);
                    }
                    try {
                        this.inbox.wait();
                    }
                    catch (InterruptedException e) {}
                }
                env = (Envelope)this.inbox.removeLast();
                if (!(env instanceof MailboxAddress.AddressClosedEnvelope)) continue;
                MailboxAddress replyTo = env.getReplyAddress();
                AddressClosedException e = this.handler.handleClose(replyTo);
                if (e != null) {
                    throw e;
                }
                env = null;
            }
        }
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMessage(Envelope env) throws AddressClosedException {
        Envelope envelope = env;
        synchronized (envelope) {
            SimpleLinkedList simpleLinkedList = this.inbox;
            synchronized (simpleLinkedList) {
                this.inbox.addFirst(env.copy());
                this.inbox.notifyAll();
            }
        }
    }

    public boolean isRegistered() {
        return this.registered;
    }

    MailboxAddress callHandleOpen(MailboxAddress startingAddress, MailboxAddress replyAddress) {
        return this.handler.handleOpen(this, startingAddress, replyAddress);
    }

    Isolate getOwner() {
        return this.owner;
    }

    public String toString() {
        if (this.closed) {
            return "Mailbox " + this.name + " (CLOSED)";
        }
        return "Mailbox " + this.name + " of " + this.owner;
    }

    private static class AnonymousMailboxHandler
    implements MailboxHandler {
        private AnonymousMailboxHandler() {
        }

        public MailboxAddress handleOpen(Mailbox originalMailbox, MailboxAddress originalAddress, MailboxAddress replyAddress) {
            return originalAddress;
        }

        public AddressClosedException handleClose(MailboxAddress address) {
            return new AddressClosedException(address);
        }
    }
}

