/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.platform;

import com.sun.squawk.Klass;
import com.sun.squawk.VM;
import com.sun.squawk.platform.GCFFile;
import com.sun.squawk.platform.GCFSockets;
import com.sun.squawk.platform.SystemEvents;

public class Platform {
    public static final boolean DEBUG = false;
    public static final int BARE_METAL = 0;
    public static final int DELEGATING = 1;
    public static final int NATIVE = 2;
    public static final int SOCKET = 3;
    public static final boolean IS_BARE_METAL = false;
    public static final boolean IS_DELEGATING = false;
    public static final boolean IS_NATIVE = true;
    public static final boolean IS_SOCKET = false;
    private static GCFSockets gcfSockets;
    private static GCFFile gcfFile;
    private static String NATIVE_PLATFORM_NAME;

    private Platform() {
    }

    public static String getPlatformName() {
        if (NATIVE_PLATFORM_NAME == null) {
            NATIVE_PLATFORM_NAME = com.sun.cldc.jna.Platform.getPlatform().getPlatformPackageName();
        }
        return NATIVE_PLATFORM_NAME;
    }

    private static Object getPlatformInstance(String name) {
        Object e = null;
        String fullname = Platform.getPlatformName() + "." + name;
        Klass klass = Klass.lookupKlass(fullname);
        if (klass != null) {
            Object result = klass.newInstance();
            return result;
        }
        VM.println("Error loading platform " + fullname + "\n   " + e);
        VM.stopVM(1);
        return null;
    }

    public static synchronized GCFSockets getGCFSockets() {
        if (gcfSockets == null) {
            gcfSockets = (GCFSockets)Platform.getPlatformInstance("GCFSocketsImpl");
        }
        return gcfSockets;
    }

    public static SystemEvents createSystemEvents() {
        return (SystemEvents)Platform.getPlatformInstance("SystemEventsImpl");
    }

    public static GCFFile getFileHandler() {
        if (gcfFile == null) {
            gcfFile = (GCFFile)Platform.getPlatformInstance("GCFFileImpl");
        }
        return gcfFile;
    }
}

