/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.platform.posix;

import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.ptr.IntByReference;
import com.sun.squawk.VMThread;
import com.sun.squawk.platform.GCFSockets;
import com.sun.squawk.platform.posix.Inet;
import com.sun.squawk.platform.posix.LibCUtil;
import com.sun.squawk.platform.posix.natives.Ioctl;
import com.sun.squawk.platform.posix.natives.LibC;
import com.sun.squawk.platform.posix.natives.NetDB;
import com.sun.squawk.platform.posix.natives.Socket;
import java.io.IOException;

public class GCFSocketsImpl
implements GCFSockets {
    public static final boolean DEBUG = false;
    public static final boolean NBIO_WORKS = false;
    LibC libc = LibC.INSTANCE;
    Socket sockets = Socket.INSTANCE;
    Ioctl ioctl = Ioctl.INSTANCE;
    private boolean tryFcntl = true;
    private Pointer availableBuf = new Pointer(4);

    private IOException newError(int fd, String msg) {
        int err_code = LibCUtil.errno();
        this.sockets.shutdown(fd, 2);
        this.libc.close(fd);
        return new IOException(" errno: " + err_code + " on fd: " + fd + " during " + msg);
    }

    private void set_blocking_flags(int fd, boolean is_blocking) throws IOException {
        int res;
        if (this.tryFcntl) {
            int flags = this.libc.fcntl(fd, LibC.F_GETFL, 0);
            if (flags >= 0) {
                flags = is_blocking ? (flags &= ~LibC.O_NONBLOCK) : (flags |= LibC.O_NONBLOCK);
                res = this.libc.fcntl(fd, LibC.F_SETFL, flags);
                if (res != -1) {
                    return;
                }
            } else if (LibCUtil.errno() == LibC.EOPNOTSUPP) {
                this.tryFcntl = false;
            }
        }
        if (!this.tryFcntl) {
            IntByReference setting = new IntByReference(is_blocking ? 0 : 1);
            res = this.ioctl.ioctl(fd, Ioctl.FIONBIO, setting);
            setting.free();
            if (res >= 0) {
                return;
            }
        }
        throw this.newError(fd, "set_blocking_flags");
    }

    public int open(String hostname, int port, int mode) throws IOException {
        int fd = -1;
        fd = this.sockets.socket(Socket.AF_INET, Socket.SOCK_STREAM, 0);
        if (fd < 0) {
            throw this.newError(fd, "socket create");
        }
        this.set_blocking_flags(fd, false);
        NetDB.hostent phostent = NetDB.INSTANCE.gethostbyname(hostname);
        if (phostent == null) {
            throw this.newError(fd, "gethostbyname (herrono = " + NetDB.INSTANCE.h_errno() + ")");
        }
        Socket.sockaddr_in destination_sin = new Socket.sockaddr_in();
        destination_sin.sin_family = Socket.AF_INET;
        destination_sin.sin_port = Inet.htons((short)port);
        destination_sin.sin_addr = phostent.h_addr_list[0];
        if (this.sockets.connect(fd, destination_sin, destination_sin.size()) < 0) {
            int err_code = LibCUtil.errno();
            if (err_code == LibC.EINPROGRESS || err_code == LibC.EWOULDBLOCK) {
                VMThread.getSystemEvents().waitForWriteEvent(fd);
                int errno = this.getSockOpt(fd, 4103);
                if (errno != 0) {
                    String msg = errno == LibC.ECONNREFUSED ? "connect refused" : String.valueOf(errno);
                    throw new IOException("ConnectException: " + msg);
                }
            } else {
                throw this.newError(fd, "connect");
            }
        }
        try {
            this.setSockOpt(fd, Socket.IPPROTO_TCP, Socket.TCP_NODELAY, 1);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return fd;
    }

    public String inet_ntop(int in) {
        Pointer charBuf = new Pointer(Socket.INET_ADDRSTRLEN);
        IntByReference addrBuf = new IntByReference(in);
        String result = this.sockets.inet_ntop(Socket.AF_INET, addrBuf, charBuf, Socket.INET_ADDRSTRLEN);
        addrBuf.free();
        charBuf.free();
        return result;
    }

    public int openServer(int port, int backlog) throws IOException {
        int fd = -1;
        fd = this.sockets.socket(Socket.AF_INET, Socket.SOCK_STREAM, 0);
        if (fd < 0) {
            throw this.newError(fd, "socket create");
        }
        this.set_blocking_flags(fd, false);
        this.setSockOpt(fd, Socket.SO_REUSEADDR, 1);
        this.setSockOpt(fd, Socket.IPPROTO_TCP, Socket.TCP_NODELAY, 1);
        Socket.sockaddr_in local_sin = new Socket.sockaddr_in();
        local_sin.sin_family = Socket.AF_INET;
        local_sin.sin_port = Inet.htons((short)port);
        local_sin.sin_addr = Socket.INADDR_ANY;
        if (this.sockets.bind(fd, local_sin, local_sin.size()) < 0) {
            throw this.newError(fd, "bind");
        }
        if (this.sockets.listen(fd, backlog) < 0) {
            throw this.newError(fd, "listen");
        }
        return fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int accept(int fd) throws IOException {
        int newSocket;
        Socket.sockaddr_in remote_sin = new Socket.sockaddr_in();
        IntByReference address_len = new IntByReference(4);
        try {
            int err_code;
            newSocket = this.sockets.accept(fd, remote_sin, address_len);
            if (newSocket < 0 && ((err_code = LibCUtil.errno()) == LibC.EAGAIN || err_code == LibC.EWOULDBLOCK)) {
                VMThread.getSystemEvents().waitForReadEvent(fd);
                newSocket = this.sockets.accept(fd, remote_sin, address_len);
                if (newSocket < 0) {
                    throw this.newError(fd, "accept");
                }
            }
        }
        finally {
            address_len.free();
        }
        this.set_blocking_flags(newSocket, false);
        return newSocket;
    }

    public int readBuf(int fd, byte[] b, int offset, int length) throws IOException {
        int bAvail;
        byte[] buf = b;
        if (offset != 0) {
            buf = new byte[length];
        }
        if ((bAvail = this.available(fd)) == 0) {
            VMThread.getSystemEvents().waitForReadEvent(fd);
            bAvail = this.available(fd);
            if (bAvail == 0) {
                return -1;
            }
        }
        int n = Math.min(bAvail, length);
        int result = this.libc.read(fd, buf, n);
        LibCUtil.errCheckNeg(result);
        if (result == 0) {
            result = -1;
        }
        if (offset != 0 && result > 0) {
            System.arraycopy(buf, 0, b, offset, result);
        }
        return result;
    }

    public int readByte(int fd, byte[] b) throws IOException {
        int result = -1;
        if (this.readBuf(fd, b, 0, 1) == 1) {
            result = b[0] & 0xFF;
        }
        return result;
    }

    public int readByte(int fd) throws IOException {
        return this.readByte(fd, new byte[1]);
    }

    public int writeBuf(int fd, byte[] buffer, int off, int len) throws IOException {
        int result = 0;
        byte[] buf = buffer;
        if (off != 0) {
            buf = new byte[len];
            System.arraycopy(buffer, off, buf, 0, len);
        }
        if ((result = this.libc.write(fd, buf, len)) < 0) {
            int err_code = LibCUtil.errno();
            if (err_code == LibC.EWOULDBLOCK) {
                VMThread.getSystemEvents().waitForWriteEvent(fd);
                result = this.libc.write(fd, buf, len);
            }
            LibCUtil.errCheckNeg(result);
        }
        return result;
    }

    public int writeByte(int fd, int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        int result = this.writeBuf(fd, buf, 0, 1);
        return result;
    }

    public int available(int fd) throws IOException {
        int err = this.ioctl.ioctl(fd, Ioctl.FIONREAD, this.availableBuf.address().toUWord().toPrimitive());
        int result = this.availableBuf.getInt(0L);
        LibCUtil.errCheckNeg(err);
        return result;
    }

    public void close(int fd) throws IOException {
        this.sockets.shutdown(fd, 2);
        this.libc.close(fd);
    }

    public void setSockOpt(int socket, int level, int option_name, int option_value) throws IOException {
        IntByReference value = new IntByReference(option_value);
        int err = this.sockets.setsockopt(socket, level, option_name, value, 4);
        value.free();
        LibCUtil.errCheckNeg(err);
    }

    public int getSockOpt(int socket, int level, int option_name) throws IOException {
        IntByReference value = new IntByReference(0);
        IntByReference opt_len = new IntByReference(4);
        int err = this.sockets.getsockopt(socket, level, option_name, value, opt_len);
        int result = value.getValue();
        value.free();
        opt_len.free();
        LibCUtil.errCheckNeg(err);
        return result;
    }

    public void setSockOpt(int socket, int option_name, int option_value) throws IOException {
        this.setSockOpt(socket, Socket.SOL_SOCKET, option_name, option_value);
    }

    public int getSockOpt(int socket, int option_name) throws IOException {
        return this.getSockOpt(socket, Socket.SOL_SOCKET, option_name);
    }
}

