/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.platform.posix.natives;

import com.sun.cldc.jna.Function;
import com.sun.cldc.jna.Native;
import com.sun.cldc.jna.NativeLibrary;
import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.PrivatePointer;
import com.sun.cldc.jna.Structure;
import com.sun.squawk.Address;
import com.sun.squawk.platform.posix.natives.LibC;

public abstract class LibCImpl
implements LibC {
    protected final Function openPtr;
    protected final Function statPtr;
    protected final Function fcntlPtr;
    protected final Function writePtr;
    protected final Function closePtr;
    protected final Function readPtr;
    protected final Function fstatPtr;
    protected final Function fsyncPtr;
    protected final Function lseekPtr;
    protected final Function unlinkPtr;

    public int open(String arg0, int arg1, int arg2) {
        int result0;
        Pointer var0 = Pointer.createStringBuffer(arg0);
        int result = result0 = this.openPtr.call3(var0, arg1, arg2);
        var0.free();
        return result;
    }

    public int stat(String arg0, LibC.stat arg1) {
        int result0;
        Pointer var0 = Pointer.createStringBuffer(arg0);
        arg1.allocateMemory();
        arg1.write();
        Pointer var1 = arg1.getPointer();
        int result = result0 = this.statPtr.call2(var0, var1);
        var0.free();
        arg1.read();
        arg1.freeMemory();
        return result;
    }

    public int fcntl(int arg0, int arg1, int arg2) {
        int result0;
        int result = result0 = this.fcntlPtr.call3(arg0, arg1, arg2);
        return result;
    }

    public int write(int arg0, byte[] arg1, int arg2) {
        int result0;
        boolean oldState = PrivatePointer.setUpArrayBufferState();
        Address var1 = PrivatePointer.createArrayBuffer(arg1);
        int result = result0 = this.writePtr.call3(arg0, var1.toUWord().toPrimitive(), arg2);
        PrivatePointer.tearDownArrayBufferState(oldState);
        return result;
    }

    public int close(int arg0) {
        int result0;
        int result = result0 = this.closePtr.call1(arg0);
        return result;
    }

    public int read(int arg0, byte[] arg1, int arg2) {
        int result0;
        boolean oldState = PrivatePointer.setUpArrayBufferState();
        Address var1 = PrivatePointer.createArrayBuffer(arg1);
        int result = result0 = this.readPtr.call3(arg0, var1.toUWord().toPrimitive(), arg2);
        PrivatePointer.tearDownArrayBufferState(oldState);
        return result;
    }

    public int fstat(int arg0, LibC.stat arg1) {
        int result0;
        arg1.allocateMemory();
        arg1.write();
        Pointer var1 = arg1.getPointer();
        int result = result0 = this.fstatPtr.call2(arg0, var1);
        arg1.read();
        arg1.freeMemory();
        return result;
    }

    public int fsync(int arg0) {
        int result0;
        int result = result0 = this.fsyncPtr.call1(arg0);
        return result;
    }

    public int lseek(int arg0, long arg1, int arg2) {
        int result0;
        int var1 = (int)(arg1 >>> 32);
        int var2 = (int)arg1;
        int result = result0 = this.lseekPtr.call4(arg0, var1, var2, arg2);
        return result;
    }

    public int unlink(String arg0) {
        int result0;
        Pointer var0 = Pointer.createStringBuffer(arg0);
        int result = result0 = this.unlinkPtr.call1(var0);
        var0.free();
        return result;
    }

    public LibCImpl() {
        NativeLibrary jnaNativeLibrary = Native.getLibraryLoading();
        this.openPtr = jnaNativeLibrary.getFunction(this.realName("open"));
        this.statPtr = jnaNativeLibrary.getFunction(this.realName("stat"));
        this.fcntlPtr = jnaNativeLibrary.getFunction(this.realName("fcntl"));
        this.writePtr = jnaNativeLibrary.getFunction(this.realName("write"));
        this.closePtr = jnaNativeLibrary.getFunction(this.realName("close"));
        this.readPtr = jnaNativeLibrary.getFunction(this.realName("read"));
        this.fstatPtr = jnaNativeLibrary.getFunction(this.realName("fstat"));
        this.fsyncPtr = jnaNativeLibrary.getFunction(this.realName("fsync"));
        this.lseekPtr = jnaNativeLibrary.getFunction(this.realName("lseek"));
        this.unlinkPtr = jnaNativeLibrary.getFunction(this.realName("unlink"));
    }

    public String realName(String nominalName) {
        return nominalName;
    }

    public static class statImpl
    extends Structure {
        public static final int EPERM = 1;
        public static final int STAT_SIZE = NativeLibrary.getDefaultInstance().getGlobalVariableAddress("sysSIZEOFSTAT", 4).getInt(0L);

        protected statImpl() {
        }

        public int size() {
            return STAT_SIZE;
        }

        public void read() {
            Pointer p = this.getPointer();
            LibC.stat o = (LibC.stat)this;
            o.st_mode = p.getShort(8L);
            o.st_mtime = p.getInt(32L);
            o.st_size = p.getLong(48L);
        }

        public void write() {
            Pointer p = this.getPointer();
            LibC.stat o = (LibC.stat)this;
            p.setShort(8L, (short)o.st_mode);
            p.setInt(32L, o.st_mtime);
            p.setLong(48L, o.st_size);
        }
    }
}

