/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.platform.windows.natives;

import com.sun.cldc.jna.Function;
import com.sun.cldc.jna.Native;
import com.sun.cldc.jna.NativeLibrary;
import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.PrivatePointer;
import com.sun.cldc.jna.Structure;
import com.sun.squawk.Address;
import com.sun.squawk.platform.windows.natives.LibC;

public class LibCImpl
implements LibC {
    public static final int EPERM = 1;
    public static final int ENOENT = 2;
    public static final int ESRCH = 3;
    public static final int EINTR = 4;
    public static final int EIO = 5;
    public static final int ENXIO = 6;
    public static final int E2BIG = 7;
    public static final int ENOEXEC = 8;
    public static final int EBADF = 9;
    public static final int ECHILD = 10;
    public static final int EDEADLK = 11;
    public static final int ENOMEM = 12;
    public static final int EACCES = 13;
    public static final int EFAULT = 14;
    public static final int EBUSY = 16;
    public static final int EEXIST = 17;
    public static final int EXDEV = 18;
    public static final int ENODEV = 19;
    public static final int ENOTDIR = 20;
    public static final int EISDIR = 21;
    public static final int EINVAL = 22;
    public static final int ENFILE = 23;
    public static final int EMFILE = 24;
    public static final int ENOTTY = 25;
    public static final int ETXTBSY = 26;
    public static final int EFBIG = 27;
    public static final int ENOSPC = 28;
    public static final int ESPIPE = 29;
    public static final int EROFS = 30;
    public static final int EMLINK = 31;
    public static final int EPIPE = 32;
    public static final int EDOM = 33;
    public static final int ERANGE = 34;
    public static final int EAGAIN = 35;
    public static final int EWOULDBLOCK = 35;
    public static final int EINPROGRESS = 36;
    public static final int EALREADY = 37;
    public static final int ENOTSOCK = 38;
    public static final int EDESTADDRREQ = 39;
    public static final int EMSGSIZE = 40;
    public static final int EPROTOTYPE = 41;
    public static final int ENOPROTOOPT = 42;
    public static final int EPROTONOSUPPORT = 43;
    public static final int ENOTSUP = 45;
    public static final int EAFNOSUPPORT = 47;
    public static final int EADDRINUSE = 48;
    public static final int EADDRNOTAVAIL = 49;
    public static final int ENETDOWN = 50;
    public static final int ENETUNREACH = 51;
    public static final int ENETRESET = 52;
    public static final int ECONNABORTED = 53;
    public static final int ECONNRESET = 54;
    public static final int ENOBUFS = 55;
    public static final int EISCONN = 56;
    public static final int ENOTCONN = 57;
    public static final int ETIMEDOUT = 60;
    public static final int ECONNREFUSED = 61;
    public static final int ELOOP = 62;
    public static final int ENAMETOOLONG = 63;
    public static final int EHOSTUNREACH = 65;
    public static final int ENOTEMPTY = 66;
    public static final int EDQUOT = 69;
    public static final int ENOLCK = 77;
    public static final int ENOSYS = 78;
    public static final int EOVERFLOW = 84;
    public static final int ECANCELED = 89;
    public static final int EIDRM = 90;
    public static final int ENOMSG = 91;
    public static final int EILSEQ = 92;
    public static final int EBADMSG = 94;
    public static final int EMULTIHOP = 95;
    public static final int ENODATA = 96;
    public static final int ENOLINK = 97;
    public static final int ENOSR = 98;
    public static final int ENOSTR = 99;
    public static final int EPROTO = 100;
    public static final int ETIME = 101;
    public static final int F_DUPFD = 0;
    public static final int F_GETFD = 1;
    public static final int F_SETFD = 2;
    public static final int F_GETFL = 3;
    public static final int F_SETFL = 4;
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_ACCMODE = 3;
    public static final int O_NONBLOCK = 4;
    public static final int O_APPEND = 8;
    public static final int O_SYNC = 128;
    public static final int O_CREAT = 512;
    public static final int O_TRUNC = 1024;
    public static final int O_EXCL = 2048;
    public static final int S_IFBLK = 24576;
    public static final int S_IFCHR = 8192;
    public static final int S_IFDIR = 16384;
    public static final int S_IFIFO = 4096;
    public static final int S_IFLNK = 40960;
    public static final int S_IFMT = 61440;
    public static final int S_IFREG = 32768;
    public static final int S_IFSOCK = 49152;
    public static final int S_IRGRP = 32;
    public static final int S_IROTH = 4;
    public static final int S_IRUSR = 256;
    public static final int S_IRWXG = 56;
    public static final int S_IRWXO = 7;
    public static final int S_IRWXU = 448;
    public static final int S_ISGID = 1024;
    public static final int S_ISUID = 2048;
    public static final int S_ISVTX = 512;
    public static final int S_IWGRP = 16;
    public static final int S_IWOTH = 2;
    public static final int S_IWUSR = 128;
    public static final int S_IXGRP = 8;
    public static final int S_IXOTH = 1;
    public static final int S_IXUSR = 64;
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    private final Function openPtr;
    private final Function statPtr;
    private final Function fcntlPtr;
    private final Function writePtr;
    private final Function closePtr;
    private final Function readPtr;
    private final Function fstatPtr;
    private final Function fsyncPtr;
    private final Function lseekPtr;
    private final Function unlinkPtr;

    public int initConstInt(int index) {
        int[] dummy = new int[]{};
        return dummy[index];
    }

    public int open(String arg0, int arg1, int arg2) {
        int result0;
        Pointer var0 = Pointer.createStringBuffer(arg0);
        int result = result0 = this.openPtr.call3(var0, arg1, arg2);
        var0.free();
        return result;
    }

    public int stat(String arg0, LibC.stat arg1) {
        int result0;
        Pointer var0 = Pointer.createStringBuffer(arg0);
        arg1.allocateMemory();
        arg1.write();
        Pointer var1 = arg1.getPointer();
        int result = result0 = this.statPtr.call2(var0, var1);
        var0.free();
        arg1.read();
        arg1.freeMemory();
        return result;
    }

    public int fcntl(int arg0, int arg1, int arg2) {
        int result0;
        int result = result0 = this.fcntlPtr.call3(arg0, arg1, arg2);
        return result;
    }

    public int write(int arg0, byte[] arg1, int arg2) {
        int result0;
        boolean oldState = PrivatePointer.setUpArrayBufferState();
        Address var1 = PrivatePointer.createArrayBuffer(arg1);
        int result = result0 = this.writePtr.call3(arg0, var1.toUWord().toPrimitive(), arg2);
        PrivatePointer.tearDownArrayBufferState(oldState);
        return result;
    }

    public int close(int arg0) {
        int result0;
        int result = result0 = this.closePtr.call1(arg0);
        return result;
    }

    public int read(int arg0, byte[] arg1, int arg2) {
        int result0;
        boolean oldState = PrivatePointer.setUpArrayBufferState();
        Address var1 = PrivatePointer.createArrayBuffer(arg1);
        int result = result0 = this.readPtr.call3(arg0, var1.toUWord().toPrimitive(), arg2);
        PrivatePointer.tearDownArrayBufferState(oldState);
        return result;
    }

    public int fstat(int arg0, LibC.stat arg1) {
        int result0;
        arg1.allocateMemory();
        arg1.write();
        Pointer var1 = arg1.getPointer();
        int result = result0 = this.fstatPtr.call2(arg0, var1);
        arg1.read();
        arg1.freeMemory();
        return result;
    }

    public int fsync(int arg0) {
        int result0;
        int result = result0 = this.fsyncPtr.call1(arg0);
        return result;
    }

    public int lseek(int arg0, long arg1, int arg2) {
        int result0;
        int var1 = (int)(arg1 >>> 32);
        int var2 = (int)arg1;
        int result = result0 = this.lseekPtr.call4(arg0, var1, var2, arg2);
        return result;
    }

    public int unlink(String arg0) {
        int result0;
        Pointer var0 = Pointer.createStringBuffer(arg0);
        int result = result0 = this.unlinkPtr.call1(var0);
        var0.free();
        return result;
    }

    public LibCImpl() {
        NativeLibrary jnaNativeLibrary = Native.getLibraryLoading();
        this.openPtr = jnaNativeLibrary.getFunction("open");
        this.statPtr = jnaNativeLibrary.getFunction("stat");
        this.fcntlPtr = jnaNativeLibrary.getFunction("fcntl");
        this.writePtr = jnaNativeLibrary.getFunction("write");
        this.closePtr = jnaNativeLibrary.getFunction("close");
        this.readPtr = jnaNativeLibrary.getFunction("read");
        this.fstatPtr = jnaNativeLibrary.getFunction("fstat");
        this.fsyncPtr = jnaNativeLibrary.getFunction("fsync");
        this.lseekPtr = jnaNativeLibrary.getFunction("lseek");
        this.unlinkPtr = jnaNativeLibrary.getFunction("unlink");
    }

    public static class statImpl
    extends Structure {
        public static final int EPERM = 1;
        public static final int STAT_SIZE = NativeLibrary.getDefaultInstance().getGlobalVariableAddress("sysSIZEOFSTAT", 4).getInt(0L);

        protected statImpl() {
        }

        public int size() {
            return STAT_SIZE;
        }

        public void read() {
            Pointer p = this.getPointer();
            LibC.stat o = (LibC.stat)this;
            o.st_mode = p.getShort(8L);
            o.st_mtime = p.getInt(32L);
            o.st_size = p.getLong(48L);
        }

        public void write() {
            Pointer p = this.getPointer();
            LibC.stat o = (LibC.stat)this;
            p.setShort(8L, (short)o.st_mode);
            p.setInt(32L, o.st_mtime);
            p.setLong(48L, o.st_size);
        }
    }
}

