/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.realtime;

import com.sun.squawk.Address;
import com.sun.squawk.GC;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.UWord;
import com.sun.squawk.VM;
import com.sun.squawk.realtime.OffsetOutOfBoundsException;
import com.sun.squawk.realtime.SizeOutOfBoundsException;

public class RawMemoryAccess {
    protected Address vbase;
    private final UWord reachable_size;
    private static final int SHARED = 0;
    private static final int MALLOCED = 1;
    private static final int STACK = 2;
    private final byte state;

    public RawMemoryAccess(Object type, long size) throws SizeOutOfBoundsException, OutOfMemoryError {
        int sz = (int)size;
        if (sz < 0) {
            throw new SizeOutOfBoundsException();
        }
        this.reachable_size = UWord.fromPrimitive(sz);
        this.vbase = NativeUnsafe.malloc(this.reachable_size);
        if (this.vbase.isZero()) {
            throw new OutOfMemoryError("malloc failed in RawMemoryAccess");
        }
        this.state = 1;
    }

    public RawMemoryAccess(Object type, long base, long size) throws SizeOutOfBoundsException, OffsetOutOfBoundsException {
        int bs = (int)base;
        int sz = (int)size;
        if (sz < 0) {
            throw new SizeOutOfBoundsException();
        }
        this.state = 0;
        this.reachable_size = UWord.fromPrimitive(sz);
        if (type instanceof RawMemoryAccess) {
            RawMemoryAccess parent = (RawMemoryAccess)type;
            if (bs + sz < 0) {
                throw new OffsetOutOfBoundsException();
            }
            if (bs + sz > parent.reachable_size.toPrimitive()) {
                throw new SizeOutOfBoundsException();
            }
            if (parent.vbase.isZero()) {
                throw new SizeOutOfBoundsException();
            }
            this.vbase = parent.vbase.add(bs);
        } else {
            this.vbase = Address.fromPrimitive(bs);
            if (this.vbase.isZero() && !this.reachable_size.isZero()) {
                throw new SizeOutOfBoundsException();
            }
            if (GC.isGCEnabled() && GC.inRam(this.vbase, this.vbase.add(sz))) {
                throw new SecurityException("invalid memory range - base: " + base + ", size: " + size);
            }
        }
    }

    final void checkRead(int offset, int size) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        RawMemoryAccess.checkBounds(this.reachable_size.toPrimitive(), offset, size);
        if (this.vbase.isZero()) {
            throw new SizeOutOfBoundsException();
        }
    }

    protected final void checkMultiRead(int offset, int number, int elemsize) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        RawMemoryAccess.checkMultiBounds(this.reachable_size.toInt(), offset, number, elemsize);
        if (this.vbase.isZero()) {
            throw new SizeOutOfBoundsException();
        }
    }

    protected static void checkMultiBounds(int length, int offset, int number, int elemsize) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        if (number < 0) {
            throw new IllegalArgumentException();
        }
        int bsize = number * elemsize;
        if (bsize < 0) {
            throw new OffsetOutOfBoundsException();
        }
        if (offset < 0 || offset > length - bsize) {
            throw new OffsetOutOfBoundsException();
        }
    }

    public byte getByte(long offset) {
        int off = (int)offset;
        this.checkRead(off, 1);
        return (byte)NativeUnsafe.getByte(this.vbase, off);
    }

    public void getBytes(long offset, byte[] bytes, int low, int number) {
        int off = (int)offset;
        this.checkMultiRead(off, number, 1);
        VM.getData(this.vbase, off, bytes, low, number, 1);
    }

    public int getInt(long offset) {
        int off = (int)offset;
        this.checkRead(off, 4);
        return NativeUnsafe.getUnalignedInt(this.vbase, off);
    }

    public void getInts(long offset, int[] ints, int low, int number) {
        int off = (int)offset;
        this.checkMultiRead(off, number, 4);
        VM.getData(this.vbase, off, ints, low, number, 4);
    }

    public long getLong(long offset) {
        int off = (int)offset;
        this.checkRead(off, 8);
        return NativeUnsafe.getUnalignedLong(this.vbase, off);
    }

    public void getLongs(long offset, long[] longs, int low, int number) {
        int off = (int)offset;
        this.checkMultiRead(off, number, 8);
        VM.getData(this.vbase, off, longs, low, number, 4);
    }

    public long getMappedAddress() {
        return this.vbase.toUWord().toPrimitive();
    }

    protected final Address getAddress() {
        return this.vbase;
    }

    protected final UWord size() {
        return this.reachable_size;
    }

    public short getShort(long offset) {
        int off = (int)offset;
        this.checkRead(off, 2);
        return (short)NativeUnsafe.getUnalignedShort(this.vbase, off);
    }

    public void getShorts(long offset, short[] shorts, int low, int number) {
        int off = (int)offset;
        this.checkMultiRead(off, number, 2);
        VM.getData(this.vbase, off, shorts, low, number, 2);
    }

    public long map() throws OutOfMemoryError {
        return -1L;
    }

    public long map(long base) {
        return -1L;
    }

    public long map(long base, long size) {
        return -1L;
    }

    protected static void checkBounds(int length, int offset, int size) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        if (offset < 0 || offset > length - size) {
            throw new OffsetOutOfBoundsException();
        }
    }

    final void checkWrite(int offset, int size) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        RawMemoryAccess.checkBounds(this.reachable_size.toPrimitive(), offset, size);
        if (this.vbase.isZero()) {
            throw new SizeOutOfBoundsException();
        }
    }

    protected final void checkMultiWrite(int offset, int number, int elemsize) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        RawMemoryAccess.checkMultiBounds(this.reachable_size.toInt(), offset, number, elemsize);
        if (this.vbase.isZero()) {
            throw new SizeOutOfBoundsException();
        }
    }

    public void setByte(long offset, byte value) {
        int off = (int)offset;
        this.checkWrite(off, 1);
        NativeUnsafe.setByte(this.vbase, off, value);
    }

    public void setBytes(long offset, byte[] bytes, int low, int number) {
        int off = (int)offset;
        this.checkMultiWrite(off, number, 1);
        VM.setData(this.vbase, off, bytes, low, number, 1);
    }

    public void setInt(long offset, int value) {
        int off = (int)offset;
        this.checkWrite(off, 4);
        NativeUnsafe.setUnalignedInt(this.vbase, off, value);
    }

    public void setInts(long offset, int[] ints, int low, int number) {
        int off = (int)offset;
        this.checkMultiWrite(off, number, 4);
        VM.setData(this.vbase, off, ints, low, number, 4);
    }

    public void setLong(long offset, long value) {
        int off = (int)offset;
        this.checkWrite(off, 8);
        NativeUnsafe.setUnalignedLong(this.vbase, off, value);
    }

    public void setLongs(long offset, long[] longs, int low, int number) {
        int off = (int)offset;
        this.checkMultiWrite(off, number, 8);
        VM.setData(this.vbase, off, longs, low, number, 8);
    }

    public void setShort(long offset, short value) {
        int off = (int)offset;
        this.checkWrite(off, 2);
        NativeUnsafe.setUnalignedShort(this.vbase, off, value);
    }

    public void setShorts(long offset, short[] shorts, int low, int number) {
        int off = (int)offset;
        this.checkMultiWrite(off, number, 2);
        VM.setData(this.vbase, off, shorts, low, number, 2);
    }

    protected boolean wasMalloced() {
        return this.state == 1;
    }

    protected final void invalidate() {
        this.vbase = Address.zero();
    }
}

