/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.realtime;

import com.sun.squawk.VM;
import com.sun.squawk.realtime.RawMemoryAccess;
import com.sun.squawk.realtime.SizeOutOfBoundsException;

public class RawMemoryFloatAccess
extends RawMemoryAccess {
    public RawMemoryFloatAccess(Object type, long size) throws SizeOutOfBoundsException, OutOfMemoryError {
        super(type, size);
    }

    public RawMemoryFloatAccess(Object type, long base, long size) {
        super(type, base, size);
    }

    public double getDouble(long offset) {
        return VM.longBitsToDouble(this.getLong(offset));
    }

    public void getDoubles(long offset, double[] doubles, int low, int number) {
        int off = (int)offset;
        this.checkMultiRead(off, number, 8);
        VM.getData(this.vbase, off, doubles, low, number, 8);
    }

    public float getFloat(long offset) {
        return VM.intBitsToFloat(this.getInt(offset));
    }

    public void getFloats(long offset, float[] floats, int low, int number) {
        int off = (int)offset;
        this.checkMultiRead(off, number, 4);
        VM.getData(this.vbase, off, floats, low, number, 4);
    }

    public void setDouble(long offset, double value) {
        this.setLong(offset, VM.doubleToLongBits(value));
    }

    public void setDoubles(long offset, double[] doubles, int low, int number) {
        int off = (int)offset;
        this.checkMultiWrite(off, number, 8);
        VM.setData(this.vbase, off, doubles, low, number, 8);
    }

    public void setFloat(long offset, float value) {
        this.setInt(offset, VM.floatToIntBits(value));
    }

    public void setFloats(long offset, float[] floats, int low, int number) {
        int off = (int)offset;
        this.checkMultiWrite(off, number, 4);
        VM.setData(this.vbase, off, floats, low, number, 4);
    }
}

