/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.security.ecc;

import com.sun.squawk.security.ecc.ECCurveFp;
import com.sun.squawk.security.ecc.FFA;

public class ECPoint {
    public int[] x;
    public int[] y;
    public int[] z;
    protected final ECCurveFp curve;
    protected final FFA ffa;

    private ECPoint(ECPoint p) {
        this.curve = p.curve;
        this.ffa = this.curve.getField().getFFA();
        this.x = this.ffa.acquireVar();
        this.y = this.ffa.acquireVar();
        this.z = this.ffa.acquireVar();
        this.ffa.copy(this.x, p.x);
        this.ffa.copy(this.y, p.y);
        this.ffa.copy(this.z, p.z);
    }

    public ECPoint(ECCurveFp curve, int[] x, int[] y) {
        this.curve = curve;
        this.ffa = curve.getField().getFFA();
        this.x = x;
        this.y = y;
        this.z = this.ffa.acquireVar();
        this.ffa.set(this.z, 1);
    }

    public ECPoint(ECCurveFp curve) {
        this.curve = curve;
        this.ffa = curve.getField().getFFA();
        this.x = this.ffa.acquireVar();
        this.y = this.ffa.acquireVar();
        this.z = this.ffa.acquireVar();
    }

    public Object clone() {
        return this.clonePoint();
    }

    public ECPoint clonePoint() {
        return new ECPoint(this);
    }

    public void release() {
        this.ffa.releaseVar(this.x);
        this.ffa.releaseVar(this.y);
        this.ffa.releaseVar(this.z);
    }
}

