/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

import com.sun.squawk.ResourceFile;
import com.sun.squawk.VM;
import com.sun.squawk.io.connections.ClasspathConnection;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.LineReader;
import com.sun.squawk.util.StringTokenizer;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;

public class ArgsUtilities {
    public static final String[] skipList = new String[]{".svn", ".DS_Store"};

    private static boolean nameInSkipList(String name) {
        for (int i = 0; i < skipList.length; ++i) {
            String skipTarget = skipList[i] + VM.getFileSeparatorChar();
            if (name.startsWith(skipTarget)) {
                return true;
            }
            if (name.indexOf(VM.getFileSeparatorChar() + skipTarget) < 0) continue;
            return true;
        }
        return false;
    }

    private ArgsUtilities() {
    }

    public static void readLines(String file, Vector lines) {
        try {
            InputStream is = Connector.openInputStream("file://" + file);
            InputStreamReader isr = new InputStreamReader(is);
            LineReader lr = new LineReader(isr);
            lr.readLines(lines);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error while processing file '" + file + "': " + ioe);
        }
    }

    public static void readArgFile(String name, Vector args) {
        Vector lines = new Vector();
        ArgsUtilities.readLines(name, lines);
        Enumeration e = lines.elements();
        while (e.hasMoreElements()) {
            String line = (String)e.nextElement();
            StringTokenizer st = new StringTokenizer(line);
            while (st.hasMoreTokens()) {
                args.addElement(st.nextToken());
            }
        }
    }

    public static String[] expandArgFiles(String[] args) {
        Vector expanded = new Vector(args.length);
        for (int i = 0; i != args.length; ++i) {
            String arg = args[i];
            if (arg.charAt(0) == '@') {
                ArgsUtilities.readArgFile(arg.substring(1), expanded);
                continue;
            }
            expanded.addElement(arg);
        }
        if (expanded.size() != args.length) {
            args = new String[expanded.size()];
            expanded.copyInto(args);
        }
        return args;
    }

    public static String toPlatformPath(String path, boolean isClassPath) {
        char fileSeparatorChar = VM.getFileSeparatorChar();
        if (fileSeparatorChar == '/') {
            path = path.replace('\\', '/');
        } else if (fileSeparatorChar == '\\') {
            path = path.replace('/', '\\');
        } else {
            throw new RuntimeException("OS with unknown separator: '" + fileSeparatorChar + "'");
        }
        if (isClassPath) {
            char pathSeparatorChar = VM.getPathSeparatorChar();
            if (pathSeparatorChar == ':') {
                path = path.replace(';', ':');
            } else if (pathSeparatorChar == ';') {
                char[] pathChars = path.toCharArray();
                int start = 0;
                for (int i = 0; i != pathChars.length; ++i) {
                    if (pathChars[i] == ';') {
                        start = i + 1;
                    }
                    if (pathChars[i] != ':' || i - start == 1) continue;
                    pathChars[i] = 59;
                    start = i + 1;
                }
                path = new String(pathChars);
            } else {
                throw new RuntimeException("OS with unknown path separator: '" + pathSeparatorChar + "'");
            }
        }
        return path;
    }

    public static void processClassListArg(String arg, Vector classes) {
        ArgsUtilities.readLines(arg, classes);
    }

    public static void processClassJarOrZipArg(String arg, Vector classes, Vector resources) {
        try {
            ClasspathConnection cp = (ClasspathConnection)Connector.open("classpath://" + arg);
            ArgsUtilities.processClasspathConnection(cp, classes, resources);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processClasspathConnection(ClasspathConnection cp, Vector classes, Vector resources) {
        try {
            dis = new DataInputStream(cp.openInputStream("//"));
            try {
                while (true) lbl-1000:
                // 5 sources

                {
                    if ((name = dis.readUTF()).endsWith(".class")) {
                        name = name.substring(0, name.length() - ".class".length());
                        name = name.replace('/', '.');
                        classes.addElement(name);
                        continue;
                    }
                    if (ArgsUtilities.nameInSkipList(name)) {
                        System.out.println("Skipping resource file: " + name);
                        continue;
                    }
                    try {
                        bytes = cp.getBytes(name);
                        resource = new ResourceFile(name, bytes);
                        resources.addElement(resource);
                    }
                    catch (IOException e) {
                        continue;
                    }
                    break;
                }
            }
            catch (EOFException ex) {
                dis.close();
                return;
            }
            ** GOTO lbl-1000
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void processClassArg(String arg, Vector classes, Vector resources) {
        if (arg.charAt(0) == '@') {
            arg = arg.substring(1);
            ArgsUtilities.processClassListArg(arg, classes);
        } else if (arg.endsWith(".zip") || arg.endsWith(".jar")) {
            ArgsUtilities.processClassJarOrZipArg(arg, classes, resources);
        } else {
            DataInputStream dis = null;
            try {
                dis = Connector.openDataInputStream("file://" + arg + "//");
                try {
                    int baseDirPrefix = arg.length() + 1;
                    while (true) {
                        String name;
                        int indexOfExclude;
                        String fullName;
                        if ((fullName = dis.readUTF()).indexOf(".svn/") != -1 || (indexOfExclude = (name = fullName.substring(baseDirPrefix)).indexOf(".svn/")) != -1 || (indexOfExclude = name.indexOf(".hg/")) != -1 || (indexOfExclude = name.indexOf("CVS/")) != -1 || fullName.endsWith(".DS_Store")) {
                            continue;
                        }
                        if (name.endsWith(".class")) {
                            name = name.substring(0, name.length() - ".class".length());
                            name = name.replace('/', '.');
                            classes.addElement(name);
                            continue;
                        }
                        if (ArgsUtilities.nameInSkipList(name)) {
                            System.out.println("Skipping resource file: " + name);
                            continue;
                        }
                        InputStream input = null;
                        try {
                            int read;
                            input = Connector.openInputStream("file://" + fullName);
                            ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
                            byte[] buffer = new byte[256];
                            int bufferSize = buffer.length;
                            while ((read = input.read(buffer, 0, bufferSize)) != -1) {
                                output.write(buffer, 0, read);
                            }
                            buffer = output.toByteArray();
                            ResourceFile resource = new ResourceFile(name, buffer);
                            resources.addElement(resource);
                        }
                        catch (IOException e) {
                            if (input == null) continue;
                            try {
                                input.close();
                            }
                            catch (IOException e1) {}
                        }
                    }
                }
                catch (EOFException ex) {
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            Assert.shouldNotReachHere("ArgsUtilities.java", 328);
                        }
                    }
                    return;
                }
            }
            catch (ConnectionNotFoundException e) {
                classes.addElement(arg);
            }
            catch (IOException ioe) {
                throw new RuntimeException("error parsing '" + arg + "': " + ioe);
            }
            finally {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        Assert.shouldNotReachHere("ArgsUtilities.java", 328);
                    }
                }
            }
        }
    }

    public static String[] cut(String str) {
        StringTokenizer st = new StringTokenizer(str, " ");
        String[] res = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            res[i++] = st.nextToken();
        }
        return res;
    }

    public static String getOptArg(String[] args, int index, String opt) {
        if (index >= args.length) {
            return null;
        }
        return args[index];
    }
}

