/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

import com.sun.squawk.util.ArrayHashtableEntry;
import com.sun.squawk.util.Arrays;
import com.sun.squawk.util.SquawkHashtable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class ArrayHashtable {
    private transient ArrayHashtableEntry[] table;
    private transient int count;
    private int threshold;
    private static final int loadFactorPercent = 75;

    public ArrayHashtable(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.table = new ArrayHashtableEntry[initialCapacity];
        this.threshold = initialCapacity * 75 / 100;
    }

    public ArrayHashtable() {
        this(11);
    }

    public ArrayHashtable(ArrayHashtable original) {
        this(original.table.length);
        ArrayHashtableEntry[] originalEntries = original.table;
        int max = originalEntries.length;
        for (int i = 0; i < max; ++i) {
            ArrayHashtableEntry originalEntry = originalEntries[i];
            while (originalEntry != null) {
                this.put(originalEntry.key, originalEntry.value);
                originalEntry = originalEntry.next;
            }
        }
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new ArrayHashtableEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new ArrayHashtableEnumerator(this.table, false);
    }

    public boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        ArrayHashtableEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            ArrayHashtableEntry e = tab[i];
            while (e != null) {
                if (e.valueEquals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public Object get(Object key) {
        ArrayHashtableEntry[] tab = this.table;
        int hash = Arrays.hashCode(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        ArrayHashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash() == hash && e.keyEquals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        ArrayHashtableEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        ArrayHashtableEntry[] newTable = new ArrayHashtableEntry[newCapacity];
        this.threshold = newCapacity * 75 / 100;
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            ArrayHashtableEntry old = oldTable[i];
            while (old != null) {
                ArrayHashtableEntry e = old;
                old = old.next;
                int index = (e.hash() & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        ArrayHashtableEntry[] tab = this.table;
        int hash = Arrays.hashCode(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        ArrayHashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash() == hash && e.keyEquals(key)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        e = new ArrayHashtableEntry();
        e.hash(hash);
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return null;
    }

    public Object remove(Object key) {
        ArrayHashtableEntry[] tab = this.table;
        int hash = Arrays.hashCode(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        ArrayHashtableEntry e = tab[index];
        ArrayHashtableEntry prev = null;
        while (e != null) {
            if (e.hash() == hash && e.keyEquals(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public void clear() {
        ArrayHashtableEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public String toString() {
        return SquawkHashtable.enumerationsToString(this.keys(), this.elements(), this.size());
    }

    static class ArrayHashtableEnumerator
    implements Enumeration {
        boolean keys;
        int index;
        ArrayHashtableEntry[] table;
        ArrayHashtableEntry entry;

        ArrayHashtableEnumerator(ArrayHashtableEntry[] table, boolean keys) {
            this.table = table;
            this.keys = keys;
            this.index = table.length;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                ArrayHashtableEntry e = this.entry;
                this.entry = e.next;
                return this.keys ? e.key : e.value;
            }
            throw new NoSuchElementException();
        }
    }
}

