/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

import com.sun.squawk.util.IntHashtableEntry;
import com.sun.squawk.util.IntHashtableVisitor;
import com.sun.squawk.util.SquawkHashtable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class IntHashtable {
    protected IntHashtableEntry[] table;
    protected int count;
    protected int threshold;
    private static final int loadFactorPercent = 75;

    public IntHashtable(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.table = new IntHashtableEntry[initialCapacity];
        this.threshold = initialCapacity * 75 / 100;
    }

    public IntHashtable() {
        this(11);
    }

    public final int size() {
        return this.count;
    }

    public final boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new HashtableEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new HashtableEnumerator(this.table, false);
    }

    public void visit(IntHashtableVisitor visitor) {
        int index = this.table.length;
        IntHashtableEntry entry = null;
        while (true) {
            if (entry == null) {
                while (index-- > 0 && (entry = this.table[index]) == null) {
                }
            }
            if (entry == null) break;
            visitor.visitIntHashtable(entry.key, entry.value);
            entry = entry.next;
        }
    }

    public boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        IntHashtableEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            IntHashtableEntry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    public Object get(int key) {
        IntHashtableEntry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        IntHashtableEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        IntHashtableEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        IntHashtableEntry[] newTable = new IntHashtableEntry[newCapacity];
        this.threshold = newCapacity * 75 / 100;
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            IntHashtableEntry old = oldTable[i];
            while (old != null) {
                IntHashtableEntry e = old;
                old = old.next;
                int index = (e.key & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public Object put(int key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        IntHashtableEntry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        IntHashtableEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (key & Integer.MAX_VALUE) % tab.length;
        }
        e = new IntHashtableEntry();
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return null;
    }

    public Object remove(int key) {
        IntHashtableEntry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        IntHashtableEntry e = tab[index];
        IntHashtableEntry prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public void clear() {
        IntHashtableEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public String toString() {
        return SquawkHashtable.enumerationsToString(this.keys(), this.elements(), this.size());
    }

    static class HashtableEnumerator
    implements Enumeration {
        boolean keys;
        int index;
        IntHashtableEntry[] table;
        IntHashtableEntry entry;

        HashtableEnumerator(IntHashtableEntry[] table, boolean keys) {
            this.table = table;
            this.keys = keys;
            this.index = table.length;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                IntHashtableEntry e = this.entry;
                this.entry = e.next;
                return this.keys ? new Integer(e.key) : e.value;
            }
            throw new NoSuchElementException();
        }
    }
}

