/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

import com.sun.cldchi.jvm.JVM;

public final class IntSet {
    protected int[] elementData;
    protected int elementCount;

    public IntSet(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elementData = new int[initialCapacity];
    }

    public IntSet() {
        this(10);
    }

    public int[] getElements() {
        return this.elementData;
    }

    private void ensureCapacityHelper(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int[] oldData = this.elementData;
        int newCapacity = oldCapacity * 2;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.elementData = new int[newCapacity];
        JVM.unchecked_int_arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean contains(int elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    private int indexOf(int elem, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public void add(int val) {
        int newcount = this.elementCount + 1;
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this.elementData[this.elementCount++] = val;
    }

    public boolean remove(int val) {
        int i = this.indexOf(val, 0);
        if (i >= 0) {
            int j = this.elementCount - i - 1;
            if (j > 0) {
                JVM.unchecked_int_arraycopy(this.elementData, i + 1, this.elementData, i, j);
            }
            --this.elementCount;
            return true;
        }
        return false;
    }

    public void removeAll() {
        this.elementCount = 0;
    }
}

