/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class SimpleLinkedList {
    final Entry header = new Entry();
    int size;

    public Object getFirst() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        return this.header.next.element;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        return this.header.previous.element;
    }

    public Object removeFirst() {
        return this.remove(this.header.next);
    }

    public Object removeLast() {
        return this.remove(this.header.previous);
    }

    public void addFirst(Object o) {
        this.addBefore(o, this.header.next);
    }

    public void addLast(Object o) {
        this.addBefore(o, this.header.next);
    }

    public final int size() {
        return this.size;
    }

    public boolean remove(Object o) {
        if (o == null) {
            Entry e = this.header.next;
            while (e != this.header) {
                if (e.element == null) {
                    this.remove(e);
                    return true;
                }
                e = e.next;
            }
        } else {
            Entry e = this.header.next;
            while (e != this.header) {
                if (o.equals(e.element)) {
                    this.remove(e);
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            Entry e = this.header.next;
            while (e != this.header) {
                if (e.element == null) {
                    return index;
                }
                ++index;
                e = e.next;
            }
        } else {
            Entry e = this.header.next;
            while (e != this.header) {
                if (o.equals(e.element)) {
                    return index;
                }
                ++index;
                e = e.next;
            }
        }
        return -1;
    }

    public void clear() {
        Entry e = this.header.next;
        while (e != this.header) {
            Entry next = e.next;
            e.previous = null;
            e.next = null;
            e.element = null;
            e = next;
        }
        this.header.next = this.header.previous = this.header;
        this.size = 0;
    }

    public Enumeration elements() {
        return new SimpleLinkedListEnumerator(this);
    }

    private void addBefore(Object element, Entry e) {
        Entry newEntry;
        newEntry.previous.next = newEntry = new Entry(element, e, e.previous);
        newEntry.next.previous = newEntry;
        ++this.size;
    }

    private Object remove(Entry e) {
        if (e.next == e) {
            throw new NoSuchElementException();
        }
        Object result = e.element;
        e.previous.next = e.next;
        e.next.previous = e.previous;
        --this.size;
        return result;
    }

    private static final class SimpleLinkedListEnumerator
    implements Enumeration {
        SimpleLinkedList list;
        Entry pointer;

        SimpleLinkedListEnumerator(SimpleLinkedList l) {
            this.list = l;
            this.pointer = this.list.header.next;
        }

        public boolean hasMoreElements() {
            return this.pointer != this.list.header;
        }

        public Object nextElement() {
            if (this.pointer == this.list.header) {
                throw new NoSuchElementException();
            }
            Object element = this.pointer.element;
            this.pointer = this.pointer.next;
            return element;
        }
    }

    private static final class Entry {
        Object element;
        Entry next;
        Entry previous;

        Entry(Object element, Entry next, Entry previous) {
            this.element = element;
            this.next = next;
            this.previous = previous;
        }

        Entry() {
            this.next = this;
            this.previous = this;
        }
    }
}

