/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

import com.sun.squawk.util.HashtableEntry;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class SquawkHashtable {
    private transient HashtableEntry[] entryTable;
    private HashtableEntry[] backupTable;
    private int count;
    private int threshold;
    private Rehasher rehasher;
    private static final int loadFactorPercent = 75;

    public SquawkHashtable(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.setTable(new HashtableEntry[initialCapacity]);
        this.threshold = initialCapacity * 75 / 100;
    }

    public final SquawkHashtable setRehasher(Rehasher rehasher) {
        this.rehasher = rehasher;
        return this;
    }

    private void setTable(HashtableEntry[] table) {
        this.entryTable = table;
        this.backupTable = table;
    }

    private HashtableEntry[] getTable() {
        if (this.entryTable == null) {
            this.rehash(this.backupTable, this.backupTable.length);
        }
        return this.entryTable;
    }

    public SquawkHashtable() {
        this(11);
    }

    public final int size() {
        return this.count;
    }

    public final boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new HashtableEnumerator(this.getTable(), true);
    }

    public Enumeration elements() {
        return new HashtableEnumerator(this.getTable(), false);
    }

    public boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        HashtableEntry[] tab = this.getTable();
        int i = tab.length;
        while (i-- > 0) {
            HashtableEntry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public Object get(Object key) {
        HashtableEntry[] tab = this.getTable();
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        HashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public void rehash() {
        HashtableEntry[] oldTable = this.getTable();
        this.rehash(oldTable, oldTable.length * 2 + 1);
    }

    private void rehash(HashtableEntry[] oldTable, int newCapacity) {
        this.setTable(null);
        int oldCapacity = oldTable.length;
        HashtableEntry[] newTable = new HashtableEntry[newCapacity];
        this.threshold = newCapacity * 75 / 100;
        int i = oldCapacity;
        while (i-- > 0) {
            HashtableEntry old = oldTable[i];
            while (old != null) {
                HashtableEntry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
        this.setTable(newTable);
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        HashtableEntry[] tab = this.getTable();
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        HashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            if (this.rehasher != null) {
                this.rehasher.rehash();
            } else {
                this.rehash();
            }
            tab = this.getTable();
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        e = new HashtableEntry();
        e.hash = hash;
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return null;
    }

    public Object remove(Object key) {
        HashtableEntry[] tab = this.getTable();
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        HashtableEntry e = tab[index];
        HashtableEntry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public void clear() {
        HashtableEntry[] tab = this.getTable();
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public String toString() {
        return SquawkHashtable.enumerationsToString(this.keys(), this.elements(), this.size());
    }

    public final int capacity() {
        return this.entryTable.length;
    }

    public final HashtableEntry[] getEntryTable() {
        return this.entryTable;
    }

    public static String enumerationsToString(Enumeration keys, Enumeration elements, int size) {
        int max = size - 1;
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            String s1 = keys.nextElement().toString();
            String s2 = elements.nextElement().toString();
            buf.append(s1 + "=" + s2);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    class HashtableEnumerator
    implements Enumeration {
        boolean keys;
        int index;
        HashtableEntry[] table;
        HashtableEntry entry;

        HashtableEnumerator(HashtableEntry[] table, boolean keys) {
            this.table = table;
            this.keys = keys;
            this.index = table.length;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                HashtableEntry e = this.entry;
                this.entry = e.next;
                return this.keys ? e.key : e.value;
            }
            throw new NoSuchElementException();
        }
    }

    public static interface Rehasher {
        public void rehash();
    }
}

