/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.sun.squawk.VMThread;

public class Thread
implements Runnable {
    private final VMThread vmThread;
    private Runnable target;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;

    public static Thread currentThread() {
        return VMThread.currentThread().getAPIThread();
    }

    public static void yield() {
        VMThread.yield();
    }

    public static void sleep(long millis) throws InterruptedException {
        VMThread.sleep(millis);
    }

    public Thread() {
        this.vmThread = new VMThread(this, null);
    }

    public Thread(Runnable target) {
        this.target = target;
        this.vmThread = new VMThread(this, null);
    }

    public Thread(Runnable target, String name) {
        this.target = target;
        this.vmThread = new VMThread(this, name);
    }

    public Thread(String name) {
        this.vmThread = new VMThread(this, name);
    }

    public synchronized void start() {
        this.vmThread.start();
    }

    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    public void interrupt() {
        this.vmThread.interrupt();
    }

    public final boolean isAlive() {
        return this.vmThread.isAlive();
    }

    public final void setPriority(int newPriority) {
        this.vmThread.setPriority(newPriority);
    }

    public final int getPriority() {
        return this.vmThread.getPriority();
    }

    public final String getName() {
        return this.vmThread.getName();
    }

    public static int activeCount() {
        return VMThread.activeCount();
    }

    public final void join() throws InterruptedException {
        this.vmThread.join();
    }

    public String toString() {
        return this.vmThread.toString();
    }
}

