/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.rms;

import com.sun.squawk.imp.ImpGlobal;
import com.sun.squawk.rms.IRecordStoreEntry;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordEnumerationImpl;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RecordStore {
    private int opencount;
    private IRecordStoreEntry recordStoreEntry;
    private String recordStoreName;
    private Vector recordListener;

    private RecordStore() {
    }

    private RecordStore(String recordStoreName, boolean create) throws RecordStoreException, RecordStoreNotFoundException {
        this();
        this.recordStoreName = recordStoreName;
        this.recordListener = new Vector(3);
        this.recordStoreEntry = ImpGlobal.getRecordStoreManager().getRecordStore(recordStoreName, create);
        if (this.recordStoreEntry == null) {
            throw new RecordStoreNotFoundException(recordStoreName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordStore openRecordStore(String recordStoreName, boolean createIfNecessary) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        Vector dbCache;
        Vector vector = dbCache = ImpGlobal.getRecordStoreDbCache();
        synchronized (vector) {
            RecordStore db;
            if (recordStoreName.length() > 32) {
                throw new RecordStoreException("record store name too long");
            }
            for (int n = 0; n < dbCache.size(); ++n) {
                db = (RecordStore)dbCache.elementAt(n);
                if (!db.getName().equals(recordStoreName)) continue;
                ++db.opencount;
                return db;
            }
            db = new RecordStore(recordStoreName, createIfNecessary);
            db.opencount = 1;
            dbCache.addElement(db);
            return db;
        }
    }

    public static String[] listRecordStores() {
        try {
            return ImpGlobal.getRecordStoreManager().getRecordStoreNames();
        }
        catch (RecordStoreException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRecordStore(String recordStoreName) throws RecordStoreException, RecordStoreNotFoundException {
        Vector dbCache;
        Vector vector = dbCache = ImpGlobal.getRecordStoreDbCache();
        synchronized (vector) {
            for (int n = 0; n < dbCache.size(); ++n) {
                RecordStore db = (RecordStore)dbCache.elementAt(n);
                if (!db.getName().equals(recordStoreName)) continue;
                throw new RecordStoreException("deleteRecordStore error: record store is still open");
            }
            boolean found = ImpGlobal.getRecordStoreManager().deleteRecordStore(recordStoreName);
            if (!found) {
                throw new RecordStoreNotFoundException("deleteRecordStore error: file not found");
            }
        }
    }

    public synchronized int addRecord(byte[] data, int offset, int numBytes) throws RecordStoreNotOpenException, RecordStoreException, RecordStoreFullException {
        this.checkOpen();
        if (data == null && numBytes > 0) {
            throw new NullPointerException("illegal arguments: null data,  numBytes > 0");
        }
        int recordId = this.recordStoreEntry.addRecord(data, offset, numBytes);
        this.notifyRecordAddedListeners(recordId);
        return recordId;
    }

    public synchronized void deleteRecord(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        this.checkOpen();
        this.recordStoreEntry.deleteRecord(recordId);
        this.notifyRecordDeletedListeners(recordId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeRecordStore() throws RecordStoreNotOpenException, RecordStoreException {
        Vector dbCache;
        Vector vector = dbCache = ImpGlobal.getRecordStoreDbCache();
        synchronized (vector) {
            this.checkOpen();
            --this.opencount;
            if (this.opencount <= 0) {
                dbCache.removeElement(this);
                if (!this.recordListener.isEmpty()) {
                    this.recordListener.removeAllElements();
                }
                this.recordStoreEntry = null;
            }
        }
    }

    public int getRecordSize(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        this.checkOpen();
        return this.recordStoreEntry.getRecordSize(recordId);
    }

    public synchronized int getRecord(int recordId, byte[] buffer, int offset) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        this.checkOpen();
        return this.recordStoreEntry.getRecord(recordId, buffer, offset);
    }

    public synchronized byte[] getRecord(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        this.checkOpen();
        byte[] data = this.recordStoreEntry.getRecord(recordId);
        return data;
    }

    public synchronized void setRecord(int recordId, byte[] newData, int offset, int numBytes) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException, RecordStoreFullException {
        this.checkOpen();
        if (newData == null && numBytes > 0) {
            throw new NullPointerException();
        }
        this.recordStoreEntry.setRecord(recordId, newData, offset, numBytes);
        this.notifyRecordChangedListeners(recordId);
    }

    public String getName() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.recordStoreName;
    }

    public int getVersion() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.recordStoreEntry.getVersion();
    }

    public int getNumRecords() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.recordStoreEntry.getNumRecords();
    }

    public int getSize() throws RecordStoreNotOpenException {
        this.checkOpen();
        try {
            return this.recordStoreEntry.getRecordsSize();
        }
        catch (RecordStoreException e) {
            throw new RecordStoreNotOpenException(e.getMessage());
        }
    }

    public int getSizeAvailable() throws RecordStoreNotOpenException {
        this.checkOpen();
        try {
            return ImpGlobal.getRecordStoreManager().getSizeAvailable();
        }
        catch (RecordStoreException e) {
            throw new RecordStoreNotOpenException("System error: " + e.getMessage());
        }
    }

    public long getLastModified() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.recordStoreEntry.getTimestamp();
    }

    public synchronized void addRecordListener(RecordListener listener) {
        if (!this.recordListener.contains(listener)) {
            this.recordListener.addElement(listener);
        }
    }

    public synchronized void removeRecordListener(RecordListener listener) {
        this.recordListener.removeElement(listener);
    }

    public int getNextRecordID() throws RecordStoreNotOpenException, RecordStoreException {
        this.checkOpen();
        return this.recordStoreEntry.getNextRecordId();
    }

    public RecordEnumeration enumerateRecords(RecordFilter filter, RecordComparator comparator, boolean keepUpdated) throws RecordStoreNotOpenException {
        this.checkOpen();
        return new RecordEnumerationImpl(this, filter, comparator, keepUpdated);
    }

    private void checkOpen() throws RecordStoreNotOpenException {
        if (this.recordStoreEntry == null) {
            throw new RecordStoreNotOpenException();
        }
    }

    private void notifyRecordChangedListeners(int recordId) {
        for (int i = 0; i < this.recordListener.size(); ++i) {
            RecordListener rl = (RecordListener)this.recordListener.elementAt(i);
            rl.recordChanged(this, recordId);
        }
    }

    private void notifyRecordAddedListeners(int recordId) {
        for (int i = 0; i < this.recordListener.size(); ++i) {
            RecordListener rl = (RecordListener)this.recordListener.elementAt(i);
            rl.recordAdded(this, recordId);
        }
    }

    private void notifyRecordDeletedListeners(int recordId) {
        for (int i = 0; i < this.recordListener.size(); ++i) {
            RecordListener rl = (RecordListener)this.recordListener.elementAt(i);
            rl.recordDeleted(this, recordId);
        }
    }

    int[] getRecordIDs() {
        return this.recordStoreEntry.getRecordIdsCopy();
    }
}

