/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.parser;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ws.commons.util.NamespaceContextImpl;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.parser.RecursiveTypeParserImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlRpcResponseParser
extends RecursiveTypeParserImpl {
    private int level;
    private boolean isSuccess;
    private int errorCode;
    private String errorMessage;
    private Throwable errorCause;

    public XmlRpcResponseParser(XmlRpcStreamRequestConfig pConfig, TypeFactory pTypeFactory) {
        super(pConfig, new NamespaceContextImpl(), pTypeFactory);
    }

    @Override
    protected void addResult(Object pResult) throws SAXException {
        if (this.isSuccess) {
            super.setResult(pResult);
        } else {
            Map map = (Map)pResult;
            Integer faultCode = (Integer)map.get("faultCode");
            if (faultCode == null) {
                throw new SAXParseException("Missing faultCode", this.getDocumentLocator());
            }
            try {
                this.errorCode = faultCode;
            }
            catch (NumberFormatException e) {
                throw new SAXParseException("Invalid faultCode: " + faultCode, this.getDocumentLocator());
            }
            this.errorMessage = (String)map.get("faultString");
            Object exception = map.get("faultCause");
            if (exception != null) {
                try {
                    byte[] bytes = (byte[])exception;
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    this.errorCause = (Throwable)ois.readObject();
                    ois.close();
                    bais.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.level = 0;
        this.isSuccess = false;
        this.errorCode = 0;
        this.errorMessage = null;
    }

    @Override
    public void startElement(String pURI, String pLocalName, String pQName, Attributes pAttrs) throws SAXException {
        switch (this.level++) {
            case 0: {
                if ("".equals(pURI) && "methodResponse".equals(pLocalName)) break;
                throw new SAXParseException("Expected methodResponse element, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
            }
            case 1: {
                if ("".equals(pURI) && "params".equals(pLocalName)) {
                    this.isSuccess = true;
                    break;
                }
                if ("".equals(pURI) && "fault".equals(pLocalName)) {
                    this.isSuccess = false;
                    break;
                }
                throw new SAXParseException("Expected params or fault element, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
            }
            case 2: {
                if (this.isSuccess) {
                    if ("".equals(pURI) && "param".equals(pLocalName)) break;
                    throw new SAXParseException("Expected param element, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                if ("".equals(pURI) && "value".equals(pLocalName)) {
                    this.startValueTag();
                    break;
                }
                throw new SAXParseException("Expected value element, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
            }
            case 3: {
                if (this.isSuccess) {
                    if ("".equals(pURI) && "value".equals(pLocalName)) {
                        this.startValueTag();
                        break;
                    }
                    throw new SAXParseException("Expected value element, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                super.startElement(pURI, pLocalName, pQName, pAttrs);
                break;
            }
            default: {
                super.startElement(pURI, pLocalName, pQName, pAttrs);
            }
        }
    }

    @Override
    public void endElement(String pURI, String pLocalName, String pQName) throws SAXException {
        switch (--this.level) {
            case 0: {
                if ("".equals(pURI) && "methodResponse".equals(pLocalName)) break;
                throw new SAXParseException("Expected /methodResponse element, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
            }
            case 1: {
                String tag = this.isSuccess ? "params" : "fault";
                if ("".equals(pURI) && tag.equals(pLocalName)) break;
                throw new SAXParseException("Expected /" + tag + " element, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
            }
            case 2: {
                if (this.isSuccess) {
                    if ("".equals(pURI) && "param".equals(pLocalName)) break;
                    throw new SAXParseException("Expected /param, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                if ("".equals(pURI) && "value".equals(pLocalName)) {
                    this.endValueTag();
                    break;
                }
                throw new SAXParseException("Expected /value, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
            }
            case 3: {
                if (this.isSuccess) {
                    if ("".equals(pURI) && "value".equals(pLocalName)) {
                        this.endValueTag();
                        break;
                    }
                    throw new SAXParseException("Expected /value, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                super.endElement(pURI, pLocalName, pQName);
                break;
            }
            default: {
                super.endElement(pURI, pLocalName, pQName);
            }
        }
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Throwable getErrorCause() {
        return this.errorCause;
    }
}

